/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtend;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemExtendRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanProductRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemStatisticsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanProductVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.DiscountAccountFeeGroupVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.DiscountAccountFeeVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.NextMonthPredictAccountFeeVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceStatisVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ActivityDetailPlanItemSdkServiceImpl
implements ActivityDetailPlanItemSdkService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;
    @Autowired(required=false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;
    @Autowired(required=false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityDetailPlanProductRepository activityDetailPlanProductRepository;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private SalesApprovalService salesApprovalService;
    @Autowired(required=false)
    private ActivityDetailPlanItemModifyService activityDetailPlanItemModifyService;
    @Autowired(required=false)
    private ActivityDetailPlanItemModifyRepository activityDetailPlanItemModifyRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemExtendRepository activityDetailPlanItemExtendRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Page<ActivityDetailPlanItemVo> findByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> page = this.activityDetailPlanItemService.findByConditions(pageable, activityDetailPlanItemDto);
        this.convertDictValue(page.getRecords());
        return page;
    }

    public List<ActivityDetailPlanItemVo> findByConditionsList(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        List<ActivityDetailPlanItemVo> list = this.activityDetailPlanItemService.findByConditionsList(activityDetailPlanItemDto);
        this.convertDictValue(list);
        return list;
    }

    private void convertDictValue(List<ActivityDetailPlanItemVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList dictCodeList = Lists.newArrayList((Object[])new String[]{"MDM_CUSTOMIZE_ORG"});
        Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
        HashMap dictMapMap = !org.springframework.util.CollectionUtils.isEmpty((Map)dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n)) : new HashMap();
        Map regionMap = (Map)dictMapMap.get("MDM_CUSTOMIZE_ORG");
        for (ActivityDetailPlanItemVo itemVo : list) {
            itemVo.setRegionName((String)regionMap.get(itemVo.getRegion()));
        }
    }

    public Set<String> findCustomer(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        if (activityDetailPlanItemDto == null) {
            return Sets.newHashSet();
        }
        Validate.notNull((Object)activityDetailPlanItemDto.getActivityBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityDetailPlanItemDto.getActivityEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)activityDetailPlanItemDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)activityDetailPlanItemDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List activityDetailPlanItems = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityDetailPlanItemRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ActivityDetailPlanItem::getBusinessUnitCode, (Object)activityDetailPlanItemDto.getBusinessUnitCode())).eq(ActivityDetailPlanItem::getBusinessFormatCode, (Object)activityDetailPlanItemDto.getBusinessFormatCode())).eq(StringUtils.isNotBlank((CharSequence)activityDetailPlanItemDto.getCustomerCode()), ActivityDetailPlanItem::getCustomerCode, (Object)activityDetailPlanItemDto.getCustomerCode())).between(ActivityDetailPlanItem::getActivityBeginDate, (Object)activityDetailPlanItemDto.getActivityBeginDate(), (Object)activityDetailPlanItemDto.getActivityEndDate())).select(new SFunction[]{ActivityDetailPlanItem::getCustomerCode}).list();
        if (CollectionUtils.isNotEmpty((Collection)activityDetailPlanItems)) {
            return activityDetailPlanItems.stream().filter(Objects::nonNull).map(ActivityDetailPlanItem::getCustomerCode).collect(Collectors.toSet());
        }
        return null;
    }

    public List<ActivityDetailPlanItemVo> findByCustomerCode(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        if (activityDetailPlanItemDto == null) {
            return Lists.newArrayList();
        }
        Validate.notNull((Object)activityDetailPlanItemDto.getActivityBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityDetailPlanItemDto.getActivityEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)activityDetailPlanItemDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)activityDetailPlanItemDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)activityDetailPlanItemDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List activityDetailPlanItems = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityDetailPlanItemRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ActivityDetailPlanItem::getBusinessUnitCode, (Object)activityDetailPlanItemDto.getBusinessUnitCode())).eq(ActivityDetailPlanItem::getBusinessFormatCode, (Object)activityDetailPlanItemDto.getBusinessFormatCode())).eq(ActivityDetailPlanItem::getCustomerCode, (Object)activityDetailPlanItemDto.getCustomerCode())).between(ActivityDetailPlanItem::getActivityBeginDate, (Object)activityDetailPlanItemDto.getActivityBeginDate(), (Object)activityDetailPlanItemDto.getActivityEndDate())).list();
        if (CollectionUtils.isEmpty((Collection)activityDetailPlanItems)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<ActivityDetailPlanItemVo> listByItemCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItemList = this.activityDetailPlanItemRepository.listByDetailCodeList(itemCodeList);
        if (CollectionUtils.isEmpty(activityDetailPlanItemList)) {
            return Lists.newArrayList();
        }
        List activityDetailPlanItemVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<ActivityDetailPlanBudget> budgetList = this.activityDetailPlanBudgetRepository.listByDetailCodeList(itemCodeList);
        if (!CollectionUtils.isEmpty(budgetList)) {
            List activityPlanBudgetVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetList, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Map<String, List<ActivityDetailPlanBudgetVo>> budgetMap = activityPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getDetailPlanItemCode));
            activityDetailPlanItemVos.forEach(activityPlanItemVo -> activityPlanItemVo.setBudgetShares((List)budgetMap.get(activityPlanItemVo.getDetailPlanItemCode())));
        }
        return activityDetailPlanItemVos;
    }

    public Page<ActivityDetailPlanItemVo> findForAudit(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return this.activityDetailPlanItemService.findForAudit(pageable, activityDetailPlanItemDto);
    }

    public int findTotalForAudit(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return this.activityDetailPlanItemService.findTotalForAudit(activityDetailPlanItemDto);
    }

    public Page<ActivityDetailPlanItemVo> findCanAutoAuditItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityDetailPlanItemRepository.findCanAutoAuditItemPage((Page<ActivityDetailPlanItemVo>)page, autoAuditParams);
    }

    public List<ActivityDetailPlanItemVo> findForAuditByCodes(Set<String> activityDetails) {
        return this.activityDetailPlanItemService.findForAuditByCodes(activityDetails);
    }

    public void changeActivityDetailAuditInfo(List<ActivityDetailPlanItemDto> activityDetailPlanItemDtos) {
        this.activityDetailPlanItemService.changeActivityDetailAuditInfo(activityDetailPlanItemDtos);
    }

    public void operationBudget(List<ActivityDetailPlanBudgetDto> operationBudgetList) {
        if (CollectionUtils.isEmpty(operationBudgetList)) {
            return;
        }
        Set detailItemCodeSet = operationBudgetList.stream().map(ActivityDetailPlanBudgetDto::getDetailPlanItemCode).collect(Collectors.toSet());
        List<ActivityDetailPlanItem> activityPlanItems = this.activityDetailPlanItemRepository.listByDetailCodeList(new ArrayList<String>(detailItemCodeSet));
        Map<String, List<ActivityDetailPlanBudgetDto>> planBudgetDtoMap = operationBudgetList.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetDto::getDetailPlanItemCode));
        Map itemMap = activityPlanItems.stream().collect(Collectors.toMap(ActivityDetailPlanItem::getDetailPlanItemCode, Function.identity()));
        planBudgetDtoMap.forEach((detailItemCode, detailBudgetDtoList) -> {
            ActivityDetailPlanItem activityPlanItem = (ActivityDetailPlanItem)((Object)((Object)itemMap.get(detailItemCode)));
            BigDecimal downAmount = Optional.ofNullable(activityPlanItem.getDownAmount()).orElse(BigDecimal.ZERO);
            activityPlanItem.setDownAmount(downAmount.add(detailBudgetDtoList.stream().map(ActivityDetailPlanBudgetDto::getThisDownAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)));
            BigDecimal add = Optional.ofNullable(activityPlanItem.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityPlanItem.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO));
            if (activityPlanItem.getDownAmount().compareTo(add) >= 0) {
                activityPlanItem.setIsAllDown(BooleanEnum.TRUE.getCapital());
            } else {
                activityPlanItem.setIsAllDown(BooleanEnum.FALSE.getCapital());
            }
            this.activityDetailPlanItemRepository.updateById((Object)activityPlanItem);
        });
    }

    public List<ActivityDetailPlanItemVo> findByActivityDetailItemCodes(Set<String> itemCodes) {
        return this.findByActivityDetailItemCodes(itemCodes, null);
    }

    public List<ActivityDetailPlanItemVo> findByActivityDetailItemCodes(Set<String> itemCodes, String businessUnitCode) {
        List<ActivityDetailPlanItem> itemList;
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(itemCodes), (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String activityDetailPlanRollbackBudget = null;
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            activityDetailPlanRollbackBudget = ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode();
        }
        if (CollectionUtils.isEmpty(itemList = this.activityDetailPlanItemRepository.findByActivityDetailItemCodes(itemCodes, activityDetailPlanRollbackBudget))) {
            return new ArrayList<ActivityDetailPlanItemVo>();
        }
        Collection activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanItemVos;
    }

    public Map<String, BigDecimal> statisticsFeeAmountByCusOrgCodes(ActivityDetailPlanItemStatisticsDto dto) {
        List<ActivityDetailPlanItemStatisticsVo> list = this.activityDetailPlanItemRepository.statisticsFeeAmountByCusOrgCodes(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(ActivityDetailPlanItemStatisticsVo::getCustomerCode, ActivityDetailPlanItemStatisticsVo::getTotalAmount));
        return map;
    }

    public Page<ActivityDetailPlanItemVo> findForWithholding(Pageable pageable, String operationType, ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemRepository.findByProcessStatusAndUpAccountStatus(pageable, dto, ProcessStatusEnum.PASS.getKey(), BooleanEnum.TRUE.getCapital());
    }

    public List<ActivityDetailPlanProductVo> findApportionProductByActivityDetailCodes(Set<String> activityDetailCodeSet) {
        List<ActivityDetailPlanProduct> activityDetailPlanProductEntities = this.activityDetailPlanProductRepository.findApportionProductByActivityDetailCodes(activityDetailCodeSet);
        if (CollectionUtils.isNotEmpty(activityDetailPlanProductEntities)) {
            Collection activityDetailPlanProductVos = this.nebulaToolkitService.copyCollectionByBlankList(activityDetailPlanProductEntities, ActivityDetailPlanProduct.class, ActivityDetailPlanProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)activityDetailPlanProductVos;
        }
        return new ArrayList<ActivityDetailPlanProductVo>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Page<ActivityDetailPlanItemVo> findUpwardDetailForWithholding(Pageable pageable, ActivityDetailPlanItemDto upwardDto) {
        List subComOrgVos;
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String upAccountStatus = BooleanEnum.TRUE.getCapital();
        String processStatus = ProcessStatusEnum.PASS.getKey();
        if (StringUtils.isNotEmpty((CharSequence)upwardDto.getSalesOrgCode())) {
            SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(upwardDto.getSalesOrgCode());
            if (salesOrgVo == null) throw new UnsupportedOperationException("\u672a\u67e5\u8be2\u5230\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            subComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgVo.getErpCode());
            upwardDto.setSalesOrgCode(null);
        } else {
            subComOrgVos = this.salesOrgSubComOrgService.findAll();
        }
        List customerErpCodeList = subComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).collect(Collectors.toList());
        List customerVoList = this.customerVoService.findByErpCodeList(customerErpCodeList);
        List customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        ArrayList<String> customerCodeInStrList = new ArrayList<String>();
        int pageNum = 0;
        int pageSize = 500;
        while (pageNum * pageSize < customerCodeList.size()) {
            if (pageNum * pageSize + pageSize > customerCodeList.size()) {
                customerCodeInStrList.add("('" + StringUtils.join(customerCodeList.subList(pageNum * pageSize, customerCodeList.size()), (String)"','") + "')");
            } else {
                customerCodeInStrList.add("('" + StringUtils.join(customerCodeList.subList(pageNum * pageSize, pageNum * pageSize + pageSize), (String)"','") + "')");
            }
            ++pageNum;
        }
        String dictTypeCode = "tpm_withholding_detail_exclude_activity_type";
        Map excludeActivityTypeMap = this.dictToolkitService.findMapByDictTypeCode(dictTypeCode);
        if (excludeActivityTypeMap.isEmpty()) return this.activityDetailPlanItemRepository.findUpwardDetailForWithholding((Page<ActivityDetailPlanItemVo>)page, customerCodeInStrList, upwardDto, upAccountStatus, processStatus, null);
        Set<String> excludeActivityTypeCodeSet = excludeActivityTypeMap.keySet();
        return this.activityDetailPlanItemRepository.findUpwardDetailForWithholding((Page<ActivityDetailPlanItemVo>)page, customerCodeInStrList, upwardDto, upAccountStatus, processStatus, excludeActivityTypeCodeSet);
    }

    public List<ActivityDetailPlanItemVo> findSubComActivityDetailByYearMonth(String yearMonth, List<String> subComCustomerErpCodeList) {
        String mainCode = BusinessUnitEnum.HEADQUARTERS.getCode();
        String beginDate = yearMonth + "-01";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate((String)beginDate, (String)"yyyy-MM-dd"));
        calendar.add(2, 1);
        String endDate = DateUtil.formatDate((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        ArrayList<String> inConditionList = new ArrayList<String>();
        int page = 0;
        int pageSize = 500;
        while (page * pageSize < subComCustomerErpCodeList.size()) {
            String inCondition;
            List<String> subCondition;
            if (page * pageSize + pageSize > subComCustomerErpCodeList.size()) {
                subCondition = subComCustomerErpCodeList.subList(page * pageSize, subComCustomerErpCodeList.size());
                inCondition = "('" + StringUtils.join(subCondition, (String)"','") + "')";
                inConditionList.add(inCondition);
            } else {
                subCondition = subComCustomerErpCodeList.subList(page * pageSize, page * pageSize + pageSize);
                inCondition = "('" + StringUtils.join(subCondition, (String)"','") + "')";
                inConditionList.add(inCondition);
            }
            ++page;
        }
        return this.activityDetailPlanItemRepository.findSubComActivityDetailByYearMonth(beginDate, endDate, mainCode, inConditionList);
    }

    public Map<String, BigDecimal> statisticsDetailPlanItemTotalFee(ActivityDetailPlanItemStatisticsDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (Objects.isNull(dto.getFeeYearMonth())) {
            return new HashMap<String, BigDecimal>();
        }
        List<ActivityDetailPlanItemStatisticsVo> list = this.activityDetailPlanItemRepository.statisticsDetailPlanItemTotalFee(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(ActivityDetailPlanItemStatisticsVo::getRetailerBrandRegionCode, ActivityDetailPlanItemStatisticsVo::getTotalAmount));
    }

    public Map<String, BigDecimal> statisNextMonthPredictAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getEndCaseForm())) {
            return new HashMap<String, BigDecimal>();
        }
        if (Objects.isNull(dto.getFeeYearMonth())) {
            return new HashMap<String, BigDecimal>();
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List<NextMonthPredictAccountFeeVo> feeVos = this.activityDetailPlanItemRepository.statisNextMonthPredictAccountFee(dto);
        if (CollectionUtils.isEmpty(feeVos)) {
            return map;
        }
        for (NextMonthPredictAccountFeeVo feeVo : feeVos) {
            String key = feeVo.getSystemCode() + "-" + feeVo.getRegion();
            if (map.containsKey(key)) {
                BigDecimal b = ((BigDecimal)map.get(key)).add(feeVo.getUnaccountedAmount());
                map.put(key, b);
                continue;
            }
            map.put(key, feeVo.getUnaccountedAmount());
        }
        return map;
    }

    public Map<String, BigDecimal> statisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)dto.getEndCaseForm())) {
            return new HashMap<String, BigDecimal>();
        }
        if (Objects.isNull(dto.getFeeYearMonth())) {
            return new HashMap<String, BigDecimal>();
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List<DiscountAccountFeeVo> feeVos = this.activityDetailPlanItemRepository.statisDiscountAccountFee(dto);
        if (CollectionUtils.isEmpty(feeVos)) {
            return map;
        }
        for (DiscountAccountFeeVo feeVo : feeVos) {
            String key = feeVo.getSystemCode() + "-" + feeVo.getRegion();
            if (map.containsKey(key)) {
                BigDecimal b = ((BigDecimal)map.get(key)).add(feeVo.getDiscountUpAccount());
                map.put(key, b);
                continue;
            }
            map.put(key, feeVo.getDiscountUpAccount());
        }
        return map;
    }

    public void apportionAmount(Map<String, BigDecimal> brandMap, Map<String, BigDecimal> map, String systemCode, String region, BigDecimal amount) {
        ArrayList<SalesPerformanceStatisVo> list = new ArrayList<SalesPerformanceStatisVo>();
        for (String s : brandMap.keySet()) {
            SalesPerformanceStatisVo vo = new SalesPerformanceStatisVo();
            vo.setBrand(s);
            vo.setStatisValue(brandMap.get(s));
        }
        list.sort(Comparator.comparing(SalesPerformanceStatisVo::getStatisValue));
        String key = systemCode + "-" + region + "-";
        BigDecimal total = list.stream().map(SalesPerformanceStatisVo::getStatisValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        boolean boo = total.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal rate = BigDecimal.ZERO;
        if (boo) {
            rate = BigDecimal.ONE.divide(new BigDecimal(list.size()), 6, 4);
        }
        BigDecimal totalRate = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); ++i) {
            BigDecimal r = BigDecimal.ZERO;
            r = boo ? (i == list.size() - 1 ? BigDecimal.ONE.subtract(totalRate) : rate) : (i == list.size() - 1 ? BigDecimal.ONE.subtract(totalRate) : ((SalesPerformanceStatisVo)list.get(i)).getStatisValue().divide(total, 6, 4));
            totalRate = totalRate.add(r);
            String key2 = key + ((SalesPerformanceStatisVo)list.get(i)).getBrand();
            if (map.containsKey(key2)) {
                BigDecimal b = map.get(key2).add(amount.multiply(r));
                map.put(key, b);
                continue;
            }
            map.put(key, amount.multiply(r));
        }
    }

    public void shareEquallyAmount(Map<String, String> brandMap, Map<String, BigDecimal> map, String systemCode, String region, BigDecimal amount) {
        String key = systemCode + "-" + region + "-";
        BigDecimal rate = BigDecimal.ONE.divide(new BigDecimal(brandMap.size()), 6, 4);
        int i = 0;
        BigDecimal totalRate = BigDecimal.ZERO;
        for (String s : brandMap.keySet()) {
            BigDecimal r = BigDecimal.ZERO;
            r = ++i == brandMap.size() ? BigDecimal.ONE.subtract(totalRate) : rate;
            totalRate = totalRate.add(r);
            String key2 = key + s;
            if (map.containsKey(key2)) {
                BigDecimal b = map.get(key2).add(amount.multiply(r));
                map.put(key, b);
                continue;
            }
            map.put(key, amount.multiply(r));
        }
    }

    public Map<String, String> findItemCodesByDetailPlanCodes(String planCode) {
        return this.activityDetailPlanItemService.findItemCodesByDetailPlanCodes(planCode);
    }

    public List<ActivityDetailPlanBudgetVo> findBudgetByCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return null;
        }
        List<ActivityDetailPlanBudget> activityDetailPlanBudgetList = this.activityDetailPlanBudgetRepository.findBudgetByCodes(detailPlanItemCodes);
        if (CollectionUtils.isEmpty(activityDetailPlanBudgetList)) {
            return null;
        }
        Collection activityDetailPlanBudgetVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanBudgetList, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanBudgetVos;
    }

    public List<ActivityDetailPlanItemVo> findByItemCodes(List<String> itemCodes) {
        if (CollectionUtil.isEmpty(itemCodes)) {
            return Collections.emptyList();
        }
        return this.activityDetailPlanItemService.findByItemCodes(itemCodes);
    }

    public List<ActivityDetailPlanItemVo> findDetailAndExtendByItemCodes(List<String> itemCodes) {
        return this.activityDetailPlanItemService.findDetailAndExtendByItemCodes(itemCodes);
    }

    public Integer getSubRelatedItemTotal(ActivityDetailPlanItemDto planItemDto) {
        Validate.notNull((Object)planItemDto, (String)"\u6761\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)planItemDto.getFeeYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)planItemDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.activityDetailPlanItemRepository.getSubRelatedItemTotal(planItemDto);
    }

    public List<ActivityDetailPlanItemVo> findSubRelatedCachePageList(Integer num, Integer pageSize, ActivityDetailPlanItemDto dto) {
        Validate.notNull((Object)dto, (String)"\u6761\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFeeYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        num = Optional.ofNullable(num).orElse(0);
        num = num * pageSize;
        List<ActivityDetailPlanItemVo> itemVoList = this.activityDetailPlanItemRepository.getDetailItemList(num, pageSize, dto);
        return itemVoList;
    }

    public BigDecimal findByCode(String detailPlanItemCode) {
        return this.activityDetailPlanItemRepository.findByCode(detailPlanItemCode);
    }

    public ActivityDetailPlanItemVo getActivityDetailPlanItemByCode(String itemCode) {
        return this.activityDetailPlanItemRepository.getDetailPlanItemByCode(itemCode);
    }

    public Integer getExtractAuditDetailPlanCheckDataTotal(ActivityDetailPlanItemDto selectDto) {
        if (Objects.isNull(selectDto)) {
            return 0;
        }
        return this.activityDetailPlanItemRepository.getExtractAuditDetailPlanCheckDataTotal(selectDto);
    }

    public List<ActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(ActivityDetailPlanItemDto selectDto, int pageNumber, int pageSize) {
        if (Objects.isNull(selectDto)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanItemRepository.extractAuditDetailPlanCheckData(selectDto, pageNumber *= pageSize, pageSize);
    }

    public List<ActivityDetailPlanItemVo> findByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty((CharSequence)planItemCode)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItemList = this.activityDetailPlanItemRepository.findListByRelatePlanItemCode(planItemCode);
        Collection activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanItemVos;
    }

    public List<ActivityDetailPlanItemVo> findByRegionPlanItemCodes(List<String> planItemCodes) {
        if (CollectionUtils.isEmpty(planItemCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItems = this.activityDetailPlanItemRepository.findByRegionPlanItemCodes(planItemCodes);
        if (CollectionUtils.isNotEmpty(activityDetailPlanItems)) {
            Collection activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)activityDetailPlanItemVos;
        }
        return Lists.newArrayList();
    }

    public Integer findByItemCodesOrPlanCods(Set<String> detailPlanItemCodes, Set<String> planCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes) && CollectionUtils.isEmpty(planCodes)) {
            return null;
        }
        return this.activityDetailPlanItemRepository.findByItemCodesOrPlanCods(detailPlanItemCodes, planCodes);
    }

    public List<ActivityDetailPlanItemVo> findByPlanCodes(Set<String> cods) {
        if (CollectionUtils.isEmpty(cods)) {
            return null;
        }
        return this.activityDetailPlanItemRepository.findByPlanCodes(cods);
    }

    public List<ActivityDetailPlanItemVo> listForVariable(ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemRepository.listForVariable(dto);
    }

    public List<ActivityDetailPlanItemVo> findListByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty((CharSequence)planItemCode)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanItem> activityDetailPlanItems = this.activityDetailPlanItemRepository.findByPlanItemCode(planItemCode);
        if (CollectionUtils.isEmpty(activityDetailPlanItems)) {
            return Lists.newArrayList();
        }
        Collection activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanItemVos;
    }

    public List<ActivityDetailPlanItemVo> findByPlanItemCodes(Set<String> set) {
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        return this.activityDetailPlanItemRepository.findByPlanItemCodes(set);
    }

    public List<String> findDetailItemCodesByPlanItemCodes(List<String> planItemCodes) {
        if (CollectionUtils.isNotEmpty(planItemCodes)) {
            return this.activityDetailPlanItemRepository.findDetailItemCodesByPlanItemCodes(planItemCodes);
        }
        return Lists.newArrayList();
    }

    public List<SalesApprovalVo> findPsmList(SalesApprovalDto salesApprovalDto) {
        List<SalesApprovalVo> psmList = this.activityDetailPlanApprovalActivityInfoRepository.findPsmList(salesApprovalDto);
        return psmList;
    }

    public List<ActivityDetailPlanItemVo> findByRelatePlanItemCodes(Set<String> set) {
        if (CollectionUtils.isNotEmpty(set)) {
            return this.activityDetailPlanItemRepository.findByRelatePlanItemCodes(set);
        }
        return Lists.newArrayList();
    }

    public void updateAuditStatusByActivityDetailCodes(List<String> newActivityDetailCodes, List<String> delActivityDetailCodes, ProcessStatusEnum processStatus) {
        if (CollectionUtils.isEmpty(newActivityDetailCodes) || CollectionUtils.isEmpty(delActivityDetailCodes)) {
            return;
        }
        this.activityDetailPlanItemRepository.updateAuditStatusByActivityDetailCodes(newActivityDetailCodes, delActivityDetailCodes, processStatus);
    }

    public List<ActivityDetailPlanItemDto> findListByDetailCodesForRedPayLedger(List<String> businessNoList) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanVo> activityDetailPlanVos = this.activityDetailPlanRepository.findByPlanCodes(new HashSet<String>(businessNoList));
        Map activityDetailPlanVoMap = activityDetailPlanVos.stream().collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, Function.identity()));
        List<ActivityDetailPlanItemDto> activityDetailPlanItemDtos = this.activityDetailPlanItemRepository.findListByDetailCodesForRedPayLedger(businessNoList);
        for (ActivityDetailPlanItemDto activityDetailPlanItemDto : activityDetailPlanItemDtos) {
            ActivityDetailPlanVo activityDetailPlanVo = (ActivityDetailPlanVo)activityDetailPlanVoMap.get(activityDetailPlanItemDto.getDetailPlanCode());
            activityDetailPlanItemDto.setDepartmentCode(activityDetailPlanVo.getDepartmentCode());
            activityDetailPlanItemDto.setDepartmentName(activityDetailPlanVo.getDepartmentName());
            activityDetailPlanItemDto.setDetailPlanName(activityDetailPlanVo.getDetailPlanName());
        }
        return activityDetailPlanItemDtos;
    }

    public List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> activityDetailCodes) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanBudgetRepository.findPlanItemCodeByActivityDetailItemCodes(activityDetailCodes);
    }

    public Page<DiscountAccountFeeGroupVo> findPageStatisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto, Pageable pageable) {
        return this.activityDetailPlanItemRepository.findPageStatisDiscountAccountFee(dto, pageable);
    }

    public Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(Pageable pageable, ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemService.findConditionByPlanCodes(pageable, dto);
    }

    public List<ActivityDetailPlanBudgetVo> findRegionIsRelateHead(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityDetailPlanBudgetVo> list = this.activityDetailPlanBudgetRepository.findRegionIsRelateHead(planCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<ActivityDetailPlanItemModifyDto> findModifyItemByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if (CollectionUtils.isEmpty(modifyBusinessCodes)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.activityDetailPlanItemModifyService.findModifyItemByModifyBusinessCodes(modifyBusinessCodes);
    }

    public List<ActivityDetailPlanItemVo> findListByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanCode)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanItemRepository.findListByDetailPlanCode(detailPlanCode);
    }

    public List<ActivityDetailPlanItemModifyDto> findDtoListByModifyCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanItemModifyRepository.findDtoListByModifyCode(modifyBusinessCode);
    }

    public void useProductNumber(ActivityDetailPlanItemVo item) {
        if (Objects.isNull(item) || StringUtils.isEmpty((CharSequence)item.getDetailPlanItemCode()) || Objects.isNull(item.getPeriodPromotionalNumberUse())) {
            return;
        }
        this.activityDetailPlanItemRepository.useProductNumber(item);
    }

    public void updateActivityDetailPurchasingOrder(String code, List<String> thisNewActivityDetailCodes, List<String> thisDelActivityDetailCodes) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return;
        }
        if (CollectionUtils.isEmpty(thisNewActivityDetailCodes) && CollectionUtils.isEmpty(thisDelActivityDetailCodes)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(thisNewActivityDetailCodes)) {
            this.initActivityDetailExtend(thisNewActivityDetailCodes);
        }
        this.activityDetailPlanItemRepository.updateActivityDetailPurchasingOrder(code, thisNewActivityDetailCodes, thisDelActivityDetailCodes);
    }

    private void initActivityDetailExtend(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return;
        }
        List<String> extendDetailPlanItemCodes = this.activityDetailPlanItemExtendRepository.findListByPlanItemCodes(detailPlanItemCodes);
        ArrayList<String> initDetailPlanCodes = new ArrayList<String>();
        for (String detailPlanItemCode : detailPlanItemCodes) {
            if (extendDetailPlanItemCodes.contains(detailPlanItemCode)) continue;
            initDetailPlanCodes.add(detailPlanItemCode);
        }
        if (CollectionUtils.isEmpty(initDetailPlanCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> detailPlanItemVoList = this.activityDetailPlanItemRepository.findByItemCodes(initDetailPlanCodes);
        for (ActivityDetailPlanItemVo itemVo : detailPlanItemVoList) {
            ActivityDetailPlanItemExtend activityDetailPlanItemExtend = new ActivityDetailPlanItemExtend();
            activityDetailPlanItemExtend.setId(itemVo.getId());
            activityDetailPlanItemExtend.setDetailPlanCode(itemVo.getDetailPlanCode());
            activityDetailPlanItemExtend.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
            activityDetailPlanItemExtend.setTenantCode(TenantUtils.getTenantCode());
            this.activityDetailPlanItemExtendRepository.save((Object)activityDetailPlanItemExtend);
        }
    }

    public void updateActivityDetailPurchasingOrderProcessStatus(List<String> activityDetailItemCodes, String processStatus) {
        if (StringUtils.isEmpty((CharSequence)processStatus)) {
            return;
        }
        if (CollectionUtils.isEmpty(activityDetailItemCodes)) {
            return;
        }
        this.initActivityDetailExtend(activityDetailItemCodes);
        this.activityDetailPlanItemRepository.updateActivityDetailPurchasingOrderProcessStatus(activityDetailItemCodes, processStatus);
    }
}

