/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityDetailPlanPlanServiceImpl
implements ActivityDetailPlanPlanService {
    @Autowired(required=false)
    private ActivityDetailPlanPlanRepository activityDetailPlanPlanRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityDetailPlanPlanList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanPlanDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityDetailPlanPlan> oldList = this.activityDetailPlanPlanRepository.findListByDetailPlanCode(entity.getDetailPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, ActivityDetailPlanPlanDto.class, ActivityDetailPlanPlan.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityDetailPlanPlan item : entityList) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setDetailPlanCode(entity.getDetailPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityDetailPlanPlanRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityDetailPlanPlanRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.activityDetailPlanPlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public List<ActivityDetailPlanPlanVo> findActPlan(String detailPlanCode) {
        return this.activityDetailPlanPlanRepository.findListVoByDetailPlanCode(detailPlanCode);
    }

    @Override
    public List<ActivityDetailPlanPlan> findDetailPlanAndPlanList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        return this.activityDetailPlanPlanRepository.findDetailPlanAndPlanList(planCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createDetailLinkPlanForOut(ActivityDetailPlan entity, List<ActivityDetailPlanPlanDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, ActivityDetailPlanPlanDto.class, ActivityDetailPlanPlan.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        for (ActivityDetailPlanPlan item : entityList) {
            item.setDetailPlanCode(entity.getDetailPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        this.activityDetailPlanPlanRepository.saveBatch(saveList);
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findForSalesApproval(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanPlanRepository.findForSalesApproval(detailPlanItemCodes);
    }
}

