/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanOutDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="activityDetailPlanSdkService")
public class ActivityDetailPlanSdkServiceImpl
implements ActivityDetailPlanSdkService {
    @Autowired(required=false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Page<ActivityDetailPlanVo> findByConditions(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto) {
        return this.activityDetailPlanService.findByConditions(pageable, activityDetailPlanDto);
    }

    public Page<ActivityDetailPlanItemVo> queryActivityDetailPlan(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(activityDetailPlanItemDto)) {
            activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        }
        return this.activityDetailPlanRepository.queryActivityDetailPlan(pageable, activityDetailPlanItemDto);
    }

    public List<ActivityDetailPlanVo> findByCodes(Collection<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return new ArrayList<ActivityDetailPlanVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.in((Object)"detail_plan_code", detailPlanCodes);
        List list = this.activityDetailPlanRepository.list((Wrapper)wrapper);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityDetailPlan.class, ActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityDetailPlanVo> findActivityDetailPlanByCodes(List<String> codes) {
        List<ActivityDetailPlan> list = this.activityDetailPlanRepository.findByDetailPlanCodeList(codes);
        if (CollUtil.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return new ArrayList<ActivityDetailPlanVo>(this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityDetailPlan.class, ActivityDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public String findPlanCodeByPlanName(String planName) {
        if (StringUtils.isBlank((CharSequence)planName)) {
            return "";
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.like((Object)"detail_plan_name", (Object)planName);
        wrapper.last("limit 1");
        ActivityDetailPlan one = (ActivityDetailPlan)((Object)this.activityDetailPlanRepository.getOne((Wrapper)wrapper));
        return one != null ? one.getDetailPlanCode() : "";
    }

    public List<ActivityDetailPlanDto> buildActivityDetailPlanParams(List<String> detailPlanCodeList) {
        return this.activityDetailPlanService.buildActivityDetailPlanParams(detailPlanCodeList);
    }

    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2) {
        Validate.notNull((Object)dto2.getSupplierCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.activityDetailPlanService.redPacketQueryScheme(dto2);
    }

    public List<ActivityDetailPlanVo> getCanAutoAuditDto(Page<ActivityDetailPlanVo> page, String autoDate) {
        return this.activityDetailPlanService.getCanAutoAuditDto(page, autoDate);
    }

    public List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, AutoAuditParamsDto autoAuditParams) {
        return this.activityDetailPlanService.findCanAutoAudit(page, autoAuditParams);
    }

    public List<ActivityDetailPlanItemVo> findCanAutoAuditItem(AutoAuditParamsDto autoAuditParams) {
        return null;
    }

    public int getActivityDetailNum(String autoDate, String businessUnitCode) {
        return this.activityDetailPlanService.getDetailPlanNum(autoDate, businessUnitCode);
    }

    public int getActivityTotalNumber(AutoAuditParamsDto autoAuditParams) {
        return this.activityDetailPlanService.getActivityTotalNumber(autoAuditParams);
    }

    public void updateAutoAudit(String detailPlanCode) {
        this.activityDetailPlanService.updateAutoAudit(detailPlanCode);
    }

    public List<ActivityDetailPlanVo> findByPlanCodes(Set<String> codeSet) {
        if (CollectionUtils.isEmpty(codeSet)) {
            return new ArrayList<ActivityDetailPlanVo>();
        }
        return this.activityDetailPlanRepository.findPlanCodes(codeSet);
    }

    public void updateAutoAuditFlag(List<String> codeList, String autoAudit) {
        this.activityDetailPlanRepository.updateAutoAuditFlag(codeList, autoAudit);
    }

    public List<ActivityDetailPlanBudgetVo> findByPlanItemCode(Set<String> itemCodeSet) {
        if (CollectionUtils.isEmpty(itemCodeSet)) {
            return null;
        }
        return this.activityDetailPlanBudgetRepository.findByPlanItemCode(itemCodeSet);
    }

    public ActivityDetailPlanVo findByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return null;
        }
        List<ActivityDetailPlan> activityDetailPlanList = this.activityDetailPlanRepository.findByPlanCode(planCode);
        if (CollectionUtils.isEmpty(activityDetailPlanList)) {
            return null;
        }
        return (ActivityDetailPlanVo)this.nebulaToolkitService.copyObjectByBlankList((Object)activityDetailPlanList.get(0), ActivityDetailPlanVo.class, null, null, new String[0]);
    }

    public ActivityDetailPlanVo findById(String id) {
        return null;
    }

    public ActivityDetailPlanOutDto createOrUpdateForOut(ActivityDetailPlanOutDto dto) {
        return null;
    }

    public void delete(List<String> ids) {
    }

    public ActivityDetailPlanOutDto atomicCreateForOut(ActivityDetailPlanOutDto dto) {
        return null;
    }

    public Page<ActivityDetailPlanVo> findPageForOut(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto) {
        return null;
    }

    public Page<String> findByDtoForPrediction(Pageable pageable, ActivityDetailPlanDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getActivityBeginDate()) || Objects.isNull(dto.getActivityEndDate())) {
            return null;
        }
        return this.activityDetailPlanService.findByDtoForPrediction(pageable, dto);
    }

    public Page<ActivityDetailPlanItemVo> findPlanItemByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return null;
    }
}

