/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanVoService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityDetailPlanVoServiceImpl
implements ActivityDetailPlanVoService {
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    @Override
    public List<ActivityDetailPlanItemVo> findActivityDetailPlanItemSumInfoByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        List processBusinessMappingVos = this.processBusinessMappingService.findAllByProcessNoCollection((Collection)Lists.newArrayList((Object[])new String[]{processNo}));
        List<String> detailPlanCodeList = processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        List<ActivityDetailPlanItemVo> itemVos = this.activityDetailPlanItemRepository.findVoListByActivityDetailPlanCode(detailPlanCodeList);
        Map<String, List<ActivityDetailPlanItemVo>> groupMap = itemVos.stream().collect(Collectors.groupingBy(item -> item.getFeeYearMonthStr() + item.getActivityOrgCode() + item.getActivityTypeCode() + item.getActivityFormCode() + item.getCustomerCode()));
        ArrayList result = Lists.newArrayList();
        BigDecimal multiplicand = new BigDecimal(100);
        for (Map.Entry<String, List<ActivityDetailPlanItemVo>> entry : groupMap.entrySet()) {
            List<ActivityDetailPlanItemVo> value = entry.getValue();
            ActivityDetailPlanItemVo firstVo = value.get(0);
            ActivityDetailPlanItemVo vo = new ActivityDetailPlanItemVo();
            vo.setFeeYearMonthStr(firstVo.getFeeYearMonthStr());
            vo.setActivityOrgCode(firstVo.getActivityOrgCode());
            vo.setActivityOrgName(firstVo.getActivityOrgName());
            vo.setActivityTypeCode(firstVo.getActivityTypeCode());
            vo.setActivityTypeName(firstVo.getActivityTypeName());
            vo.setCustomerCode(firstVo.getCustomerCode());
            vo.setCustomerName(firstVo.getCustomerName());
            vo.setActivityForm(firstVo.getActivityFormCode());
            vo.setActivityFormName(firstVo.getActivityFormName());
            vo.setTotalFeeAmount(BigDecimal.ZERO);
            vo.setHeadFeeAmount(BigDecimal.ZERO);
            vo.setDepartmentFeeAmount(BigDecimal.ZERO);
            vo.setPeriodChPromoteAmount(BigDecimal.ZERO);
            for (ActivityDetailPlanItemVo ActivityDetailPlanItemVo2 : value) {
                if (null != ActivityDetailPlanItemVo2.getTotalFeeAmount()) {
                    vo.setTotalFeeAmount(vo.getTotalFeeAmount().add(ActivityDetailPlanItemVo2.getTotalFeeAmount()));
                }
                if (null != ActivityDetailPlanItemVo2.getHeadFeeAmount()) {
                    vo.setHeadFeeAmount(vo.getHeadFeeAmount().add(ActivityDetailPlanItemVo2.getHeadFeeAmount()));
                }
                if (null != ActivityDetailPlanItemVo2.getDepartmentFeeAmount()) {
                    vo.setDepartmentFeeAmount(vo.getDepartmentFeeAmount().add(ActivityDetailPlanItemVo2.getDepartmentFeeAmount()));
                }
                if (null == ActivityDetailPlanItemVo2.getPeriodChPromoteAmount()) continue;
                vo.setPeriodChPromoteAmount(vo.getPeriodChPromoteAmount().add(ActivityDetailPlanItemVo2.getPeriodChPromoteAmount()));
            }
            String feeRateStr = null;
            if (null != vo.getPeriodChPromoteAmount() && vo.getPeriodChPromoteAmount().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal feeRate = vo.getTotalFeeAmount().multiply(multiplicand).divide(vo.getPeriodChPromoteAmount(), 2, 4);
                feeRateStr = feeRate + "%";
            }
            vo.setFeeRateStr(feeRateStr);
            result.add(vo);
        }
        return result;
    }
}

