/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.BusinessUnitSetTable;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.BusinessUnitSetTableRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.BusinessUnitSetTableService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessUnitSetTableServiceImpl
implements BusinessUnitSetTableService {
    private static final Logger log = LoggerFactory.getLogger(BusinessUnitSetTableServiceImpl.class);
    @Autowired(required=false)
    private BusinessUnitSetTableRepository businessUnitSetTableRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void frJob(List<String> yearMonths) {
        Page<BusinessUnitSetTable> result;
        this.businessUnitSetTableRepository.removeByYearMonth(yearMonths);
        int current = 1;
        int pageSize = 300;
        int count = 1;
        String tenantCode = TenantUtils.getTenantCode();
        do {
            Page page = new Page((long)current, (long)pageSize);
            result = this.activityDetailPlanItemRepository.findListForFR((Page<BusinessUnitSetTable>)page, yearMonths);
            log.info("\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053\u67e5\u8be2\u4e3b\u6570\u636e:{}", (Object)JSON.toJSONString(result));
            if (Objects.isNull(result) || CollectionUtils.isEmpty((Collection)result.getRecords())) break;
            ++current;
            List salesPerformanceDtos = result.getRecords().stream().map(e -> new SalesPerformanceDto((BusinessUnitSetTable)((Object)e)){
                final /* synthetic */ BusinessUnitSetTable val$e;
                {
                    this.val$e = businessUnitSetTable;
                    this.setSalesMonth(this.val$e.getYearMonthStr().replace("-", ""));
                    this.setRetailer(this.val$e.getSystemName());
                }
            }).collect(Collectors.toList());
            log.info("\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053\u67e5\u8be2\u5782\u76f4\u9500\u552e\u4e1a\u7ee9\u53c2\u6570:{}", (Object)JSON.toJSONString(salesPerformanceDtos));
            List salesPerformanceVos = this.salesPerformanceVoService.findBusinessUnitSetTableForFR(salesPerformanceDtos);
            log.info("\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053\u67e5\u8be2\u5782\u76f4\u9500\u552e\u4e1a\u7ee9:{}", (Object)JSON.toJSONString((Object)salesPerformanceVos));
            Map salesPerformanceVoMap = salesPerformanceVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getSalesMonth(), e.getRetailer()}), Function.identity()));
            log.info("\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053\u67e5\u8be2\u5782\u76f4\u9500\u552e\u4e1a\u7ee9map:{}", (Object)JSON.toJSONString(salesPerformanceVoMap));
            List salesDataDtos = result.getRecords().stream().map(e -> new SalesDataDto((BusinessUnitSetTable)((Object)e)){
                final /* synthetic */ BusinessUnitSetTable val$e;
                {
                    this.val$e = businessUnitSetTable;
                    this.setYearMonth(this.val$e.getYearMonthStr());
                    this.setCustomerRetailerCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            log.info("\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053\u67e5\u8be2KMS\u9500\u552e\u6570\u636e\u8868\u53c2\u6570:{}", (Object)JSON.toJSONString(salesDataDtos));
            List salesDataVos = this.invoiceSalesDataVoService.findBusinessUnitSetTableForFR(salesDataDtos);
            log.info("\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053\u67e5\u8be2KMS\u9500\u552e\u6570\u636e\u8868:{}", (Object)JSON.toJSONString((Object)salesDataVos));
            Map salesDataVoMap = salesDataVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonth(), e.getCustomerRetailerCode()}), Function.identity()));
            log.info("\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053\u67e5\u8be2KMS\u9500\u552e\u6570\u636e\u8868map:{}", (Object)JSON.toJSONString(salesDataVoMap));
            List<BusinessUnitSetTable> tableList = result.getRecords().stream().map(e -> new BusinessUnitSetTable((BusinessUnitSetTable)((Object)e)){
                final /* synthetic */ BusinessUnitSetTable val$e;
                {
                    this.val$e = businessUnitSetTable;
                    this.setYearMonthStr(this.val$e.getLastYear());
                    this.setSystemCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            List<BusinessUnitSetTable> tables = this.businessUnitSetTableRepository.findListForFR(tableList);
            Map tableMap = tables.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthStr(), e.getSystemCode()}), Function.identity(), (v1, v2) -> v1));
            result.getRecords().forEach(e -> {
                e.setTenantCode(tenantCode);
                e.setDqzxfyxj(e.getDqcpcx().add(e.getDqclf()).add(e.getDqcxyfy()).add(e.getDqhtnfy()).add(e.getDqqtfy()).add(e.getDqxxfy()));
                e.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                e.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                String key = StringUtils.join((Object[])new String[]{e.getYearMonthStr(), e.getSystemCode()});
                String key1 = StringUtils.join((Object[])new String[]{e.getYearMonthStr().replace("-", ""), e.getSystemName()});
                e.setDqzxfylzh(BigDecimal.ZERO);
                if (salesPerformanceVoMap.containsKey(key1)) {
                    e.setDqzxfylzh(((SalesPerformanceVo)salesPerformanceVoMap.get(key1)).getWarehsOutDiscountAmtIncM());
                }
                e.setDqzxfylpos(BigDecimal.ZERO);
                if (salesDataVoMap.containsKey(key)) {
                    e.setDqzxfylpos(((SalesDataVo)salesDataVoMap.get(key)).getSalesAmount());
                }
                e.setTqclf(BigDecimal.ZERO);
                e.setTqcpcx(BigDecimal.ZERO);
                e.setTqcxyfy(BigDecimal.ZERO);
                e.setTqhtnfy(BigDecimal.ZERO);
                e.setTqqtfy(BigDecimal.ZERO);
                e.setTqxxfy(BigDecimal.ZERO);
                e.setTqzxfylpos(BigDecimal.ZERO);
                e.setTqzxfylzh(BigDecimal.ZERO);
                e.setTqzxfyxj(BigDecimal.ZERO);
                String key2 = StringUtils.join((Object[])new String[]{e.getLastYear(), e.getSystemCode()});
                if (tableMap.containsKey(key2)) {
                    e.setTqclf(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqclf());
                    e.setTqcpcx(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqcpcx());
                    e.setTqcxyfy(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqcxyfy());
                    e.setTqhtnfy(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqhtnfy());
                    e.setTqqtfy(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqqtfy());
                    e.setTqxxfy(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqxxfy());
                    e.setTqzxfylpos(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqzxfylpos());
                    e.setTqzxfylzh(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqzxfylzh());
                    e.setTqzxfyxj(((BusinessUnitSetTable)((Object)((Object)tableMap.get(key2)))).getTqzxfyxj());
                }
            });
            this.businessUnitSetTableRepository.saveOrUpdateBatch(result.getRecords());
        } while (++count <= 1000 && result.hasNext());
    }
}

