/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.enums.RtmModelEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.exception.DataDuplicationException;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtend;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemExtendRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ForeignActivityDetailPlanApiAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.foreign.ForeignActivityDetailPlanEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.AcceptTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ForeignActivityDetailPlanEvent;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanBase;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ForeignActivityDetailPlanApiAsyncServiceImpl
implements ForeignActivityDetailPlanApiAsyncService {
    private static final Logger log = LoggerFactory.getLogger(ForeignActivityDetailPlanApiAsyncServiceImpl.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemExtendRepository activityDetailPlanItemExtendRepository;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Async
    public void create(JSONObject object, AbstractCrmUserIdentity userIdentity) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        ForeignActivityDetailPlanApiAsyncServiceImpl.log.info("\u5916\u90e8\u7cfb\u7edf\u521b\u5efa\u6d3b\u52a8\u7ec6\u6848");
        result = new Result();
        lockSuccess = false;
        lockKey = null;
        foreignPlanCode = object.getString("foreignPlanCode");
        try {
            Validate.notBlank((CharSequence)foreignPlanCode, (String)"\u5916\u90e8\u7cfb\u7edf\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            activityDetailPlanDto = new ActivityDetailPlanDto();
            activityDetailPlanDto.setForeignPlanCode(foreignPlanCode);
            result.setResult((Object)activityDetailPlanDto);
            lockKey = "activity_plan:lock:save:" + foreignPlanCode;
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30L);
            Validate.isTrue((boolean)lockSuccess, (String)("\u6d3b\u52a8\u7ec6\u6848[" + foreignPlanCode + "]\u521b\u5efa\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"), (Object[])new Object[0]);
            detailPlanDto = (ActivityDetailPlanDto)JSONObject.parseObject((String)object.toJSONString(), ActivityDetailPlanDto.class);
            this.validate(detailPlanDto, activityDetailPlanDto);
            this.activityDetailPlanService.saveActivityDetailPlanNoCache(detailPlanDto);
            activityDetailPlanDto.setDetailPlanCode(detailPlanDto.getDetailPlanCode());
            itemDtoList = Lists.newArrayList();
            activityDetailPlanDto.setItemList((List)itemDtoList);
            for (ActivityDetailPlanItemDto itemDto : detailPlanDto.getItemList()) {
                detailPlanItemDto = new ActivityDetailPlanItemDto();
                detailPlanItemDto.setForeignPlanItemCode(itemDto.getForeignPlanItemCode());
                detailPlanItemDto.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                itemDtoList.add(detailPlanItemDto);
            }
            ** if (!lockSuccess) goto lbl-1000
        }
        catch (DataDuplicationException activityDetailPlanDto) {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
        catch (Exception e) {
            ForeignActivityDetailPlanApiAsyncServiceImpl.log.error("\u6d3b\u52a8\u7ec6\u6848\u521b\u5efa\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            result.setCode(CommonConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage("\u6d3b\u52a8\u7ec6\u6848[" + foreignPlanCode + "]\u521b\u5efa\u5931\u8d25:" + e.getMessage());
            result.setSuccess(false);
            ** if (!lockSuccess) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                this.redisLockService.unlock(lockKey);
            }
lbl-1000:
            // 2 sources

            {
            }
            {
                catch (Throwable var13_15) {
                    if (lockSuccess) {
                        this.redisLockService.unlock(lockKey);
                    }
                    throw var13_15;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            this.redisLockService.unlock(lockKey);
        }
lbl-1000:
        // 2 sources

        {
        }
        ForeignActivityDetailPlanApiAsyncServiceImpl.log.info("\u5916\u90e8\u7cfb\u7edf\u521b\u5efa\u6d3b\u52a8\u7ec6\u6848[" + foreignPlanCode + "]\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)result));
        eventDto = new ForeignActivityDetailPlanEventDto();
        eventDto.setResult(result);
        createFinish = (SerializableBiConsumer & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, createFinish(com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.foreign.ForeignActivityDetailPlanEventDto ), (Lcom/biz/crm/tpm/business/activity/detail/plan/sdk/service/ForeignActivityDetailPlanEvent;Lcom/biz/crm/tpm/business/activity/detail/plan/sdk/dto/foreign/ForeignActivityDetailPlanEventDto;)V)();
        this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, ForeignActivityDetailPlanEvent.class, (SerializableBiConsumer)createFinish);
    }

    private void validate(ActivityDetailPlanDto detailPlanDto, ActivityDetailPlanDto result) {
        String foreignPlanCode = detailPlanDto.getForeignPlanCode();
        Validate.notEmpty((Collection)detailPlanDto.getItemList(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)detailPlanDto.getRelatePlanList())) {
            throw new RuntimeException("\u5173\u8054\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List planCodeList = detailPlanDto.getRelatePlanList().stream().map(ActivityDetailPlanPlanDto::getPlanCode).collect(Collectors.toList());
        List planVoList = this.activityPlanSdkService.findByPlanCodeList((Set)Sets.newHashSet(planCodeList));
        if (CollectionUtils.isEmpty((Collection)planVoList)) {
            throw new RuntimeException("\u5173\u8054\u6d3b\u52a8\u65b9\u6848\u6709\u8bef\uff01");
        }
        Map planVoMap = planVoList.stream().collect(Collectors.toMap(ActivityPlanBase::getPlanCode, Function.identity(), (o, n) -> o));
        String[] ignoreFieldArr = (String[])Arrays.stream(BeanUtils.getPropertyDescriptors(TenantFlagOpDto.class)).map(FeatureDescriptor::getName).toArray(String[]::new);
        for (ActivityDetailPlanPlanDto planPlanDto : detailPlanDto.getRelatePlanList()) {
            ActivityPlanVo activityPlanVo = (ActivityPlanVo)planVoMap.get(planPlanDto.getPlanCode());
            if (null == activityPlanVo) {
                throw new RuntimeException("\u5173\u8054\u6d3b\u52a8\u65b9\u6848[" + planPlanDto.getPlanCode() + "]\u6709\u8bef");
            }
            BeanUtils.copyProperties((Object)activityPlanVo, (Object)planPlanDto, (String[])ignoreFieldArr);
            detailPlanDto.setDepartmentCode(activityPlanVo.getDepartmentCode());
        }
        this.setDefaultProperty(detailPlanDto);
        List<ActivityDetailPlan> existsList = this.activityDetailPlanRepository.findByForeignPlanCodeList(Lists.newArrayList((Object[])new String[]{foreignPlanCode}));
        if (!CollectionUtils.isEmpty(existsList)) {
            ActivityDetailPlan activityDetailPlan = existsList.get(0);
            result.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
            ArrayList itemDtoList = Lists.newArrayList();
            result.setItemList((List)itemDtoList);
            List<ActivityDetailPlanItemExtend> existsItemList = this.activityDetailPlanItemExtendRepository.findByForeignPlanCode(foreignPlanCode);
            for (ActivityDetailPlanItemExtend itemDto : existsItemList) {
                ActivityDetailPlanItemDto detailPlanItemDto = new ActivityDetailPlanItemDto();
                detailPlanItemDto.setForeignPlanItemCode(itemDto.getForeignPlanItemCode());
                detailPlanItemDto.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                itemDtoList.add(detailPlanItemDto);
            }
            throw new DataDuplicationException("\u6d3b\u52a8\u7ec6\u6848[" + foreignPlanCode + "]\u5df2\u521b\u5efa\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtils.isNotEmpty((CharSequence)detailPlanDto.getDepartmentCode())) {
            OrgVo orgVo = null;
            try {
                orgVo = this.orgVoService.findByOrgCode(detailPlanDto.getDepartmentCode());
            }
            catch (Exception itemDtoList) {
                // empty catch block
            }
            if (null == orgVo) {
                throw new RuntimeException("\u90e8\u95e8\u7f16\u7801[" + detailPlanDto.getDepartmentCode() + "]\u6709\u8bef");
            }
            detailPlanDto.setDepartmentName(orgVo.getOrgName());
            this.setOrgDefaultProperty(detailPlanDto, orgVo);
        }
        HashSet planItemCodeList = Sets.newHashSet();
        ArrayList foreignPlanItemCodeList = Lists.newArrayList();
        List itemList = detailPlanDto.getItemList();
        HashSet salesOrgCodeSet = Sets.newHashSet();
        HashSet customerCodeSet = Sets.newHashSet();
        HashSet terminalChannelSet = Sets.newHashSet();
        HashSet activityFormCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemDto itemDto : itemList) {
            itemDto.setForeignPlanCode(foreignPlanCode);
            Validate.notBlank((CharSequence)itemDto.getForeignPlanItemCode(), (String)"\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)itemDto.getRelatePlanItemCode(), (String)"\u5173\u8054\u6d3b\u52a8\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)itemDto.getDistributionChannelCode(), (String)"\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            planItemCodeList.add(itemDto.getRelatePlanItemCode());
            if (foreignPlanItemCodeList.contains(itemDto.getForeignPlanItemCode())) {
                throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u7f16\u7801[" + itemDto.getForeignPlanItemCode() + "]\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            foreignPlanItemCodeList.add(itemDto.getForeignPlanItemCode());
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getSalesInstitutionErpCode())) {
                String salesInstitutionCode = itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode() + itemDto.getSalesInstitutionErpCode();
                itemDto.setSalesInstitutionCode(salesInstitutionCode);
                salesOrgCodeSet.add(salesInstitutionCode);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getSalesRegionErpCode())) {
                if (StringUtils.isEmpty((CharSequence)itemDto.getSalesInstitutionCode())) {
                    throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String salesRegionCode = itemDto.getSalesInstitutionCode() + itemDto.getSalesRegionErpCode();
                itemDto.setSalesRegionCode(salesRegionCode);
                salesOrgCodeSet.add(salesRegionCode);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getSalesOrgErpCode())) {
                if (StringUtils.isEmpty((CharSequence)itemDto.getSalesRegionCode())) {
                    throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u9500\u552e\u673a\u6784\u7f16\u7801\u548c\u9500\u552e\u5927\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String salesOrgCode = itemDto.getSalesRegionCode() + itemDto.getSalesOrgErpCode();
                itemDto.setSalesOrgCode(salesOrgCode);
                salesOrgCodeSet.add(salesOrgCode);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getCustomerErpCode())) {
                if (StringUtils.isEmpty((CharSequence)itemDto.getSalesInstitutionErpCode())) {
                    throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String customerCode = itemDto.getCustomerErpCode() + itemDto.getSalesInstitutionErpCode() + itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode();
                itemDto.setCustomerCode(customerCode);
                customerCodeSet.add(customerCode);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getFirstChannelCode())) {
                terminalChannelSet.add(itemDto.getFirstChannelCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getSecondChannelCode())) {
                terminalChannelSet.add(itemDto.getSecondChannelCode());
            }
            if (!StringUtils.isNotEmpty((CharSequence)itemDto.getActivityFormCode())) continue;
            List<String> formCodes = Arrays.asList(itemDto.getActivityFormCode().split(","));
            activityFormCodeSet.addAll(formCodes);
        }
        if (!CollectionUtils.isEmpty((Collection)salesOrgCodeSet)) {
            List salesOrgList = this.salesOrgVoService.findBySalesOrgCodes((List)Lists.newArrayList((Iterable)salesOrgCodeSet));
            if (CollectionUtils.isEmpty((Collection)salesOrgList)) {
                throw new RuntimeException("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u6709\u8bef\uff01");
            }
            Map salesOrgVoMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                SalesOrgVo salesOrgVo;
                if (StringUtils.isNotEmpty((CharSequence)itemDto.getSalesInstitutionErpCode())) {
                    String salesInstitutionCode = itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode() + itemDto.getSalesInstitutionErpCode();
                    salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(salesInstitutionCode);
                    if (null == salesOrgVo) {
                        throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u9500\u552e\u7ec4\u7ec7\u7f16\u7801[" + itemDto.getSalesInstitutionErpCode() + "]\u6709\u8bef");
                    }
                    itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
                if (StringUtils.isNotEmpty((CharSequence)itemDto.getSalesRegionErpCode())) {
                    String salesRegionCode = itemDto.getSalesInstitutionCode() + itemDto.getSalesRegionErpCode();
                    salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(salesRegionCode);
                    if (null == salesOrgVo) {
                        throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u9500\u552e\u5927\u533a\u7f16\u7801[" + itemDto.getSalesRegionErpCode() + "]\u6709\u8bef");
                    }
                    itemDto.setSalesRegionName(salesOrgVo.getSalesOrgName());
                }
                if (!StringUtils.isNotEmpty((CharSequence)itemDto.getSalesOrgErpCode())) continue;
                String salesOrgCode = itemDto.getSalesRegionCode() + itemDto.getSalesOrgErpCode();
                salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(salesOrgCode);
                if (null == salesOrgVo) {
                    throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u9500\u552e\u7701\u533a\u7f16\u7801[" + itemDto.getSalesOrgErpCode() + "]\u6709\u8bef");
                }
                itemDto.setSalesOrgName(salesOrgVo.getSalesOrgName());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)customerCodeSet)) {
            List customerVos = this.customerVoService.findBaseByCustomerCodes((List)Lists.newArrayList((Iterable)customerCodeSet));
            if (CollectionUtils.isEmpty((Collection)customerVos)) {
                throw new RuntimeException("\u5ba2\u6237\u7f16\u7801\u6709\u8bef\uff01");
            }
            Map customerMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                if (!StringUtils.isNotEmpty((CharSequence)itemDto.getCustomerErpCode())) continue;
                String customerCode = itemDto.getCustomerErpCode() + itemDto.getSalesInstitutionErpCode() + itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode();
                CustomerVo customerVo = (CustomerVo)customerMap.get(customerCode);
                if (null == customerVo) {
                    throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u5ba2\u6237\u7f16\u7801[" + itemDto.getCustomerErpCode() + "]\u6709\u8bef");
                }
                itemDto.setCustomerCode(customerVo.getCustomerCode());
                itemDto.setCustomerName(customerVo.getCustomerName());
                this.setItemCustomerDefaultProperty(itemDto, customerVo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)terminalChannelSet)) {
            List mdmTerminalChannelVos = this.terminalChannelVoService.listByCodes((List)Lists.newArrayList((Iterable)terminalChannelSet));
            if (CollectionUtils.isEmpty((Collection)mdmTerminalChannelVos)) {
                throw new RuntimeException("\u95e8\u5e97\u6e20\u9053\u6709\u8bef\uff01");
            }
            Map<String, String> terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, MdmTerminalChannelVo::getTerminalChannelName, (o, n) -> n));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                String terminalChannelName;
                if (StringUtils.isNotEmpty((CharSequence)itemDto.getFirstChannelCode())) {
                    terminalChannelName = terminalChannelMap.get(itemDto.getFirstChannelCode());
                    if (StringUtils.isEmpty((CharSequence)terminalChannelName)) {
                        throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u4e00\u7ea7\u6e20\u9053\u7f16\u7801[" + itemDto.getFirstChannelCode() + "]\u6709\u8bef");
                    }
                    itemDto.setFirstChannelName(terminalChannelName);
                }
                if (!StringUtils.isNotEmpty((CharSequence)itemDto.getSecondChannelCode())) continue;
                terminalChannelName = terminalChannelMap.get(itemDto.getSecondChannelCode());
                if (StringUtils.isEmpty((CharSequence)terminalChannelName)) {
                    throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u4e8c\u7ea7\u6e20\u9053\u7f16\u7801[" + itemDto.getSecondChannelCode() + "]\u6709\u8bef");
                }
                itemDto.setSecondChannelName(terminalChannelName);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityFormCodeSet)) {
            ArrayList activityFormCodeList = Lists.newArrayList((Iterable)activityFormCodeSet);
            ActivityFormDto activityFormDto = new ActivityFormDto();
            activityFormDto.setActivityFormCodeList((List)activityFormCodeList);
            activityFormDto.setBusinessUnitCode(detailPlanDto.getBusinessUnitCode());
            List activityFormVos = this.activityFormService.findListByConditions(activityFormDto);
            if (CollectionUtils.isEmpty((Collection)activityFormVos)) {
                throw new RuntimeException("\u6d3b\u52a8\u5f62\u5f0f\u6709\u8bef\uff01");
            }
            Map activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (o, n) -> n));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                if (!StringUtils.isNotEmpty((CharSequence)itemDto.getActivityFormCode())) continue;
                String[] codes = itemDto.getActivityFormCode().split(",");
                LinkedList<String> allNames = new LinkedList<String>();
                HashSet activityTypeCodeSet = Sets.newHashSet();
                HashSet activityTypeNameSet = Sets.newHashSet();
                for (String code : codes) {
                    ActivityFormVo activityFormVo = (ActivityFormVo)activityFormMap.get(code);
                    if (null == activityFormVo) {
                        throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + itemDto.getForeignPlanItemCode() + "]\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801[" + code + "]\u6709\u8bef");
                    }
                    allNames.add(activityFormVo.getActivityFormName());
                    activityTypeCodeSet.add(activityFormVo.getActivityTypeCode());
                    activityTypeNameSet.add(activityFormVo.getActivityTypeName());
                }
                itemDto.setActivityForm(itemDto.getActivityFormCode());
                itemDto.setActivityFormName(String.join((CharSequence)",", allNames));
                itemDto.setActivityTypeCode(String.join((CharSequence)",", activityTypeCodeSet));
                itemDto.setActivityType(itemDto.getActivityTypeCode());
                itemDto.setActivityTypeName(String.join((CharSequence)",", activityTypeNameSet));
            }
        }
        List<ActivityDetailPlanItemExtend> existsItemList = this.activityDetailPlanItemExtendRepository.findByForeignPlanItemCodeList(foreignPlanItemCodeList);
        List existsForeignPlanItemCodeList = existsItemList.stream().map(ActivityDetailPlanItemExtend::getForeignPlanItemCode).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(existsForeignPlanItemCodeList), (String)("\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6[" + String.join((CharSequence)",", foreignPlanItemCodeList) + "]\u5df2\u521b\u5efa\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c"), (Object[])new Object[0]);
        List planItemVos = this.activityPlanItemSdkService.listByItemCodeList((List)Lists.newArrayList((Iterable)planItemCodeList));
        Map planItemVoMap = planItemVos.stream().collect(Collectors.toMap(ActivityPlanItemBase::getPlanItemCode, Function.identity(), (o, n) -> n));
        for (ActivityDetailPlanItemDto itemDto : itemList) {
            ActivityPlanItemVo activityPlanItemVo = (ActivityPlanItemVo)planItemVoMap.get(itemDto.getRelatePlanItemCode());
            Validate.notNull((Object)activityPlanItemVo, (String)("\u5173\u8054\u65b9\u6848\u7f16\u7801[" + itemDto.getRelatePlanItemCode() + "]\u6709\u8bef\uff01"), (Object[])new Object[0]);
            itemDto.setRelatePlanCode(activityPlanItemVo.getPlanCode());
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getHeadBudgetItemCode())) {
                itemDto.setHeadMonthBudgetCode(activityPlanItemVo.getHeadMonthBudgetCode());
                itemDto.setHeadBudgetItemName(activityPlanItemVo.getHeadBudgetItemName());
            }
            if (!StringUtils.isNotEmpty((CharSequence)itemDto.getBudgetItemCode())) continue;
            itemDto.setMonthBudgetCode(activityPlanItemVo.getMonthBudgetCode());
            itemDto.setBudgetItemName(activityPlanItemVo.getBudgetItemName());
        }
    }

    private void setDefaultProperty(ActivityDetailPlanDto detailPlanDto) {
        if ("HDMBPZ3898".equals(detailPlanDto.getTemplateConfigCode())) {
            this.setDefaultPropertyDisplay(detailPlanDto);
        }
        for (ActivityDetailPlanItemDto itemDto : detailPlanDto.getItemList()) {
            this.setItemDefaultProperty(itemDto);
        }
    }

    public void setDefaultPropertyDisplay(ActivityDetailPlanDto detailPlanDto) {
        detailPlanDto.setIsTemporary(BooleanEnum.FALSE.getCapital());
        detailPlanDto.setIsGather(BooleanEnum.FALSE.getCapital());
    }

    private void setOrgDefaultProperty(ActivityDetailPlanDto detailPlanDto, OrgVo orgVo) {
        if ("HDMBPZ3898".equals(detailPlanDto.getTemplateConfigCode())) {
            this.setOrgDefaultPropertyDisplay(detailPlanDto, orgVo);
        }
    }

    public void setOrgDefaultPropertyDisplay(ActivityDetailPlanDto detailPlanDto, OrgVo orgVo) {
        String parentName = Optional.ofNullable(orgVo.getParentName()).orElse("");
        String yearMonth = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM");
        detailPlanDto.setDetailPlanName(parentName + yearMonth + ((ActivityDetailPlanPlanDto)detailPlanDto.getRelatePlanList().get(0)).getPlanName());
    }

    public void setItemDefaultProperty(ActivityDetailPlanItemDto itemDto) {
        if ("HDMBPZ3898".equals(itemDto.getTemplateConfigCode())) {
            this.setItemDefaultPropertyDisplay(itemDto);
        }
    }

    public void setItemDefaultPropertyDisplay(ActivityDetailPlanItemDto itemDto) {
        itemDto.setSalesInstitutionErpCode("6000");
        itemDto.setDistributionChannelCode("20");
        itemDto.setProductBrandCode("130000");
        itemDto.setProductBrandName("\u5e38\u6e29\u5168\u54c1");
        itemDto.setProductCode("130100000000");
        itemDto.setProductName("\u5e38\u6e29\u5168\u54c1");
        itemDto.setIsDeductionFeePool(BooleanEnum.FALSE.getCapital());
        itemDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE1.getCode());
        itemDto.setAuditForm("2");
        itemDto.setRelateToPrice(BooleanEnum.FALSE.getCapital());
        itemDto.setIncreasePricePromotion(BooleanEnum.FALSE.getCapital());
        itemDto.setDeductType(BooleanEnum.FALSE.getNumStr());
        itemDto.setDutyProfitAdjust(BooleanEnum.FALSE.getCapital());
        itemDto.setNewProductType("\u65e0");
        itemDto.setOccupyTransferBudget(BooleanEnum.FALSE.getCapital());
        itemDto.setActivityIntensity("0");
        itemDto.setIsCustomerAccount(BooleanEnum.FALSE.getCapital());
        itemDto.setUndertakingMode(AcceptTypeEnum.NO_ACCEPT.getCode());
    }

    private void setItemCustomerDefaultProperty(ActivityDetailPlanItemDto itemDto, CustomerVo customerVo) {
        if ("HDMBPZ3898".equals(itemDto.getTemplateConfigCode()) && RtmModelEnum.SON_COMPANY.getDictCode().equals(customerVo.getRtmModelCode())) {
            itemDto.setPromotionObject("6");
            itemDto.setIntraCompanyAmountStr(itemDto.getDepartmentFeeAmountStr());
            itemDto.setOffPointAmountStr(itemDto.getHeadFeeAmountStr());
        }
        if (null != customerVo && StringUtils.isNotEmpty((CharSequence)customerVo.getSalesOrgCode())) {
            itemDto.setSalesOrgCode(customerVo.getSalesOrgCode());
            itemDto.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
            itemDto.setSalesOrgName(customerVo.getSalesOrgName());
        }
    }
}

