/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.PushActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class PushActivityDetailPlanServiceImpl
implements PushActivityDetailPlanService {
    private static final Logger log = LoggerFactory.getLogger(PushActivityDetailPlanServiceImpl.class);
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void passPushMqDirect(String processNo, List<String> businessNoList) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return;
        }
        for (ActivityDetailPlanPassMqTagEnum mqTagEnum : ActivityDetailPlanPassMqTagEnum.values()) {
            if (ActivityDetailPlanPassMqTagEnum.PASS_AUDIT_FEE_PREDICTION.getCode().equals(mqTagEnum.getCode())) continue;
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString(businessNoList));
            mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            this.rocketMqProducer.sendMqMsg(mqMessageVo, 10L);
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

