/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerCellActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerDisplayActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerDisplayActivityItemDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerLongTermPersonnelActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerLongTermPersonnelActivityItemDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerPromotionActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerPromotionActivityItemDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerTemporaryPersonnelActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerTemporaryPersonnelActivityItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityCowManagerInterData {
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public List<CowManagerCellActivityDto> buildCellActivityInterfaceData(List<ActivityDetailPlanItemVo> ItemList, boolean close) {
        if (CollectionUtils.isEmpty(ItemList)) {
            return Lists.newArrayList();
        }
        ArrayList<CowManagerCellActivityDto> cowManagerCellActivityDtoList = new ArrayList<CowManagerCellActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        ItemList.forEach(item -> {
            CowManagerCellActivityDto cowManagerCellActivity = new CowManagerCellActivityDto();
            if (close) {
                cowManagerCellActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                cowManagerCellActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                cowManagerCellActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                cowManagerCellActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            cowManagerCellActivity.setActivityNo(item.getDetailPlanCode());
            cowManagerCellActivity.setActiveNumber(item.getDetailPlanItemCode());
            cowManagerCellActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            cowManagerCellActivity.setRegionInfo(item.getRegion());
            cowManagerCellActivity.setSystemInfo(item.getSystemCode());
            cowManagerCellActivity.setStoreId(item.getTerminalCode());
            cowManagerCellActivity.setStoreName(item.getTerminalName());
            cowManagerCellActivity.setChannelFirst(item.getFirstChannelName());
            cowManagerCellActivity.setChannelSecond(item.getSecondChannelName());
            cowManagerCellActivity.setActivityBrand(item.getProductBrandName());
            cowManagerCellActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            cowManagerCellActivity.setActivityTypeCode(item.getActivityTypeCode());
            cowManagerCellActivity.setActivityTypeName(item.getActivityTypeName());
            cowManagerCellActivity.setActivityCode(item.getActivityFormCode());
            cowManagerCellActivity.setActivityName(item.getActivityFormName());
            cowManagerCellActivity.setActivityDesc(item.getActivityDesc());
            cowManagerCellActivity.setActivityIndicators(item.getQuantity() != null ? item.getQuantity().toString() : "");
            cowManagerCellActivity.setApplyTotalCost(item.getTotalFeeAmount() != null ? String.format("%.2f", item.getTotalFeeAmount()) : "0.00");
            cowManagerCellActivityDtoList.add(cowManagerCellActivity);
        });
        return cowManagerCellActivityDtoList;
    }

    public List<CowManagerDisplayActivityDto> buildDisplayActivityInterfaceData(List<ActivityDetailPlanItemVo> ItemList, boolean close) {
        if (CollectionUtils.isEmpty(ItemList)) {
            return null;
        }
        ArrayList directTypeCodes = Lists.newArrayList();
        directTypeCodes.add("Purchase method");
        Map directTypeMap = this.dictDataVoService.findByDictTypeCodeList((List)directTypeCodes);
        ArrayList<CowManagerDisplayActivityDto> cowManagerDisplayActivityDtoList = new ArrayList<CowManagerDisplayActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        ItemList.forEach(detailPlanItem -> {
            CowManagerDisplayActivityDto cowManagerDisplayActivity = new CowManagerDisplayActivityDto();
            if (close) {
                cowManagerDisplayActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                cowManagerDisplayActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                cowManagerDisplayActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                cowManagerDisplayActivity.setActivityEndTime(detailPlanItem.getActivityEndDate() != null ? sif2.format(detailPlanItem.getActivityEndDate()) : "");
            }
            cowManagerDisplayActivity.setActivityNo(detailPlanItem.getDetailPlanCode());
            cowManagerDisplayActivity.setActiveNumber(detailPlanItem.getDetailPlanItemCode());
            cowManagerDisplayActivity.setCostYearMonth(detailPlanItem.getFeeYearMonth() != null ? sif.format(detailPlanItem.getFeeYearMonth()) : "");
            cowManagerDisplayActivity.setActivityStartTime(detailPlanItem.getActivityBeginDate() != null ? sif2.format(detailPlanItem.getActivityBeginDate()) : "");
            cowManagerDisplayActivity.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            cowManagerDisplayActivity.setActivityTypeName(detailPlanItem.getActivityTypeName());
            cowManagerDisplayActivity.setActivityCode(detailPlanItem.getActivityFormCode());
            cowManagerDisplayActivity.setActivityName(detailPlanItem.getActivityFormName());
            cowManagerDisplayActivity.setStoreId(detailPlanItem.getTerminalCode());
            cowManagerDisplayActivity.setStoreName(detailPlanItem.getTerminalName());
            cowManagerDisplayActivity.setActivityDesc(detailPlanItem.getActivityDesc());
            cowManagerDisplayActivity.setProcurementMethod(this.findDictValue(directTypeMap, "Purchase method", detailPlanItem.getBuyWay()));
            cowManagerDisplayActivity.setScheduleStartTime(detailPlanItem.getScheduleBeginDate() != null ? sif2.format(detailPlanItem.getScheduleBeginDate()) : "");
            cowManagerDisplayActivity.setScheduleEndTime(detailPlanItem.getScheduleEndDate() != null ? sif2.format(detailPlanItem.getScheduleEndDate()) : "");
            cowManagerDisplayActivity.setDisplayApplyNum(detailPlanItem.getDisplayQuantity() != null ? String.format("%.2f", detailPlanItem.getDisplayQuantity()) : "0.00");
            cowManagerDisplayActivity.setDisplayApplyCost(detailPlanItem.getTotalFeeAmount() != null ? String.format("%.2f", detailPlanItem.getTotalFeeAmount()) : "0.00");
            ArrayList<CowManagerDisplayActivityItemDto> cowManagerDisplayActivityItemList = new ArrayList<CowManagerDisplayActivityItemDto>();
            cowManagerDisplayActivity.setProductLists(cowManagerDisplayActivityItemList);
            CowManagerDisplayActivityItemDto cowManagerDisplayActivityItem = new CowManagerDisplayActivityItemDto();
            cowManagerDisplayActivityItem.setBranCode(detailPlanItem.getProductBrandCode());
            cowManagerDisplayActivityItem.setBranName(detailPlanItem.getProductBrandName());
            cowManagerDisplayActivityItem.setBrandItemCode(detailPlanItem.getProductItemCode());
            cowManagerDisplayActivityItem.setBrandItemName(detailPlanItem.getProductItemName());
            cowManagerDisplayActivityItem.setBrandTypeCode(detailPlanItem.getProductCategoryCode());
            cowManagerDisplayActivityItem.setBrandTypeName(detailPlanItem.getProductCategoryName());
            cowManagerDisplayActivityItem.setProductNo(detailPlanItem.getProductCode());
            cowManagerDisplayActivityItem.setProductName(detailPlanItem.getProductName());
            cowManagerDisplayActivityItemList.add(cowManagerDisplayActivityItem);
            cowManagerDisplayActivityDtoList.add(cowManagerDisplayActivity);
        });
        return cowManagerDisplayActivityDtoList;
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public List<CowManagerPromotionActivityDto> buildPromotionActivityInterfaceData(List<ActivityDetailPlanItemVo> itemList, boolean close) {
        if (CollectionUtils.isEmpty(itemList)) {
            return null;
        }
        Set productCodes = itemList.stream().map(ActivityDetailPlanItemBase::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set giftCodes = itemList.stream().map(ActivityDetailPlanItemBase::getGiftCode).filter(Objects::nonNull).collect(Collectors.toSet());
        productCodes.addAll(giftCodes);
        ArrayList productCodeList = new ArrayList(productCodes);
        List productMainList = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        ArrayList<CowManagerPromotionActivityDto> cowManagerPromotionActivityDtoList = new ArrayList<CowManagerPromotionActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerPromotionActivityDto cowManagerPromotionActivity = new CowManagerPromotionActivityDto();
            if (close) {
                cowManagerPromotionActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                cowManagerPromotionActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                cowManagerPromotionActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                cowManagerPromotionActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            cowManagerPromotionActivity.setActivityNo(item.getDetailPlanCode());
            cowManagerPromotionActivity.setActiveNumber(item.getDetailPlanItemCode());
            cowManagerPromotionActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            cowManagerPromotionActivity.setRegionInfo(item.getRegion());
            cowManagerPromotionActivity.setSystemInfo(item.getSystemCode());
            cowManagerPromotionActivity.setStoreId(item.getTerminalCode());
            cowManagerPromotionActivity.setStoreName(item.getTerminalName());
            cowManagerPromotionActivity.setStoreType(item.getTerminalType());
            cowManagerPromotionActivity.setChannelFirst(item.getFirstChannelName());
            cowManagerPromotionActivity.setChannelSecond(item.getSecondChannelName());
            cowManagerPromotionActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            cowManagerPromotionActivity.setActivityTypeCode(item.getActivityTypeCode());
            cowManagerPromotionActivity.setActivityTypeName(item.getActivityTypeName());
            cowManagerPromotionActivity.setActivityCode(item.getActivityFormCode());
            cowManagerPromotionActivity.setActivityName(item.getActivityFormName());
            cowManagerPromotionActivity.setActivityDesc(item.getActivityDesc());
            cowManagerPromotionActivity.setOriginalPrice(item.getRetailPrice() != null ? String.format("%.2f", item.getRetailPrice()) : "0.00");
            cowManagerPromotionActivity.setPromotionalPrice(item.getPromotionalPrice() != null ? String.format("%.2f", item.getPromotionalPrice()) : "0.00");
            if (!com.aliyun.tea.utils.StringUtils.isEmpty((CharSequence)item.getProductCode())) {
                ArrayList<CowManagerPromotionActivityItemDto> promotionActivityItemDtoList = new ArrayList<CowManagerPromotionActivityItemDto>();
                cowManagerPromotionActivity.setSalesPromotionProductList(promotionActivityItemDtoList);
                ProductVo productVo = productMainList.stream().filter(k -> k.getProductCode().equals(item.getProductCode())).findAny().orElse(null);
                CowManagerPromotionActivityItemDto productDto = new CowManagerPromotionActivityItemDto();
                productDto.setProductType("BP");
                productDto.setProductTypeName("\u672c\u54c1");
                productDto.setActivityBrand(productVo.getProductBrandName());
                productDto.setPackageNo(productVo.getCartonBarCode());
                productDto.setSapCode(productVo.getProductCode());
                productDto.setSapName(productVo.getProductName());
                productDto.setProdDate(item.getThisProductProductionDate() != null ? sif2.format(item.getThisProductProductionDate()) : null);
                promotionActivityItemDtoList.add(productDto);
                if (!com.aliyun.tea.utils.StringUtils.isEmpty((CharSequence)item.getGiftCode())) {
                    ProductVo giftVo = productMainList.stream().filter(k -> k.getProductCode().equals(item.getGiftCode())).findAny().orElse(null);
                    CowManagerPromotionActivityItemDto giftDto = new CowManagerPromotionActivityItemDto();
                    giftDto.setProductType("ZP");
                    giftDto.setProductTypeName("\u8d60\u54c1");
                    giftDto.setActivityBrand(giftVo.getProductBrandName());
                    giftDto.setPackageNo(giftVo.getCartonBarCode());
                    giftDto.setSapCode(giftVo.getProductCode());
                    giftDto.setSapName(giftVo.getProductName());
                    giftDto.setProdDate(item.getGiftProductionDate() != null ? sif2.format(item.getGiftProductionDate()) : null);
                    promotionActivityItemDtoList.add(giftDto);
                }
            }
            cowManagerPromotionActivityDtoList.add(cowManagerPromotionActivity);
        });
        return cowManagerPromotionActivityDtoList;
    }

    public List<CowManagerTemporaryPersonnelActivityDto> buildTemporaryPersonnelActivity(List<ActivityDetailPlanItemVo> itemList, boolean close) {
        if (CollectionUtils.isEmpty(itemList)) {
            return null;
        }
        ArrayList<CowManagerTemporaryPersonnelActivityDto> temporaryPersonnelActivityDtoList = new ArrayList<CowManagerTemporaryPersonnelActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerTemporaryPersonnelActivityDto temporaryPersonnelActivity = new CowManagerTemporaryPersonnelActivityDto();
            if (close) {
                temporaryPersonnelActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                temporaryPersonnelActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                temporaryPersonnelActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                temporaryPersonnelActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            temporaryPersonnelActivity.setActivityNo(item.getDetailPlanCode());
            temporaryPersonnelActivity.setActiveNumber(item.getDetailPlanItemCode());
            temporaryPersonnelActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            temporaryPersonnelActivity.setSystemInfo(item.getSystemCode());
            temporaryPersonnelActivity.setStoreId(item.getTerminalCode());
            temporaryPersonnelActivity.setStoreName(item.getTerminalName());
            temporaryPersonnelActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            temporaryPersonnelActivity.setActivityTypeCode(item.getActivityTypeCode());
            temporaryPersonnelActivity.setActivityTypeName(item.getActivityTypeName());
            temporaryPersonnelActivity.setActivityCode(item.getActivityFormCode());
            temporaryPersonnelActivity.setActivityName(item.getProductCategoryName());
            temporaryPersonnelActivity.setUserNum(item.getQuantity() != null ? item.getQuantity().toString() : "0.00");
            temporaryPersonnelActivity.setActivityDesc(item.getActivityDesc());
            if (!com.aliyun.tea.utils.StringUtils.isEmpty((CharSequence)item.getProductCode())) {
                ArrayList<CowManagerTemporaryPersonnelActivityItemDto> productLists = new ArrayList<CowManagerTemporaryPersonnelActivityItemDto>();
                temporaryPersonnelActivity.setProductLists(productLists);
                CowManagerTemporaryPersonnelActivityItemDto tpProductDto = new CowManagerTemporaryPersonnelActivityItemDto();
                tpProductDto.setBranCode(item.getProductBrandCode());
                tpProductDto.setBranName(item.getProductBrandName());
                tpProductDto.setBrandItemCode(item.getProductItemCode());
                tpProductDto.setBrandItemName(item.getProductItemName());
                tpProductDto.setBrandTypeCode(item.getProductCategoryCode());
                tpProductDto.setBrandTypeName(item.getProductCategoryName());
                tpProductDto.setProductNo(item.getProductCode());
                tpProductDto.setProductName(item.getProductCode());
                productLists.add(tpProductDto);
            }
            temporaryPersonnelActivityDtoList.add(temporaryPersonnelActivity);
        });
        return temporaryPersonnelActivityDtoList;
    }

    public List<CowManagerLongTermPersonnelActivityDto> buildLongTermPersonnelActivity(List<ActivityDetailPlanItemVo> itemList, boolean close) {
        if (CollectionUtils.isEmpty(itemList)) {
            return null;
        }
        ArrayList<CowManagerLongTermPersonnelActivityDto> longTermPersonnelActivityDtoList = new ArrayList<CowManagerLongTermPersonnelActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerLongTermPersonnelActivityDto longTermPersonnelActivity = new CowManagerLongTermPersonnelActivityDto();
            if (close) {
                longTermPersonnelActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                longTermPersonnelActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                longTermPersonnelActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                longTermPersonnelActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            longTermPersonnelActivity.setActivityNo(item.getDetailPlanCode());
            longTermPersonnelActivity.setActiveNumber(item.getDetailPlanItemCode());
            longTermPersonnelActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            longTermPersonnelActivity.setRegionInfo(item.getRegion());
            longTermPersonnelActivity.setSystemInfo(item.getSystemCode());
            longTermPersonnelActivity.setStoreId(item.getTerminalCode());
            longTermPersonnelActivity.setStoreName(item.getTerminalName());
            longTermPersonnelActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            longTermPersonnelActivity.setActivityTypeCode(item.getActivityTypeCode());
            longTermPersonnelActivity.setActivityTypeName(item.getActivityTypeName());
            longTermPersonnelActivity.setActivityCode(item.getActivityFormCode());
            longTermPersonnelActivity.setActivityName(item.getProductCategoryName());
            longTermPersonnelActivity.setUserName(item.getNameOfShoppingGuide());
            longTermPersonnelActivity.setUserId(item.getEmployeeId());
            longTermPersonnelActivity.setIdNumber(item.getIdentityCard());
            longTermPersonnelActivity.setPhone(item.getTelephone());
            longTermPersonnelActivity.setActivityDesc(item.getActivityDesc());
            if (!com.aliyun.tea.utils.StringUtils.isEmpty((CharSequence)item.getProductCode())) {
                ArrayList<CowManagerLongTermPersonnelActivityItemDto> productLists = new ArrayList<CowManagerLongTermPersonnelActivityItemDto>();
                longTermPersonnelActivity.setProductLists(productLists);
                CowManagerLongTermPersonnelActivityItemDto ltProductDto = new CowManagerLongTermPersonnelActivityItemDto();
                ltProductDto.setBranCode(item.getProductBrandCode());
                ltProductDto.setBranName(item.getProductBrandName());
                ltProductDto.setBrandItemCode(item.getProductItemCode());
                ltProductDto.setBrandItemName(item.getProductItemName());
                ltProductDto.setBrandTypeCode(item.getProductCategoryCode());
                ltProductDto.setBrandTypeName(item.getProductCategoryName());
                ltProductDto.setProductNo(item.getProductCode());
                ltProductDto.setProductName(item.getProductName());
                productLists.add(ltProductDto);
            }
            longTermPersonnelActivityDtoList.add(longTermPersonnelActivity);
        });
        return longTermPersonnelActivityDtoList;
    }
}

