/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerCellActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerDisplayActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerExecutionDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerLongTermPersonnelActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerPromotionActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerQueryActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerTemporaryPersonnelActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.service.CowManagerService;
import com.biz.crm.mn.third.system.cow.manager.sdk.vo.CowManagerVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.third.ActivityCowManagerInterData;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanWhereFrom;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanBase;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPushCowManager {
    private static final Logger log = LoggerFactory.getLogger(ActivityPushCowManager.class);
    @Autowired(required=false)
    private CowManagerService cowManagerService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private ActivityCowManagerInterData activityCowManagerInterData;
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;

    public List<CowManagerExecutionDto> queryActivityExecution(String type, String activeNumber) {
        Validate.notEmpty((CharSequence)type, (String)"\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CowManagerQueryActivityDto dto = new CowManagerQueryActivityDto();
        dto.setType(type);
        dto.setActiveNumber(activeNumber);
        return this.cowManagerService.queryActivityExecution(dto);
    }

    public void closeActivityDetailPlan(List<String> itemCodes) {
        Validate.notEmpty(itemCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivityDetailPlanItemVo> itemList = this.activityDetailPlanItemService.findByItemCodes(itemCodes);
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        this.buildActivityDetailPlan(itemList, true);
    }

    public void buildAndPushActivityDetailPlan(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivityDetailPlanItemVo> detailPlanItemVos = this.activityDetailPlanItemService.findByDetailPlanCode(planCodes);
        if (CollectionUtils.isEmpty(detailPlanItemVos)) {
            return;
        }
        this.buildActivityDetailPlan(detailPlanItemVos, false);
    }

    private void filterNoPushDetailPlanItem(List<ActivityDetailPlanItemVo> detailPlanItemVoList, Set<String> formCodeSet) {
        if (CollectionUtils.isEmpty(detailPlanItemVoList)) {
            return;
        }
        if (CollectionUtils.isEmpty(formCodeSet)) {
            detailPlanItemVoList.clear();
            return;
        }
        Iterator<ActivityDetailPlanItemVo> iterator = detailPlanItemVoList.iterator();
        while (iterator.hasNext()) {
            ActivityDetailPlanItemVo next = iterator.next();
            if (formCodeSet.contains(next.getActivityFormCode())) continue;
            iterator.remove();
        }
        List planCodeList = detailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getRelatePlanCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planCodeList)) {
            List planList = this.activityPlanSdkService.findByPlanCodeList((Set)Sets.newHashSet(planCodeList));
            if (CollectionUtils.isEmpty((Collection)planList)) {
                throw new RuntimeException("\u5173\u8054\u6d3b\u52a8\u65b9\u6848\u67e5\u8be2\u5931\u8d25\uff01");
            }
            Map planMap = planList.stream().collect(Collectors.toMap(ActivityPlanBase::getPlanCode, Function.identity()));
            Iterator<ActivityDetailPlanItemVo> iterator1 = detailPlanItemVoList.iterator();
            while (iterator1.hasNext()) {
                ActivityDetailPlanItemVo detailPlanItemVo = iterator1.next();
                if (StringUtils.isEmpty((CharSequence)detailPlanItemVo.getRelatePlanCode())) continue;
                ActivityPlanVo planVo = (ActivityPlanVo)planMap.get(detailPlanItemVo.getRelatePlanCode());
                if (ActivityPlanWhereFrom.MANUAL.getCode().equals(planVo.getWhereFrom())) continue;
                iterator1.remove();
            }
        }
    }

    private void buildActivityDetailPlan(List<ActivityDetailPlanItemVo> detailPlanItemVoList, boolean close) {
        Map formMap = this.activityFormService.findPushCowManager();
        if (CollectionUtils.isEmpty((Map)formMap)) {
            return;
        }
        this.filterNoPushDetailPlanItem(detailPlanItemVoList, formMap.keySet());
        Map<String, List<ActivityDetailPlanItemVo>> planItemMap = this.categorizeDetailPlanItem(formMap, detailPlanItemVoList);
        List<CowManagerCellActivityDto> marketingDataList = this.activityCowManagerInterData.buildCellActivityInterfaceData(planItemMap.get(VerticalActivityTypeEnum.MARKETING.getCode()), close);
        List<CowManagerDisplayActivityDto> displayDataList = this.activityCowManagerInterData.buildDisplayActivityInterfaceData(planItemMap.get(VerticalActivityTypeEnum.DISPLAY.getCode()), close);
        List<CowManagerPromotionActivityDto> promotionDataList = this.activityCowManagerInterData.buildPromotionActivityInterfaceData(planItemMap.get(VerticalActivityTypeEnum.PROMOTION.getCode()), close);
        List<CowManagerTemporaryPersonnelActivityDto> temporaryDataList = this.activityCowManagerInterData.buildTemporaryPersonnelActivity(planItemMap.get(VerticalActivityTypeEnum.TEMPORARY.getCode()), close);
        List<CowManagerLongTermPersonnelActivityDto> longPersonDataList = this.activityCowManagerInterData.buildLongTermPersonnelActivity(planItemMap.get(VerticalActivityTypeEnum.LONG_PROMOTION.getCode()), close);
        this.pushData(marketingDataList, displayDataList, promotionDataList, temporaryDataList, longPersonDataList);
    }

    private Map<String, List<ActivityDetailPlanItemVo>> categorizeDetailPlanItem(Map<String, String> fromMap, List<ActivityDetailPlanItemVo> detailPlanItemVoList) {
        if (CollectionUtils.isEmpty(detailPlanItemVoList) || CollectionUtils.isEmpty(fromMap)) {
            return Maps.newHashMap();
        }
        HashMap<String, List<ActivityDetailPlanItemVo>> map = new HashMap<String, List<ActivityDetailPlanItemVo>>(5);
        map.put(VerticalActivityTypeEnum.MARKETING.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.DISPLAY.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.PROMOTION.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.TEMPORARY.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.LONG_PROMOTION.getCode(), new ArrayList());
        detailPlanItemVoList.forEach(detailPlanItem -> {
            String activityType = (String)fromMap.get(detailPlanItem.getActivityFormCode());
            if (StringUtil.isNotBlank((CharSequence)activityType)) {
                if (VerticalActivityTypeEnum.MARKETING.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.MARKETING.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.DISPLAY.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.DISPLAY.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.PROMOTION.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.PROMOTION.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.TEMPORARY.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.TEMPORARY.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.LONG_PROMOTION.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.LONG_PROMOTION.getCode())).add(detailPlanItem);
                }
            }
        });
        return map;
    }

    private void pushData(List<CowManagerCellActivityDto> marketingDataList, List<CowManagerDisplayActivityDto> displayDataList, List<CowManagerPromotionActivityDto> promotionDataList, List<CowManagerTemporaryPersonnelActivityDto> temporaryDataList, List<CowManagerLongTermPersonnelActivityDto> longPersonDataList) {
        List itemCodes;
        ArrayList<String> successCodes = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(marketingDataList)) {
            CowManagerVo mar = this.pushCellActivity(marketingDataList);
            if (mar.isSuccess()) {
                try {
                    if (((Boolean)mar.getData()).booleanValue()) {
                        itemCodes = marketingDataList.stream().map(CowManagerCellActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
                        successCodes.addAll(itemCodes);
                    }
                }
                catch (Exception e) {
                    log.warn("\u884c\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", mar.getData());
                }
            } else {
                log.warn("\u884c\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", mar.getData());
            }
        }
        if (!CollectionUtils.isEmpty(displayDataList)) {
            CowManagerVo dis = this.pushDisplayActivity(displayDataList);
            if (dis.isSuccess()) {
                try {
                    if (((Boolean)dis.getData()).booleanValue()) {
                        itemCodes = displayDataList.stream().map(CowManagerDisplayActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
                        successCodes.addAll(itemCodes);
                    }
                }
                catch (Exception e) {
                    log.warn("\u9648\u5217\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", dis.getData());
                }
            } else {
                log.warn("\u9648\u5217\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", dis.getData());
            }
        }
        if (!CollectionUtils.isEmpty(promotionDataList)) {
            CowManagerVo pro = this.pushPromotionActivity(promotionDataList);
            if (pro.isSuccess()) {
                try {
                    if (((Boolean)pro.getData()).booleanValue()) {
                        itemCodes = promotionDataList.stream().map(CowManagerPromotionActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
                        successCodes.addAll(itemCodes);
                    }
                }
                catch (Exception e) {
                    log.warn("\u4fc3\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", pro.getData());
                }
            } else {
                log.warn("\u4fc3\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", pro.getData());
            }
        }
        if (!CollectionUtils.isEmpty(temporaryDataList)) {
            CowManagerVo tem = this.pushTemporaryPersonnelActivity(temporaryDataList);
            if (tem.isSuccess()) {
                try {
                    if (((Boolean)tem.getData()).booleanValue()) {
                        itemCodes = temporaryDataList.stream().map(CowManagerTemporaryPersonnelActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
                        successCodes.addAll(itemCodes);
                    }
                }
                catch (Exception e) {
                    log.warn("\u4e34\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", tem.getData());
                }
            } else {
                log.warn("\u4e34\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", tem.getData());
            }
        }
        if (!CollectionUtils.isEmpty(longPersonDataList)) {
            CowManagerVo lon = this.pushLongTermPersonnelActivity(longPersonDataList);
            if (lon.isSuccess()) {
                try {
                    if (((Boolean)lon.getData()).booleanValue()) {
                        itemCodes = longPersonDataList.stream().map(CowManagerLongTermPersonnelActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
                        successCodes.addAll(itemCodes);
                    }
                }
                catch (Exception e) {
                    log.warn("\u957f\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", lon.getData());
                }
            } else {
                log.warn("\u957f\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a", lon.getData());
            }
        }
        this.updateDetailPlanInterfaceState(successCodes);
    }

    private CowManagerVo pushCellActivity(List<CowManagerCellActivityDto> marketingDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushCellActivity(marketingDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushDisplayActivity(List<CowManagerDisplayActivityDto> displayDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushDisplayActivity(displayDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushPromotionActivity(List<CowManagerPromotionActivityDto> promotionDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushPromotionActivity(promotionDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushTemporaryPersonnelActivity(List<CowManagerTemporaryPersonnelActivityDto> temporaryDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushTemporaryPersonnelActivity(temporaryDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushLongTermPersonnelActivity(List<CowManagerLongTermPersonnelActivityDto> longPersonDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushLongTermPersonnelActivity(longPersonDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", "\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDetailPlanInterfaceState(List<String> successCodes) {
        if (CollectionUtils.isEmpty(successCodes)) {
            return;
        }
        this.activityDetailPlanItemService.updateDetailPlanCowManagerState(successCodes);
    }
}

