/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.MessageHeaderDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.FreeGoodsInterfaceDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.FreeGoodsMapping;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.FreeGoodsMappingRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.OperationTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.CarGiftGroupEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.PromotionTypeEnum;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class ActivityPushFreeGoods {
    private static final Logger log = LoggerFactory.getLogger(ActivityPushFreeGoods.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private ActivityPushSapApiService activityPushSapApiService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private FreeGoodsMappingRepository freeGoodsMappingRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public void pushActivityToFreeGoods(List<ActivityDetailPlanItemVo> detailPlanItemList, OperationTypeEnum operation) {
        if (CollectionUtils.isEmpty(detailPlanItemList) || ObjectUtils.isEmpty((Object)operation)) {
            return;
        }
        List formCodes = detailPlanItemList.stream().map(ActivityDetailPlanItemBase::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map activityFormMap = this.activityFormService.findPushSap(formCodes);
        if (CollectionUtils.isEmpty((Map)activityFormMap)) {
            return;
        }
        Set keySet = activityFormMap.keySet();
        List<ActivityDetailPlanItemVo> itemList = detailPlanItemList.stream().filter(k -> keySet.contains(k.getActivityFormCode()) && PromotionTypeEnum.PROMOTION_GIFT.getCode().equals(k.getPromotionType())).collect(Collectors.toList());
        this.filterNotPush(itemList, activityFormMap);
        List freeGoodsMappingList = Lists.newArrayList();
        if (!OperationTypeEnum.CREATE.equals((Object)operation)) {
            List detailPlanItemCodeList = itemList.stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList());
            freeGoodsMappingList = this.freeGoodsMappingRepository.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(FreeGoodsMapping::getDetailPlanItemCode, detailPlanItemCodeList)).isNotNull(FreeGoodsMapping::getCondNoNew));
        }
        List<FreeGoodsInterfaceDto> freeGoodsDtoList = this.makeFreeGoodsInterfaceDate(itemList, operation, freeGoodsMappingList);
        if (OperationTypeEnum.CREATE.equals((Object)operation)) {
            this.freeGoodsMappingRepository.saveBatch(freeGoodsMappingList);
        }
        this.pushFreeGoods(freeGoodsDtoList);
    }

    private void filterNotPush(List<ActivityDetailPlanItemVo> detailPlanItemList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap) {
        if (CollectionUtils.isEmpty(detailPlanItemList)) {
            return;
        }
        if (CollectionUtils.isEmpty(activityFormMap) || CollectionUtils.isEmpty(activityFormMap.keySet())) {
            detailPlanItemList.clear();
        }
        Set<String> formCodes = activityFormMap.keySet();
        Iterator<ActivityDetailPlanItemVo> iterator = detailPlanItemList.iterator();
        while (iterator.hasNext()) {
            ActivityDetailPlanItemVo next = iterator.next();
            if (formCodes.contains(next.getActivityFormCode())) continue;
            iterator.remove();
        }
    }

    private List<FreeGoodsInterfaceDto> makeFreeGoodsInterfaceDate(List<ActivityDetailPlanItemVo> itemVoList, OperationTypeEnum operation, List<FreeGoodsMapping> freeGoodsMappingList) {
        if (CollectionUtils.isEmpty(itemVoList)) {
            return Lists.newArrayList();
        }
        Set salesInstitutionCodes = itemVoList.stream().map(ActivityDetailPlanItemVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set salesRegionCodes = itemVoList.stream().map(ActivityDetailPlanItemVo::getSalesRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set salesOrgCodes = itemVoList.stream().map(ActivityDetailPlanItemVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        ArrayList sapOrgCodes = new ArrayList();
        sapOrgCodes.addAll(salesInstitutionCodes);
        sapOrgCodes.addAll(salesRegionCodes);
        sapOrgCodes.addAll(salesOrgCodes);
        Map sapCodesMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(sapOrgCodes);
        List customerCodes = itemVoList.stream().map(ActivityDetailPlanItemBase::getCustomerCode).distinct().collect(Collectors.toList());
        List customerVoList = this.customerVoService.findByCustomerCodes(customerCodes);
        HashMap<String, CustomerVo> customerVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)customerVoList)) {
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (v1, v2) -> v2));
        }
        ArrayList<FreeGoodsInterfaceDto> list = new ArrayList<FreeGoodsInterfaceDto>();
        itemVoList.forEach(item -> {});
        int i = 0;
        Map freeGoodsMappingMap = freeGoodsMappingList.stream().collect(Collectors.toMap(FreeGoodsMapping::getDetailPlanItemCode, Function.identity(), (o, n) -> n));
        for (ActivityDetailPlanItemVo item2 : itemVoList) {
            FreeGoodsInterfaceDto dto = new FreeGoodsInterfaceDto();
            FreeGoodsInterfaceDto.Item1 item1 = this.takeItem1DataFromItem(item2, operation, sapCodesMap, customerVoMap);
            if (ObjectUtils.isEmpty((Object)item1)) continue;
            dto.setITEM1(new ArrayList());
            dto.getITEM1().add(item1);
            FreeGoodsInterfaceDto.Item2 item22 = this.takeItem2DataFromItem(item2, operation);
            dto.setITEM2((List)Lists.newArrayList((Object[])new FreeGoodsInterfaceDto.Item2[]{item22}));
            ++i;
            if (OperationTypeEnum.CREATE.equals((Object)operation)) {
                item1.setCOND_NO("$" + String.format("%09d", i));
                item22.setCOND_NO("$" + String.format("%09d", i));
                final String messageId = UuidCrmUtil.general();
                dto.setMessageHeader(new MessageHeaderDto(){
                    {
                        this.setMessageId(messageId);
                    }
                });
                FreeGoodsMapping freeGoodsMapping = new FreeGoodsMapping();
                freeGoodsMapping.setDetailPlanCode(item2.getDetailPlanCode());
                freeGoodsMapping.setDetailPlanItemCode(item2.getDetailPlanItemCode());
                freeGoodsMapping.setCondNo(item1.getCOND_NO());
                freeGoodsMapping.setMessageId(messageId);
                freeGoodsMappingList.add(freeGoodsMapping);
            } else {
                FreeGoodsMapping freeGoodsMapping = (FreeGoodsMapping)((Object)freeGoodsMappingMap.get(item2.getDetailPlanItemCode()));
                if (null == freeGoodsMapping) break;
                item1.setCOND_NO(freeGoodsMapping.getCondNoNew());
                item22.setCOND_NO(freeGoodsMapping.getCondNoNew());
            }
            list.add(dto);
        }
        return list;
    }

    private FreeGoodsInterfaceDto.Item1 takeItem1DataFromItem(ActivityDetailPlanItemVo item, OperationTypeEnum operation, Map<String, String> sapCodesMap, Map<String, CustomerVo> customerVoMap) {
        if (ObjectUtils.isEmpty((Object)item)) {
            return null;
        }
        FreeGoodsInterfaceDto.Item1 item1 = new FreeGoodsInterfaceDto.Item1();
        String varKey = this.takeCarGiftGroupItem(item, sapCodesMap, customerVoMap);
        if (StringUtils.isBlank((CharSequence)varKey)) {
            return null;
        }
        item1.setVARKEY(varKey);
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        item1.setOPERATION(operation.getCode());
        item1.setCOND_USAGE("N");
        item1.setAPPLICATIO("V");
        item1.setCOND_TYPE("ZFG");
        item1.setVALID_FROM(item.getOrderBeginDate() != null ? sif.format(item.getOrderBeginDate()) : null);
        item1.setVALID_TO(item.getOrderEndDate() != null ? sif.format(item.getOrderEndDate()) : null);
        item1.setTABLE_NO(item.getCarGiftGroup());
        return item1;
    }

    private String takeCarGiftGroupItem(ActivityDetailPlanItemVo item, Map<String, String> sapCodesMap, Map<String, CustomerVo> customerVoMap) {
        String code;
        String saleCode;
        String instCode;
        String regionCode;
        if (ObjectUtils.isEmpty((Object)item) || StringUtils.isBlank((CharSequence)item.getCarGiftGroup())) {
            return "";
        }
        String varKay = "";
        String carGiftGroup = item.getCarGiftGroup();
        if (CarGiftGroupEnum.GroupA.getCode().equals(carGiftGroup)) {
            String instiCode = "";
            regionCode = "";
            if (StringUtils.isNotBlank((CharSequence)item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15) {
                instiCode = item.getSalesOrgCode().substring(4, 8);
                regionCode = item.getSalesOrgCode().substring(8, 12);
            } else if (StringUtils.isNotBlank((CharSequence)item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12) {
                instiCode = item.getSalesRegionCode().substring(4, 8);
                regionCode = item.getSalesRegionCode().substring(8, 12);
            }
            if (StringUtils.isNotBlank((CharSequence)instiCode) && StringUtils.isNotBlank((CharSequence)regionCode) && StringUtils.isNotBlank((CharSequence)item.getCustomerGroupCode()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
                varKay = instiCode + "/" + regionCode + "/" + item.getCustomerGroupCode() + "/" + item.getProductCode();
            }
        }
        if (CarGiftGroupEnum.GroupB.getCode().equals(carGiftGroup)) {
            CustomerVo customerVo;
            String customerCode = item.getCustomerCode();
            String salesOrgCode = "";
            if (StringUtils.isNotBlank((CharSequence)customerCode) && !Objects.isNull(customerVo = customerVoMap.get(customerCode))) {
                customerCode = customerVo.getErpCode();
            }
            if (StringUtils.isNotBlank((CharSequence)item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15) {
                salesOrgCode = item.getSalesOrgCode().substring(4, 8);
            } else if (StringUtils.isNotBlank((CharSequence)item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12) {
                salesOrgCode = item.getSalesRegionCode().substring(4, 8);
            } else if (StringUtils.isNotBlank((CharSequence)item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4) {
                salesOrgCode = item.getSalesInstitutionCode().substring(4);
            }
            if (StringUtils.isNotBlank((CharSequence)salesOrgCode) && StringUtils.isNotBlank((CharSequence)customerCode) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
                varKay = salesOrgCode + "/" + customerCode + "/" + item.getProductCode();
            }
        }
        if (CarGiftGroupEnum.GroupC.getCode().equals(carGiftGroup)) {
            instCode = "";
            saleCode = "";
            if (StringUtils.isNotBlank((CharSequence)item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15) {
                instCode = item.getSalesOrgCode().substring(4, 8);
                saleCode = item.getSalesOrgCode().substring(12, 15);
            }
            if (StringUtils.isNotBlank((CharSequence)instCode) && StringUtils.isNotBlank((CharSequence)saleCode) && StringUtils.isNotBlank((CharSequence)item.getCustomerGroupCode()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
                varKay = instCode + "/" + saleCode + "/" + item.getCustomerGroupCode() + "/" + item.getProductCode();
            }
        }
        if (CarGiftGroupEnum.GroupD.getCode().equals(carGiftGroup)) {
            instCode = "";
            saleCode = "";
            if (StringUtils.isNotBlank((CharSequence)item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15) {
                instCode = item.getSalesOrgCode().substring(4, 8);
                saleCode = item.getSalesOrgCode().substring(12, 15);
            }
            if (StringUtils.isNotBlank((CharSequence)instCode) && StringUtils.isNotBlank((CharSequence)saleCode) && StringUtils.isNotBlank((CharSequence)item.getDistributionChannelCode()) && StringUtils.isNotBlank((CharSequence)item.getCustomerGroupCode()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
                varKay = instCode + "/" + item.getDistributionChannelCode() + "/" + saleCode + "/" + item.getCustomerGroupCode() + "/" + item.getProductCode();
            }
        }
        if (CarGiftGroupEnum.GroupE.getCode().equals(carGiftGroup)) {
            instCode = "";
            regionCode = "";
            if (StringUtils.isNotBlank((CharSequence)item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12) {
                instCode = item.getSalesRegionCode().substring(4, 8);
                regionCode = item.getSalesRegionCode().substring(8, 12);
            }
            if (StringUtils.isNotBlank((CharSequence)instCode) && StringUtils.isNotBlank((CharSequence)regionCode) && StringUtils.isNotBlank((CharSequence)item.getDistributionChannelCode()) && StringUtils.isNotBlank((CharSequence)item.getCustomerGroupCode()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
                varKay = instCode + "/" + item.getDistributionChannelCode() + "/" + regionCode + "/" + item.getCustomerGroupCode() + "/" + item.getProductCode();
            }
        }
        if (CarGiftGroupEnum.GroupF.getCode().equals(carGiftGroup) && StringUtils.isNotBlank((CharSequence)item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4 && StringUtils.isNotBlank((CharSequence)item.getDistributionChannelCode()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
            code = item.getSalesInstitutionCode().substring(4);
            varKay = code + "/" + item.getDistributionChannelCode() + "/" + item.getProductCode();
        }
        if (CarGiftGroupEnum.GroupG.getCode().equals(carGiftGroup) && StringUtils.isNotBlank((CharSequence)item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4 && StringUtils.isNotBlank((CharSequence)item.getDistributionChannelCode()) && StringUtils.isNotBlank((CharSequence)item.getCustomerGroupCode()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
            code = item.getSalesInstitutionCode().substring(4);
            varKay = code + "/" + item.getDistributionChannelCode() + "/" + item.getCustomerGroupCode() + "/" + item.getProductCode();
        }
        if (CarGiftGroupEnum.GroupH.getCode().equals(carGiftGroup)) {
            String saleCode2 = "";
            if (StringUtils.isNotBlank((CharSequence)item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15) {
                saleCode2 = item.getSalesOrgCode().substring(4, 8);
            } else if (StringUtils.isNotBlank((CharSequence)item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12) {
                saleCode2 = item.getSalesRegionCode().substring(4, 8);
            } else if (StringUtils.isNotBlank((CharSequence)item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4) {
                saleCode2 = item.getSalesInstitutionCode().substring(4);
            }
            if (StringUtils.isNotBlank((CharSequence)saleCode2) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
                varKay = saleCode2 + "/" + item.getProductCode();
            }
        }
        if (CarGiftGroupEnum.GroupI.getCode().equals(carGiftGroup) && StringUtils.isNotBlank((CharSequence)item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4 && StringUtils.isNotBlank((CharSequence)item.getCustomerGroupCode()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())) {
            code = item.getSalesInstitutionCode().substring(4);
            varKay = code + "/" + item.getCustomerGroupCode() + "/" + item.getProductCode();
        }
        return varKay;
    }

    private FreeGoodsInterfaceDto.Item2 takeItem2DataFromItem(ActivityDetailPlanItemVo item, OperationTypeEnum operation) {
        if (ObjectUtils.isEmpty((Object)item)) {
            return null;
        }
        FreeGoodsInterfaceDto.Item2 item2 = new FreeGoodsInterfaceDto.Item2();
        item2.setOPERATION(operation.getCode());
        int productQuantity = item.getProductQuantity() != null ? item.getProductQuantity() : 0;
        int giftQuantity = item.getGiftQuantity() != null ? item.getGiftQuantity() : 0;
        item2.setMIN_FG_QNT(String.valueOf(productQuantity + giftQuantity));
        item2.setFG_QNT(String.valueOf(productQuantity + giftQuantity));
        item2.setUNITFG_QNT("PC");
        item2.setADD_FG_QNT(String.valueOf(giftQuantity));
        item2.setUNITADDQNT("PC");
        item2.setTABLE_NO(item.getCarGiftGroup());
        item2.setCALC_TYPE("2");
        item2.setEXCL_INCL("1");
        item2.setCOND_USAGE("N");
        item2.setAPPLICATIO("V");
        item2.setCOND_TYPE("ZFG");
        return item2;
    }

    private void pushFreeGoods(List<FreeGoodsInterfaceDto> freeGoodsDtoList) {
        if (CollectionUtils.isEmpty(freeGoodsDtoList)) {
            return;
        }
        freeGoodsDtoList.forEach(goods -> {
            try {
                this.activityPushSapApiService.pushFeeGoodsMaintenance(goods);
            }
            catch (Exception e) {
                log.error("\u6d3b\u52a8\u7ec6\u6848\u6d3b\u52a8 \u660e\u7ec6\u7f16\u7801[ " + ((FreeGoodsInterfaceDto.Item1)goods.getITEM1().get(0)).getCOND_NO() + " ],\u63a8\u9001\u5931\u8d25\uff01");
                e.printStackTrace();
            }
        });
    }
}

