/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.biz.crm.mn.third.system.sd.sdk.dto.activity.CreatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.UpdatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.third.ActivitySapBranchInterData;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanWhereFrom;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanBase;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPushSapBranch {
    private static final Logger log = LoggerFactory.getLogger(ActivityPushSapBranch.class);
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;
    @Autowired(required=false)
    private ActivitySapBranchInterData activitySapBranchInterData;
    @Autowired(required=false)
    private ActivityPushSapApiService activityPushSapApiService;

    public void createPromotionActivityBranch(List<ActivityDetailPlanItemVo> detailPlanItemList) {
        if (CollectionUtils.isEmpty(detailPlanItemList)) {
            return;
        }
        List formCodes = detailPlanItemList.stream().map(ActivityDetailPlanItemBase::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map activityFormMap = this.activityFormService.findPushSap(formCodes);
        if (CollectionUtils.isEmpty((Map)activityFormMap)) {
            return;
        }
        this.removeNotPushWithDetailPlanItem(detailPlanItemList, activityFormMap);
        List<CreatePromotionActivityBranchDto> dtoList = this.activitySapBranchInterData.buildDetailPlanItemForCreateInter(detailPlanItemList);
        this.validateCreateData(dtoList);
        for (CreatePromotionActivityBranchDto dto : dtoList) {
            this.activityPushSapApiService.pushCreatePromotionActivityBranch(dto);
        }
    }

    private void validateCreateData(List<CreatePromotionActivityBranchDto> dtoList) {
        dtoList.forEach(dto -> {
            String itemCode = ((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFCXHD();
            Validate.notBlank((CharSequence)itemCode, (String)"\u4fc3\u9500\u6d3b\u52a8\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getVKORG(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getVTWEG(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFHDBQ(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u4fc3\u9500\u6d3b\u52a8\u4fbf\u7b3a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFHDFAM(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u7ec6\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFHDXS(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u6d3b\u52a8\u5f62\u5f0f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFCXKUN(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u6267\u884c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFSQFY(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u7533\u8bf7\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getDATAB(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u5f00\u59cb\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getDATBI(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u6709\u6548\u622a\u81f3\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFBEGIN(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u8ba2\u5355\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFEND(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u8ba2\u5355\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item1)dto.getITEM1().get(0)).getZFHXFS(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u6838\u9500\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item3)dto.getITEM3().get(0)).getZFYT(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)((CreatePromotionActivityBranchDto.Item3)dto.getITEM3().get(0)).getVRKME(), (String)("\u660e\u7ec6[ " + itemCode + " ] \u9500\u552e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        });
    }

    public void updateOrClosePromotionActivityBranch(List<ActivityDetailPlanItemVo> detailPlanItemList, boolean close) {
        if (CollectionUtils.isEmpty(detailPlanItemList)) {
            return;
        }
        List formCodes = detailPlanItemList.stream().map(ActivityDetailPlanItemBase::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map activityFormMap = this.activityFormService.findPushSap(formCodes);
        if (CollectionUtils.isEmpty((Map)activityFormMap)) {
            return;
        }
        this.removeNotPushWithDetailPlanItem(detailPlanItemList, activityFormMap);
        List<UpdatePromotionActivityBranchDto> updateDto = this.activitySapBranchInterData.buildDetailPlanItemForUpdateInter(detailPlanItemList, close);
        updateDto.forEach(dto -> this.activityPushSapApiService.pushUpdatePromotionActivityBranch(dto));
    }

    private void removeNotPushWithDetailPlanItem(List<ActivityDetailPlanItemVo> planItemList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap) {
        if (CollectionUtils.isEmpty(planItemList)) {
            return;
        }
        if (CollectionUtils.isEmpty(activityFormMap)) {
            planItemList.clear();
        }
        Iterator<ActivityDetailPlanItemVo> it = planItemList.iterator();
        while (it.hasNext()) {
            ActivityDetailPlanItemVo next = it.next();
            if (activityFormMap.containsKey(next.getActivityFormCode())) continue;
            it.remove();
        }
        List planCodeList = planItemList.stream().map(ActivityDetailPlanItemBase::getRelatePlanCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planCodeList)) {
            List planList = this.activityPlanSdkService.findByPlanCodeList((Set)Sets.newHashSet(planCodeList));
            if (CollectionUtils.isEmpty((Collection)planList)) {
                throw new RuntimeException("\u5173\u8054\u6d3b\u52a8\u65b9\u6848\u67e5\u8be2\u5931\u8d25\uff01");
            }
            Map planMap = planList.stream().collect(Collectors.toMap(ActivityPlanBase::getPlanCode, Function.identity()));
            Iterator<ActivityDetailPlanItemVo> iterator = planItemList.iterator();
            while (iterator.hasNext()) {
                ActivityDetailPlanItemVo detailPlanItemVo = iterator.next();
                if (StringUtils.isEmpty((CharSequence)detailPlanItemVo.getRelatePlanCode())) continue;
                ActivityPlanVo planVo = (ActivityPlanVo)planMap.get(detailPlanItemVo.getRelatePlanCode());
                if (ActivityPlanWhereFrom.MANUAL.getCode().equals(planVo.getWhereFrom())) continue;
                iterator.remove();
            }
        }
    }
}

