/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerExecutionDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.third.ActivityPushCowManager;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.third.ActivityPushFreeGoods;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.third.ActivityPushSapBranch;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.PushActivityToThirdSystemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PushActivityToThirdSystemServiceImpl
implements PushActivityToThirdSystemService {
    private static final Logger log = LoggerFactory.getLogger(PushActivityToThirdSystemServiceImpl.class);
    @Autowired(required=false)
    private ActivityPushSapBranch activityPushSapBranch;
    @Autowired(required=false)
    private ActivityPushCowManager activityPushCowManager;
    @Autowired(required=false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required=false)
    private ActivityPushFreeGoods activityPushFreeGoods;
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    public void activityCreateOrUpdatePushCowManager(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        this.activityPushCowManager.buildAndPushActivityDetailPlan(planCodes);
    }

    public void activityClosePushCowManager(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        this.activityPushCowManager.closeActivityDetailPlan(itemCodes);
    }

    public List<CowManagerExecutionDto> queryActivityExecution(String type, String activeNumber) {
        return this.activityPushCowManager.queryActivityExecution(type, activeNumber);
    }

    public void createActivityPushSapByPlanCodes(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = this.activityDetailPlanItemService.findByDetailPlanCode(planCodes);
        if (CollectionUtils.isEmpty(itemVoList)) {
            return;
        }
        List headquartersItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.isDefaultBusinessUnit((String)k.getBusinessUnitCode())).collect(Collectors.toList());
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).collect(Collectors.toList());
        this.activityPushSapBranch.createPromotionActivityBranch(verticalItemList);
    }

    public void createActivityPushSapByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = this.activityDetailPlanItemService.findByItemCodes(itemCodes);
        if (CollectionUtils.isEmpty(itemVoList)) {
            return;
        }
        List headquartersItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.isDefaultBusinessUnit((String)k.getBusinessUnitCode())).collect(Collectors.toList());
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).collect(Collectors.toList());
        this.activityPushSapBranch.createPromotionActivityBranch(verticalItemList);
    }

    public void updateActivityPushSapByPlanCodes(List<String> planCodes, boolean isClose) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = this.activityDetailPlanItemService.findByDetailPlanCode(planCodes);
        if (CollectionUtils.isEmpty(itemVoList)) {
            return;
        }
        List headquartersItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.isDefaultBusinessUnit((String)k.getBusinessUnitCode())).collect(Collectors.toList());
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).collect(Collectors.toList());
        this.activityPushSapBranch.updateOrClosePromotionActivityBranch(verticalItemList, isClose);
    }

    public void updateActivityPushSapByItemCodes(List<String> itemCodes, boolean isClose) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = this.activityDetailPlanItemService.findByItemCodes(itemCodes);
        if (CollectionUtils.isEmpty(itemVoList)) {
            return;
        }
        List headquartersItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.isDefaultBusinessUnit((String)k.getBusinessUnitCode())).collect(Collectors.toList());
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).collect(Collectors.toList());
        this.activityPushSapBranch.updateOrClosePromotionActivityBranch(verticalItemList, isClose);
    }
}

