/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.util;

import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarketingApprovalInfoBuilder {
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private ActivityDetailPlanPlanService activityDetailPlanPlanService;

    public Map<String, BudgetItemVo> getBudgetItemDataTypeCodeMap(List<MarketingApprovalVo> marketingApprovalVos) {
        if (CollectionUtils.isEmpty(marketingApprovalVos)) {
            return Maps.newHashMap();
        }
        List headBudgetItemCodes = marketingApprovalVos.stream().map(MarketingApprovalVo::getHeadBudgetItemCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List budgetItemCodes = marketingApprovalVos.stream().map(MarketingApprovalVo::getBudgetItemCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        budgetItemCodes.addAll(headBudgetItemCodes);
        List list = this.budgetItemService.findByCodes(budgetItemCodes);
        return list.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, v -> v, (v1, v2) -> v2));
    }
}

