/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.BusinessUnitSetTableService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessunitSetTableJob {
    private static final Logger log = LoggerFactory.getLogger(BusinessunitSetTableJob.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private BusinessUnitSetTableService businessUnitSetTableService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @DynamicTaskService(cornExpression="0 20 3 * * ?", taskDesc="\u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053-\u8dd1\u5e06\u8f6f")
    public void frJob() {
        this.loginUserService.refreshAuthentication(null);
        boolean hasLock = false;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String key = "BUSINESS_UNIT_SET_TABLE:" + sdf.format(date);
        try {
            hasLock = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!hasLock) {
                return;
            }
            log.info("=====>    \u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053-\u8dd1\u5e06\u8f6f[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            ArrayList yearMonths = Lists.newArrayList();
            YearMonth yearMonth = YearMonth.now();
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));
            yearMonth = yearMonth.plusMonths(-1L);
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));
            this.businessUnitSetTableService.frJob(yearMonths);
            log.info("=====>    \u4e1a\u52a1\u5355\u5143\u5957\u8868_\u6e20\u9053-\u8dd1\u5e06\u8f6f[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg((Exception)e));
        }
        finally {
            this.redisLockService.unlock(key);
        }
    }
}

