package com.biz.crm.tpm.business.activity.detail.plan.sdk.constant;

/**
 * 活动细案常量类
 */
public interface ActivityDetailPlanConstant {

    /**
     * 活动细案明细缓存分页键
     */
    String ACTIVITY_DETAIL_PLAN_ITEM_CACHE_NEW_KEY_PREFIX = "activity_detail_plan:item_cache:new:";

    /**
     * 活动细案变更明细缓存分页键
     */
    String ACTIVITY_DETAIL_PLAN_ITEM_CACHE_MODIFY_KEY_PREFIX = "activity_detail_plan:item_cache:modify:";

    /**
     * 活动细案关闭
     */
    String ACTIVITY_DETAIL_PLAN_ITEM_CLOSE_CODE_KEY_PREFIX = "activity_detail_plan:item_close:code:";

    /**
     * 活动细案编码前缀
     */
    String ACTIVITY_DETAIL_PLAN_RULE_CODE_PRE = "DP";

    /**
     * 活动细案明细编码前缀
     */
    String ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE = "Z-";

    String ACTIVITY_NUMBER = "MN-";


    /**
     * 活动细案变更编码前缀
     */
    String ACTIVITY_DETAIL_PLAN_MODIFY_RULE_CODE_PRE = "DC";

    /**
     * 活动方案保存锁
     */
    String LOCK_ACTIVITY_DETAIL_PLAN_SAVE = "activity_detail_plan:lock:save:";
    /**
     * 活动方案提交审批锁
     */
    String LOCK_ACTIVITY_DETAIL_PLAN_APPROVE = "activity_detail_plan:lock:approve:";
    /**
     * 活动细案明细关闭锁
     */
    String LOCK_ACTIVITY_DETAIL_PLAN_ITEM_CLOSE = "activity_detail_plan:lock:item_close:";

    /**
     * 活动细案批复表锁
     */
    String LOCK_ACTIVITY_DETAIL_PLAN_APPROVE_REPORT = "activity_detail_plan:lock:approve:report:";

    /**
     * 业态编码
     */
    String MDM_BUSINESS_FORMAT = "mdm_business_format";

    /**
     * 业态编码对应的SAP编码
     */
    String MDM_BUSINESS_FORMAT_SAP = "ZFYT";

    /**
     * 活动细案工作流标识
     */
    String PROCESS_NAME_ACTIVITY_DETAIL_PLAN = "activity_detail_plan";
    /**
     * 活动细案变更工作流标识
     */
    String PROCESS_NAME_ACTIVITY_DETAIL_PLAN_MODIFY = "activity_detail_plan_modify";

    /**
     * 活动细案审批通过的mq topic
     */
    String TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC = "TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC";


    /**
     * 数据字典-促销对象
     */
    String DICT_TPM_PROMOTION_OBJECT = "tpm_promotion_object";

    /**
     * 数据字典-核销类型
     */
    String DICT_TPM_AUDIT_TYPE = "tpm_audit_type";

    /**
     * 数据字典-是否
     */
    String DICT_YESORNO = "yesOrNo";

    /**
     * 结案形式
     */
    String CLOSING_FORM = "随单";

    /**
     * 是
     */
    String YES_Y = "Y";
    /**
     * 否
     */
    String NO_N = "N";


    String activityIntensityPattern = "\\d+[/]\\d+";

    /**
     * 采购方式
     */
    String purchaseMethod = "Purchase method";

}
