package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto;

/**
 * 活动方案占用预算表
 * @author wanghaojia
 * @date 2022/11/26 11:17
 */

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityDetailPlanBudgetDto", description = "活动细案明细预算")
public class ActivityDetailPlanBudgetDto extends TenantFlagOpDto {

    /**
     * 行索引
     */
    @ApiModelProperty("行索引")
    private Integer indexNo;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    private String relatePlanCode;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;
    /**
     * 关联方案编码
     */
    private List<String> relatePlanCodeList;

    /**
     * 关联策略编码
     */
    @ApiModelProperty("关联策略编码")
    private String relateStrategyCode;
    /**
     * 关联策略明细编码
     */
    @ApiModelProperty("关联策略明细编码")
    private String relateStrategyItemCode;
    /**
     * 占用类型，1-占用月度预算，2-占用方案预算
     */
    @ApiModelProperty(value = "占用类型", notes = "")
    private String occupyType;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    private String feeSourceName;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    private BigDecimal useAmount;
    private String useAmountStr;
    /**
     * 已占用金额
     */
    @ApiModelProperty(value = "已占用金额", notes = "")
    private BigDecimal usedAmount;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    private BigDecimal intraCompanyAmount;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;


    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    private BigDecimal downAmount;

    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    private String isAllDown;

    /**
     * 本次向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "本次向下规划金额（分子公司活动规划用）")
    private BigDecimal thisDownAmount;
}
