package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto;


import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * 活动细案(ActivityDetailPlan)
 *
 * @author wanghaojia
 * @since 2022-11-05 10:22:21
 */
@ApiModel(value = "ActivityDetailPlanDto", description = "活动细案Dto")
@Getter
@Setter
public class ActivityDetailPlanDto extends ActivityDetailPlanBase {

    /**
     * 关联方案数据
     */
    @ApiModelProperty("关联方案数据")
    private List<ActivityDetailPlanPlanDto> relatePlanList;
    /**
     * 关联方案数据
     */
    @ApiModelProperty("活动细案明细")
    private List<ActivityDetailPlanItemDto> itemList;


    @ApiModelProperty("来源")
    private String whereFrom;

    @ApiModelProperty("自动核销")
    private String autoAudit;

    @ApiModelProperty("是否汇总")
    private String isGather;

    @ApiModelProperty("汇总维度")
    private String summaryDimension;

    @ApiModelProperty("暂存（true:暂存,false:保存）")
    private Boolean tempSave;

    /**
     * 是否已校验
     */
    @ApiModelProperty(name = "是否已校验", notes = "")
    private String isValidate;

    @ApiModelProperty(name = "区域编码(字典MDM_CUSTOMIZE_ORG)", notes = "")
    private String regionCode;
    private List<String> regionCodeList;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    //查询条件
    Collection<String> idCollection;
    Collection<String> detailPlanCodeCollection;

    @ApiModelProperty(name = "out模块查询开始日期字段", notes = "")
    private String outStartTime;

    @ApiModelProperty(name = "out模块查询结束日期字段", notes = "")
    private String outEndTime;

    /**
     * 活动开始时间(查询用)
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginDate;

    /**
     * 活动结束时间(查询用)
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndDate;

    @ApiModelProperty(name = "是否生成分子预算", notes = "")
    private String isBudgetForecast;
}

