package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 11:22
 * @description：活动细案明细
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "活动细案明细")
public class ActivityDetailPlanItemDto extends ActivityDetailPlanItemBase {

    @ApiModelProperty("缓存ID")
    private String cacheKey;

    @ApiModelProperty("销售组织编码集合")
    private List<String> salesOrgCodes;

    private List<String> relatePlanItemCodeList;

    private List<String> detailPlanItemCodeList;

    /**
     * 细案id
     */
    @ApiModelProperty("细案id")
    private String detailPlanId;

    @ApiModelProperty("行索引")
    private Integer indexNo;

    /**
     * 方案对应明细
     */
    @ApiModelProperty("方案对应明细")
    private List<ActivityDetailPlanBudgetDto> budgetShares;

    @ApiModelProperty("活动开始日期筛选-开始")
    private String beginDateStart;

    @ApiModelProperty("活动开始日期筛选-结束")
    private String beginDateEnd;

    @ApiModelProperty("活动结束日期筛选-开始")
    private String endDateStart;

    @ApiModelProperty("活动结束日期筛选-结束")
    private String endDateEnd;

    @ApiModelProperty("活动细案明细编码")
    private List<String> excludeDetailPlanItemCodes;

    @ApiModelProperty("终端集合")
    List<ActivityDetailPlanItemTerminalDto> terminalList;
    /**
     * 冗余。查询使用
     */
    @ApiModelProperty("活动形式编码集合")
    private List<String> formCodes;

    @ApiModelProperty("活动分类编码集合")
    private List<String> typeCodes;

    @ApiModelProperty("客户编码集合")
    private List<String> customerCodes;

    @ApiModelProperty("取未完全退回预算细案数据")
    private Boolean noRollbackBudgetTagFlag;

    @ApiModelProperty("取未完全结案细案数据")
    private Boolean noWholeAuditFlag;
    @ApiModelProperty( notes = "销售大区")
    private	String	salesOrgRegionName;

    @ApiModelProperty("是否特批 Y-是, N-否")
    private String whetherSpeciallyApproved;

    /**
     * 查询使用
     */
    @ApiModelProperty("是否按时间先后顺序")
    private String isTimeAsc;

    /**
     * 查询标记
     */
    private String auditVerification;


    @ApiModelProperty("活动便签号")
    private String activityNumber;

    @ApiModelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    private String departmentName;

    /**
     * 查询当前时间在活动中的活动
     */
    private String nowTime;

    /**
     * 活动年月
     */
    private String activityYearMonth;

    @ApiModelProperty("核销审批状态")
    private String auditProcessStatus;

    /**
     * 区域细分编码
     */
    @ApiModelProperty("区域细分编码")
    private String activityOrgSubdivisionCode;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("是否关闭Y/N")
    private String isClose;

    @ApiModelProperty("零售商编码")
    private String systemCode;

    @ApiModelProperty("采购单审批状态")
    private String purchaseOrderProcessStatus;

    @ApiModelProperty("关联采购单")
    private String relatePurchaseOrder;

    @ApiModelProperty("是否关联物料采购单")
    private String isRelatePurchaseOrder;

    @ApiModelProperty("区域编码")
    private String activityOrgCode;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @ApiModelProperty(name = "收货联系人", notes = "收货联系人")
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @ApiModelProperty(name = "收货联系电话", notes = "收货联系电话")
    private String recipientPhone;
}
