package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author chenlong
 * @date 2022/11/30 11:30
 */
@ApiModel(value = "ActivityDetailPlanItemStatisticsDto", description = "TPM-活动细案明细统计费用合计dto")
@Getter
@Setter
public class ActivityDetailPlanItemStatisticsDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "开始时间", notes = "开始时间")
    private Date timeBegin;

    @ApiModelProperty(name = "结束", notes = "结束年月")
    private Date timeEnd;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    private String writeOffMethod;

    /**
     * 业态编码
     */
    @ApiModelProperty("业态编码")
    private String businessFormatCode;
    /**
     * 业务单元编码
     */
    @ApiModelProperty("业务单元编码")
    private String businessUnitCode;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    private String endCaseForm;

    @ApiModelProperty(name = "销售组织客户编码拼接", notes = "销售组织客户编码拼接")
    private List<String> orgCusCodes;

    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;

    /**
     * 区域编码集合
     */
    @ApiModelProperty(name = "regionCodeList", notes = "区域编码集合")
    private List<String> regionCodeList;

    /**
     * 零售商编码集合
     */
    @ApiModelProperty(name = "customerRetailerCodeList", notes = "零售商编码集合")
    private List<String> customerRetailerCodeList;

    /**
     * 品牌编码集合
     */
    @ApiModelProperty(name = "brandCodeList", notes = "品牌编码集合")
    private List<String> brandCodeList;

    @ApiModelProperty("客户编码列表")
    private List<String> customerCodeList;
}
