package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 11:22
 * @description：活动细案明细
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "活动细案明细")
public class ActivityDetailPlanItemTerminalDto extends TenantFlagOpDto {

    /**
     * 活动细案审批状态
     */
    @ApiModelProperty("活动细案审批状态")
    private String processStatus;

    @ApiModelProperty("活动号")
    private String  activityNumber;
    /**
     * 本品生产日期
     */
    @ApiModelProperty("本品生产日期")
    @JSONField(format = "yyyy-MM-dd")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date thisProductProductionDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String thisProductProductionDateStr;
    /**
     * 赠品生产日期
     */
    @ApiModelProperty("赠品生产日期")
    @JSONField(format = "yyyy-MM-dd")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date giftProductionDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String giftProductionDateStr;
    /**
     * 人员标准
     */
    @ApiModelProperty("人员标准")
    private String personnelStandards;
    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String telephone;

    @ApiModelProperty(name = "identityCard", notes = "身份证号")
    private String identityCard;
    /**
     * 员工ID
     */
    @ApiModelProperty("员工ID")
    private String employeeId;
    /**
     * 导购员姓名
     */
    @ApiModelProperty("导购员姓名")
    private String nameOfShoppingGuide;
    /**
     * 责任督导
     */
    @ApiModelProperty("责任督导")
    private String responsibleSupervision;
    /**
     * 责任业务
     */
    @ApiModelProperty("责任业务")
    private String responsibleBusiness;
    /**
     * 城市级别
     */
    @ApiModelProperty("城市级别")
    private String cityLevel;
    /**
     * 城市名称
     */
    @ApiModelProperty("城市名称")
    private String cityName;

    /**
     * 档期时间
     */
    @ApiModelProperty("档期时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH::mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH::mm:ss")
    private Date scheduleTime;
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH::mm:ss")
    private String scheduleTimeStr;
    /**
     * 是否档期
     */
    @ApiModelProperty("是否档期")
    private String onScheduleOrNot;
    /**
     * 投产比
     */
    @ApiModelProperty("投产比")
    private BigDecimal productionRatio;
    /**
     * 月度计划量
     */
    @ApiModelProperty("月度计划量")
    private BigDecimal monthlyPlannedQuantity;
    private String monthlyPlannedQuantityStr;
    /**
     * AC门店类型
     */
    @ApiModelProperty("AC门店类型")
    private String acStoreType;
    /**
     * AC分仓
     */
    @ApiModelProperty("AC分仓")
    private String acWarehouse;
    /**
     * AC分仓编码
     */
    @ApiModelProperty("AC分仓编码")
    private String acWarehouseCode;
    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    private String writeOffMethod;
    /**
     * 原供价（本品）
     */
    @ApiModelProperty("原供价（本品）")
    private BigDecimal originalSupplyPrice;
    private String originalSupplyPriceStr;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    private String taxRateStr;
    /**
     * 原未税价格（本品）
     */
    @ApiModelProperty("原未税价格（本品）")
    private BigDecimal originalPriceProduct;
    private String originalPriceProductStr;
    /**
     * 原供价（赠品）
     */
    @ApiModelProperty( "原供价（赠品）")
    private BigDecimal originalPriceGift;
    private String originalPriceGiftStr;
    /**
     * 原未税价格（赠品）
     */
    @ApiModelProperty("原未税价格（赠品）")
    private BigDecimal originalTaxPriceGift;
    private String originalTaxPriceGiftStr;
    /**
     * 促销含税供价
     */
    @ApiModelProperty("促销含税供价")
    private BigDecimal promotionPriceTax;
    private String promotionPriceTaxStr;
    /**
     * 促销未税供价
     */
    @ApiModelProperty("促销未税供价")
    private BigDecimal promotionNonTaxPrice;
    private String promotionNonTaxPriceStr;
    /**
     * 零售价
     */
    @ApiModelProperty("零售价")
    private BigDecimal retailPrice;
    private String retailPriceStr;
    /**
     * 促销售价
     */
    @ApiModelProperty("促销售价")
    private BigDecimal promotionalPrice;
    private String promotionalPriceStr;
    /**
     * 原毛利率
     */
    @ApiModelProperty("原毛利率")
    private BigDecimal originalGrossRate;
    private String originalGrossRateStr;
    /**
     * 促销毛利率
     */
    @ApiModelProperty("促销毛利率")
    private BigDecimal promotionalGrossRate;
    private String promotionalGrossRateStr;
    /**
     * 单件申请费用
     */
    @ApiModelProperty("单件申请费用")
    private BigDecimal singleApplicationFee;
    private String singleApplicationFeeStr;
    /**
     * 期间促销件数
     */
    @ApiModelProperty("期间促销件数")
    private Integer periodPromotionalNumber;
    private String periodPromotionalNumberStr;
    /**
     * 期间促销金额
     */
    @ApiModelProperty("期间促销金额")
    private BigDecimal periodPromotionalAmount;
    private String periodPromotionalAmountStr;
    /**
     * 系统承担金额
     */
    @ApiModelProperty("系统承担金额")
    private BigDecimal systemBorneAmount;
    private String systemBorneAmountStr;
    /**
     * 我方承担金额
     */
    @ApiModelProperty("我方承担金额")
    private BigDecimal ourCommitmentAmount;
    private String ourCommitmentAmountStr;
    /**
     * 单品计划量
     */
    @ApiModelProperty("单品计划量")
    private Integer plannedQuantitySingle;
    private String plannedQuantitySingleStr;
    /**
     * 单品投产比
     */
    @ApiModelProperty("单品投产比")
    private BigDecimal singleProductionRatio;
    private String singleProductionRatioStr;
    /**
     * 系统门店计划量
     */
    @ApiModelProperty("系统门店计划量")
    private Integer systemStoresQuantity;
    private String systemStoresQuantityStr;
    /**
     * 单店投产比
     */
    @ApiModelProperty("单店投产比")
    private BigDecimal storesProductionRatio;
    private String storesProductionRatioStr;
    /**
     * 系统月计划量
     */
    @ApiModelProperty("系统月计划量")
    private Integer systemMonthlyQuantity;
    private String systemMonthlyQuantityStr;
    /**
     * 是否公用
     */
    @ApiModelProperty("是否公用")
    private String publicOrNot;
    /**
     * 门店公用量
     */
    @ApiModelProperty("门店公用量")
    private Integer storeUtility;
    private String storeUtilityStr;
    /**
     * 门店公用金额
     */
    @ApiModelProperty("门店公用金额")
    private BigDecimal storePublicAmount;
    private String storePublicAmountStr;
    /**
     * 浮动率
     */
    @ApiModelProperty("浮动率")
    private BigDecimal floatingRate;
    private String floatingRateStr;
    /**
     * 浮动量
     */
    @ApiModelProperty("浮动量")
    private BigDecimal floatingNumber;
    private String floatingNumberStr;
    /**
     * 浮动金额
     */
    @ApiModelProperty("浮动金额")
    private BigDecimal floatingAmount;
    private String floatingAmountStr;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * 城市经理
     */
    @ApiModelProperty("城市经理")
    private String cityManager;
    /**
     * 未含税单价
     */
    @ApiModelProperty("未含税单价")
    private BigDecimal priceExcludingTax;
    private String priceExcludingTaxStr;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal priceIncludingTax;
    private String priceIncludingTaxStr;
    /**
     * 未含税金额
     */
    @ApiModelProperty("未含税金额")
    private BigDecimal amountExcludingTax;
    private String amountExcludingTaxStr;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amountIncludingTax;
    private String amountIncludingTaxStr;
    /**
     * 扣费细项
     */
    @ApiModelProperty("扣费细项")
    private String deductionDetails;
    /**
     * 扣费类型
     */
    @ApiModelProperty("扣费类型")
    private String deductionType;
    /**
     * 扣费标准
     */
    @ApiModelProperty("扣费标准")
    private String deductionStandard;
    /**
     * GMV
     */
    @ApiModelProperty("GMV")
    private String gmv;
    /**
     * 费率
     */
    @ApiModelProperty("费率")
    private BigDecimal rate;
    /**
     * 平台
     */
    @ApiModelProperty("平台")
    private String platform;





    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案名称")
    private String detailPlanName;
    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;
    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    private String templateConfigCode;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;
    /**
     * 活动类型-前端用
     */
    @ApiModelProperty("活动类型-前端用")
    private String activityType;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;
    /**
     * 活动形式-前端用
     */
    @ApiModelProperty("活动形式-前端用")
    private String activityForm;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    /**
     * 活动开始时间-字符串，前端传
     */
    @ApiModelProperty("活动开始时间-字符串，前端传")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityBeginDateStr;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;
    /**
     * 活动结束时间-字符串，前端传
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityEndDateStr;
    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderEndDate;
    /**
     * 订单开始时间-字符串，前端用
     */
    @ApiModelProperty("订单开始时间-字符串，前端用")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String orderBeginDateStr;
    /**
     * 订单结束时间-字符串，前端用
     */
    @ApiModelProperty("订单结束时间-字符串，前端用")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String orderEndDateStr;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @DateTimeFormat(pattern = "yyyy-MM")
    private String feeYearMonthStr;

    /**
     * 业态编码
     */
    @ApiModelProperty(value = "业态编码", notes = "")
    private String businessFormatCode;
    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "业务单元编码", notes = "")
    private String businessUnitCode;
    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String activityOrgName;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    @CrmExcelColumn(value = "客户组编码")
    private String customerGroupCode;
    @CrmExcelColumn(value = "客户组名称")
    private String customerGroupName;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    private String secondChannelName;
    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    private String headMonthBudgetCode;
    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    private String headBudgetItemName;
    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    private String budgetItemName;
    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区公投预算编码", notes = "")
    private String regionReferendumMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区公投预算项目编码", notes = "")
    private String regionReferendumBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区公投预算项目名称", notes = "")
    private String regionReferendumBudgetItemName;

    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区自投预算编码", notes = "")
    private String regionAutomaticMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区自投预算项目编码", notes = "")
    private String regionAutomaticBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区自投预算项目名称", notes = "")
    private String regionAutomaticBudgetItemName;

    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    private String relatePlanCode;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;
    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String terminalName;
    /**
     * 门店类型
     */
    @ApiModelProperty(name = "门店类型", notes = "门店类型")
    private String terminalType;
    /**
     * 门店数量
     */
    @ApiModelProperty("门店数量")
    private Integer terminalQuantity;
    /**
     * 门店数量-字符串，前端用
     */
    @ApiModelProperty("门店数量-字符串，前端用")
    private String terminalQuantityStr;
    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    private String systemName;
    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;
    /**
     * 单位编码
     */
    @ApiModelProperty("单位编码")
    private String productUnit;
    /**
     * 原品价格
     */
    @ApiModelProperty("原品价格")
    private BigDecimal productPrice;
    /**
     * 原品价格-字符串，前端用
     */
    @ApiModelProperty("原品价格-字符串，前端用")
    private String productPriceStr;
    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    private Integer productQuantity;
    /**
     * 原品数量-字符串，前端用
     */
    @ApiModelProperty("原品数量-字符串，前端用")
    private String productQuantityStr;
    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    private String giftName;
    /**
     * 赠品价格
     */
    @ApiModelProperty("赠品价格")
    private BigDecimal giftPrice;
    /**
     * 赠品价格-字符串，前端用
     */
    @ApiModelProperty("赠品价格-字符串，前端用")
    private String giftPriceStr;
    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    private Integer giftQuantity;
    /**
     * 赠品数量-字符串，前端用
     */
    @ApiModelProperty("赠品数量-字符串，前端用")
    private String giftQuantityStr;
    /**
     * 促销政策编码
     */
    @ApiModelProperty("促销政策编码")
    private String promotionCode;
    /**
     * 促销政策名称
     */
    @ApiModelProperty("促销政策名称")
    private String promotionName;
    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    private String promotionObject;
    /**
     * 陈列类型
     */
    @ApiModelProperty("陈列类型")
    private String displayType;
    /**
     * 单价
     */
    @ApiModelProperty("单价")
    private BigDecimal price;
    /**
     * 单价-字符串，前端用
     */
    @ApiModelProperty("单价-字符串，前端用")
    private String priceStr;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Integer quantity;
    /**
     * 数量-字符串，前端用
     */
    @ApiModelProperty("数量-字符串，前端用")
    private String quantityStr;
    /**
     * 费用金额
     */
    @ApiModelProperty("费用金额")
    private BigDecimal feeAmount;
    /**
     * 费用金额-字符串，前端用
     */
    @ApiModelProperty("费用金额-字符串，前端用")
    private String feeAmountStr;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 总部承担金额-字符串，前端用
     */
    @ApiModelProperty("总部承担金额-字符串，前端用")
    private String headFeeAmountStr;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 大区承担金额-字符串，前端用
     */
    @ApiModelProperty("大区承担金额-字符串，前端用")
    private String departmentFeeAmountStr;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    /**
     * 客户承担金额-字符串，前端用
     */
    @ApiModelProperty("客户承担金额-字符串，前端用")
    private String customerFeeAmountStr;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;
    /**
     * 费用合计-字符串，前端用
     */
    @ApiModelProperty("费用合计-字符串，前端用")
    private String totalFeeAmountStr;
    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    private BigDecimal regionReferendumFeeAmount;
    /**
     *大区公投预算金额（元）-字符串，前端用
     */
    @ApiModelProperty("大区公投预算金额（元）-字符串，前端用")
    private String regionReferendumFeeAmountStr;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    private BigDecimal regionAutomaticFeeAmount;
    /**
     *大区自投预算金额（元）-字符串，前端用
     */
    @ApiModelProperty("大区自投预算金额（元）-字符串，前端用")
    private String regionAutomaticFeeAmountStr;

    /**
     * 门店预计月销售额
     */
    @ApiModelProperty("门店预计月销售额")
    private BigDecimal terminalMonthSalesAmount;
    /**
     * 门店预计月销售额-字符串，前端用
     */
    @ApiModelProperty("门店预计月销售额-字符串，前端用")
    private String terminalMonthSalesAmountStr;
    /**
     * 门店预计月销售额
     */
    @ApiModelProperty("门店预计月销售额")
    private BigDecimal terminalLastMonthSalesAmount;
    /**
     * 上月门店实际月销售额-字符串，前端用
     */
    @ApiModelProperty("上月门店实际月销售额-字符串，前端用")
    private String terminalLastMonthSalesAmountStr;
    /**
     * 扣款方式
     */
    @ApiModelProperty("扣款方式/是否扣款，   Y是N否")
    private String deductType;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    private String auditForm;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String paymentMethod;
    /**
     * 竞品情况
     */
    @ApiModelProperty("竞品情况")
    private String compatibleProductSituation;
    /**
     * 是否和价格有关
     */
    @ApiModelProperty("是否和价格有关")
    private String relateToPrice;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    private String auditConditionName;
    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    private String activityDesc;
    /**
     * 共用组
     */
    @ApiModelProperty("共用组")
    private String commonGroup;
    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    private String materialName;
    /**
     * 物料单位
     */
    @ApiModelProperty("物料单位")
    private String materialUnit;
    /**
     * 物料单价
     */
    @ApiModelProperty("物料单价")
    private BigDecimal materialPrice;
    /**
     * 物料单价-字符串，前端用
     */
    @ApiModelProperty("物料单价-字符串，前端用")
    private String materialPriceStr;
    /**
     * 物料数量
     */
    @ApiModelProperty("物料数量")
    private BigDecimal materialQuantity;
    /**
     * 物料数量-字符串，前端用
     */
    @ApiModelProperty("物料数量-字符串，前端用")
    private String materialQuantityStr;
    /**
     * 采购类型
     */
    @ApiModelProperty("采购类型")
    private String procurementType;
    /**
     * 合同编码
     */
    @ApiModelProperty("合同编码")
    private String contractCode;
    /**
     * 账期
     */
    @ApiModelProperty("账期")
    private String paymentDays;
    /**
     * 推广场次
     */
    @ApiModelProperty("推广场次")
    private Integer promoteNumber;
    /**
     * 推广场次-字符串，前端用
     */
    @ApiModelProperty("推广场次-字符串，前端用")
    private String promoteNumberStr;
    /**
     * 单场费用
     */
    @ApiModelProperty("单场费用")
    private BigDecimal singleFeeAmount;
    /**
     * 单场费用-字符串，前端用
     */
    @ApiModelProperty("单场费用-字符串，前端用")
    private String singleFeeAmountStr;
    /**
     * 考核产品编码
     */
    @ApiModelProperty("考核产品编码")
    private String assessProductCode;
    /**
     * 考核产品名称
     */
    @ApiModelProperty("考核产品名称")
    private String assessProductName;
    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    private String buyWay;

    /**
     * 是否关闭，   Y是N否
     */
    @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
    private String isClose;

    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    private BigDecimal downAmount;
    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    private String isAllDown;
    /**
     * 是否完全结案
     */
    @ApiModelProperty("是否完全结案")
    private String wholeAudit;
    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;

    /**
     * 是否选中，0否1是
     */
    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    /**
     * 是否完全上账
     */
    @ApiModelProperty("是否完全上账")
    private String wholeUpAccount;

    /**
     * 已上账金额
     */
    @ApiModelProperty("已上账金额")
    private BigDecimal alreadyUpAccountAmount;
    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    private BigDecimal intraCompanyAmount;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    private String intraCompanyAmountStr;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    private BigDecimal offPointAmount;

    @ApiModelProperty("分子公司点外金额")
    private String offPointAmountStr;

    @ApiModelProperty("推送牛人管家标记")
    private String cowManagerState;

    @ApiModelProperty("推送Sap状态标记")
    private String sapInterfaceState;

    /**
     * 结案周期
     */
    @ApiModelProperty("结案周期")
    private String auditCycle;
    /**
     * 月销售任务
     */
    @ApiModelProperty("月销售任务")
    private BigDecimal monthSalesTarget;
    /**
     * 目前铺市率
     */
    @ApiModelProperty("目前铺市率")
    private BigDecimal currentMarketRate;
    /**
     * 月目标铺市率
     */
    @ApiModelProperty("月目标铺市率")
    private BigDecimal monthTargetMarketRate;
    /**
     * 月销售任务-字符串，前端用
     */
    @ApiModelProperty("月销售任务-字符串，前端用")
    private String monthSalesTargetStr;
    /**
     * 目前铺市率-字符串，前端用
     */
    @ApiModelProperty("目前铺市率-字符串，前端用")
    private String currentMarketRateStr;
    /**
     * 月目标铺市率-字符串，前端用
     */
    @ApiModelProperty("月目标铺市率-字符串，前端用")
    private String monthTargetMarketRateStr;
    /**
     * 是否发起巡查需求
     */
    @ApiModelProperty("是否发起巡查需求")
    private String isStartPatrol;
    /**
     * 期间促销量（件）
     */
    @ApiModelProperty("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;
    /**
     * 期间促销额（元）
     */
    @ApiModelProperty("期间促销额（元）")
    private BigDecimal periodPromoteAmount;
    /**
     * 期间渠道促销量（件）
     */
    @ApiModelProperty("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;
    /**
     * 期间渠道促销额（元）
     */
    @ApiModelProperty("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;
    /**
     * 全月回复量（件）
     */
    @ApiModelProperty("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    /**
     * 全月回复额（元）
     */
    @ApiModelProperty("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    /**
     * 本月投入产出比
     */
    @ApiModelProperty("本月投入产出比")
    private BigDecimal monthPutOutputRatio;
    /**
     * 期间促销量（件）-字符串，前端用
     */
    @ApiModelProperty("期间促销量（件）-字符串，前端用")
    private String periodPromoteQuantityStr;
    /**
     * 期间促销额（元）-字符串，前端用
     */
    @ApiModelProperty("期间促销额（元）-字符串，前端用")
    private String periodPromoteAmountStr;
    /**
     * 期间渠道促销量（件）-字符串，前端用
     */
    @ApiModelProperty("期间渠道促销量（件）-字符串，前端用")
    private String periodChPromoteQuantityStr;
    /**
     * 期间渠道促销额（元）-字符串，前端用
     */
    @ApiModelProperty("期间渠道促销额（元）-字符串，前端用")
    private String periodChPromoteAmountStr;
    /**
     * 全月回复量（件）-字符串，前端用
     */
    @ApiModelProperty("全月回复量（件）-字符串，前端用")
    private String monthReturnQuantityStr;
    /**
     * 全月回复额（元）-字符串，前端用
     */
    @ApiModelProperty("全月回复额（元）-字符串，前端用")
    private String monthReturnAmountStr;
    /**
     * 本月投入产出比-字符串，前端用
     */
    @ApiModelProperty("本月投入产出比-字符串，前端用")
    private String monthPutOutputRatioStr;

    @ApiModelProperty("系统承担比例")
    private BigDecimal systemAssumeRatio;
    private String systemAssumeRatioStr;

    @ApiModelProperty("我方承担比例")
    private BigDecimal ourAssumeRatio;
    private String ourAssumeRatioStr;

    @ApiModelProperty("门店月计划量")
    private BigDecimal terminalMonthPlanQuantity;
    private String terminalMonthPlanQuantityStr;

    @ApiModelProperty("门店共用量")
    private BigDecimal terminalTotalQuantity;
    private String terminalTotalQuantityStr;

    @ApiModelProperty("门店共用金额")
    private BigDecimal terminalTotalAmount;
    private String terminalTotalAmountStr;

    @ApiModelProperty("陈列数量")
    private BigDecimal displayQuantity;
    private String displayQuantityStr;

    @ApiModelProperty("陈列单价")
    private BigDecimal displayPrice;
    private String displayPriceStr;
    /**
     * 身份证号码
     */
    @ApiModelProperty("身份证号码")
    private String personIdCard;
    /**
     * 人员类型
     */
    @ApiModelProperty("人员类型")
    private String personType;
    /**
     * 人员名称
     */
    @ApiModelProperty("人员名称")
    private String personName;
    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    private String personCode;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    private String promotionType;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;
    @ApiModelProperty("分销渠道名称")
    private String distributionChannelName;


    /** 预估销售额 */
    @ApiModelProperty(name = "salesAmount",notes = "预估销售额", value= "预估销售额")
    private BigDecimal salesAmount;
    private String salesAmountStr;

    @ApiModelProperty("采购类型")
    private String isTypeOfPurchaseNo;

    @ApiModelProperty("投产比")
    private String productionRatioStr;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private String applyAmountStr;
    private BigDecimal applyAmount;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("手续费点数")
    private String commissionPointStr;
    private BigDecimal commissionPoint;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("手续费金额")
    private String commissionAmountStr;
    private BigDecimal commissionAmount;

    /**
     * 档期开始日期（字符）
     */
    @ApiModelProperty("档期开始日期（字符）")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String scheduleBeginDateStr;
    /**
     * 档期开始日期
     */
    @ApiModelProperty("档期开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleBeginDate;
    /**
     * 档期结束日期（字符）
     */
    @ApiModelProperty("档期结束日期（字符）")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String scheduleEndDateStr;
    /**
     * 档期结束日期
     */
    @ApiModelProperty("档期结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleEndDate;


    /**
     * 形式说明
     */
    @ApiModelProperty("形式说明")
    private String formDescription;

    /**
     * 是否涨价政策
     */
    @ApiModelProperty("是否涨价政策")
    private String increasePricePromotion;

    /**
     * 是否责任利润调整
     */
    @ApiModelProperty("是否责任利润调整")
    private String dutyProfitAdjust;

    /**
     * 新品归类
     */
    @ApiModelProperty("新品归类")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @ApiModelProperty("是否占用划拨预算")
    private String occupyTransferBudget;

    @ApiModelProperty("是否扣减费用池")
    private String isDeductionFeePool;

    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    private String salesRegionCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("省区")
    private String salesOrgCode;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    private String auditType;

    @ApiModelProperty("活动力度")
    private String activityIntensity;

}
