package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/29 16:50
 * @description：活动细案产品分摊
 */
@ApiModel(value = "ActivityDetailPlanProductDto", description = "活动细案产品分摊")
@Getter
@Setter
public class ActivityDetailPlanProductDto extends TenantFlagOpDto {

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;
    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 产品比例
     */
    @ApiModelProperty(value = "产品比例", notes = "")
    private BigDecimal productRatio;

    /**
     * 单价优惠金额
     */
    @ApiModelProperty(value = "单价优惠金额", notes = "")
    private BigDecimal discountAmount;

    /**
     * 点外金额
     */
    @ApiModelProperty(value = "点外金额", notes = "")
    private BigDecimal offAmount;

    /**
     * 点内金额
     */
    @ApiModelProperty(value = "点内金额", notes = "")
    private BigDecimal internalAmount;

    /**
     * 自投金额
     */
    @ApiModelProperty(value = "自投金额", notes = "")
    private BigDecimal autoAmount;

    /**
     * 总金额
     */
    @ApiModelProperty(value = "总金额", notes = "")
    private BigDecimal totalAmount;
}
