package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wanghaojia
 * @date 2023/1/5 15:05
 */
@Data
public class ActivityDetailPlanItemPushSfaDto {

    @ApiModelProperty(value = "细案编码")
    private String detailPlanCode;

    @ApiModelProperty(value = "细案明细编码")
    private String detailPlanItemCode;

    /**
     * 是否临时方案
     */
    @ApiModelProperty("是否临时方案")
    private String isTemporary;

    /**
     * 活动分类编码
     */
    private String activityTypeCode;
    /**
     * 活动分类名称
     */
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    private String activityFormName;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    private String headMonthBudgetCode;
    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    private String headBudgetItemName;


    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    private String budgetItemName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 费用金额
     */
    @ApiModelProperty("费用金额")
    private BigDecimal feeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;

    /**
     * 单人支持金额
     */
    private BigDecimal personAmount;
    /**
     * 支持人数
     */
    private Integer personCount;



    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

}
