package com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * SFA推送TPM创建活动方案Dto
 * @author wanghaojia
 * @date 2023/1/5 15:24
 */
@Data
@ApiModel(value = "SFA推送TPM创建活动细案Dto")
public class SfaActivityDetailPlanCreateDto {

    @ApiModelProperty(value = "费用申请编号")
    private String displayCostCode;
    @ApiModelProperty(value = "费用月份")
    private String costYearMonth;
    @ApiModelProperty(value = "MDG客户编码")
    private String orgCode;
    @ApiModelProperty(value = "MDG客户名称")
    private String orgName;
    @ApiModelProperty(value = "方案明细编码")
    private String tpmPlanCode;
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;
    @ApiModelProperty(value = "门店名称")
    private String terminalName;
    @ApiModelProperty(value = "门店二级渠道")
    private String twoChannelCode;
    @ApiModelProperty(value = "申请金额")
    private BigDecimal totalApplyAmount;
    @ApiModelProperty(value = "经销商承担金额")
    private BigDecimal totalDealerAmount;
    @ApiModelProperty(value = "活动方案编码")
    private String planItemCode;

}
