package com.biz.crm.tpm.business.activity.detail.plan.sdk.event.log;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanItemCloseLogEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanItemLogEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanLogEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanModifyLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 日志监听
 *
 * @author: yaoyongming
 * @date: 2023/4/11 14:45
 */
public interface ActivityDetailPlanLogEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(ActivityDetailPlanLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(ActivityDetailPlanLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(ActivityDetailPlanLogEventDto eventDto);
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreateModify(ActivityDetailPlanModifyLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDeleteModify(ActivityDetailPlanModifyLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdateModify(ActivityDetailPlanModifyLogEventDto eventDto);
    /**
     * 关闭日志
     *
     * @param eventDto
     */
    void onClosed(ActivityDetailPlanLogEventDto eventDto);
    /**
     * 关闭日志
     *
     * @param eventDto
     */
    void onItemClosed(ActivityDetailPlanItemCloseLogEventDto eventDto);
}
