package com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.dto;


import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 活动细案-关联活动方案表(ActivityDetailPlanPlan)
 *
 * @author wanghaojia
 * @since 2022-11-12 17:52:10
 */
@ApiModel(value = "ActivityDetailPlanPlanModifyDto", description = "活动细案-关联活动方案表Dto")
@Getter
@Setter
public class ActivityDetailPlanPlanModifyDto extends TenantFlagOpDto {

    private String modifyBusinessCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 已申请金额
     */
    @ApiModelProperty("已申请金额")
    private BigDecimal usedAmount;
    /**
     * 本次使用方案金额
     */
    @ApiModelProperty("本次使用方案金额")
    private BigDecimal usePlanAmount;


}

