package com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.enums;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.constant.ActivityDetailPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.constant.ActivityPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.enums.ActivityPlanModifyMqTagEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 分子公司细案变更审批通过调用mq tag枚举
 * @author wanghaojia
 * @date 2023/1/16 21:00
 */
@AllArgsConstructor
@Getter
public enum ActivityDetailPlanModifyMqTagEnum {

    PASS_UPDATE_ORIGIN(ActivityDetailPlanModifyMqConstant.PASS_UPDATE_ORIGIN,"活动细案变更审批通过更新细案数据", PushType.code),
    //更新SD数据放在原数据更新完之后调用
//    PASS_UPDATE_SD(SubComActivityDetailPlanModifyPassMqTagConstant.PASS_UPDATE_SD,"分子活动细案变更审批通过更新sd活动数据", PushType.after_update_plan),
    PASS_UPDATE_CLOSE_CECORD_DETAIL(ActivityDetailPlanModifyMqConstant.PASS_UPDATE_CLOSE_CECORD_DETAIL,"活动细案变更审批通过自动变更方案预算跟踪表", ActivityDetailPlanModifyMqTagEnum.PushType.after_update_origin),
    ;

    private final String code;

    private final String name;

    private final PushType pushType;

    public enum PushType{
        code,after_update_origin
    }

}
