package com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动细案(ActivityDetailPlan)
 *
 * @author wanghaojia
 * @since 2022-11-05 10:22:21
 */
@ApiModel(value = "ActivityDetailPlanBase", description = "活动细案Dto")
@Getter
@Setter
public class ActivityDetailPlanBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;


    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案名称")
    private String detailPlanName;

    /**
     * 外部系统活动细案编码
     */
    @ApiModelProperty("外部系统活动细案编码")
    private String foreignPlanCode;
    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    private String templateConfigCode;

    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    private String templateConfigName;

    /**
     * 是否临时方案
     */
    @ApiModelProperty("是否临时方案")
    private String isTemporary;

    @ApiModelProperty("是否汇总")
    private String isGather;

    @ApiModelProperty("汇总维度")
    private String summaryDimension;
    /**
     * 预估费用 -我方承担金额
     */
    @ApiModelProperty("预估费用 -我方承担金额")
    private BigDecimal feeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;
    /**
     * 细案说明
     */
    @ApiModelProperty("细案说明")
    private String detailPlanExplain;
    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

    /**
     * 活动状态
     */
    @ApiModelProperty("活动状态")
    private String planStatus;

    @ApiModelProperty("手动关闭时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date closeDate;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("方案编码")
    private String planCode;

    @ApiModelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("未含税单价")
    private BigDecimal priceExcludingTax;
    private String priceExcludingTaxStr;

    @ApiModelProperty("含税单价")
    private BigDecimal priceIncludingTax;
    private String priceIncludingTaxStr;

    @ApiModelProperty("未含税金额")
    private BigDecimal amountExcludingTax;
    private String amountExcludingTaxStr;

    @ApiModelProperty("含税金额")
    private BigDecimal amountIncludingTax;
    private String amountIncludingTaxStr;


}


