package com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo;

/**
 * 活动方案占用预算表
 * @author wanghaojia
 * @date 2022/11/26 11:17
 */

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Getter
@Setter
public class ActivityDetailPlanBudgetModifyBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;

    
    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    private String modifyBusinessCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 关联策略编码
     */
    @ApiModelProperty("关联策略编码")
    private String relateStrategyCode;
    /**
     * 关联策略明细编码
     */
    @ApiModelProperty("关联策略明细编码")
    private String relateStrategyItemCode;
    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    private String relatePlanCode;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;
    /**
     * 占用类型，1-占用月度预算，2-占用方案预算
     */
    @ApiModelProperty(value = "占用类型", notes = "")
    private String occupyType;
    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    private BigDecimal useAmount;
    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    private BigDecimal intraCompanyAmount;

    @ApiModelProperty("客户编码")
    private String customerCode;

}
