package com.biz.crm.tpm.business.activity.detail.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 活动细案(ActivityDetailPlan)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
public interface ActivityDetailPlanItemSdkService {

    /**
     * 分页查询所有数据
     *
     * @param pageable                  分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanItemVo> findByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 查询所有数据(小维度)
     *
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    List<ActivityDetailPlanItemVo> findByConditionsList(ActivityDetailPlanItemDto activityDetailPlanItemDto);
    /**
     * 获取对应客户的明细列表
     * @param activityDetailPlanItemDto 条件参数
     * @return 对应客户的明细列表
     */
    List<ActivityDetailPlanItemVo> findByCustomerCode(ActivityDetailPlanItemDto activityDetailPlanItemDto);


    /**
     * 获取客户列表
     * @return 客户列表
     */
    Set<String> findCustomer(ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 根据明细编码查询明细
     *
     * @param itemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo>
     * @author huojia
     * @date 2022/11/27 19:29
     **/
    List<ActivityDetailPlanItemVo> listByItemCodeList(List<String> itemCodeList);

    /**
     * 核销分页查询活动细案明细
     *
     * @param pageable
     * @param activityDetailPlanItemDto 查询条件
     * @return
     */
    Page<ActivityDetailPlanItemVo> findForAudit(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 核销查询活动细案明细
     *
     * @param activityDetails 明细编码
     * @return
     */
    List<ActivityDetailPlanItemVo> findForAuditByCodes(Set<String> activityDetails);

    /**
     * 核销修改是否完全核销和结案金额
     *
     * @param activityDetailPlanItemDtos
     */
    void changeActivityDetailAuditInfo(List<ActivityDetailPlanItemDto> activityDetailPlanItemDtos);

    /**
     * 更新向下规划金额
     *
     * @param operationBudgetList
     * @author huojia
     * @date 2022/11/30 22:06
     **/
    void operationBudget(List<ActivityDetailPlanBudgetDto> operationBudgetList);

    /**
     * 根据活动明细编码查询明细
     *
     * @param itemCodes        活动明细编码
     * @param businessUnitCode
     * @return
     */
    List<ActivityDetailPlanItemVo> findByActivityDetailItemCodes(Set<String> itemCodes);

    List<ActivityDetailPlanItemVo> findByActivityDetailItemCodes(Set<String> itemCodes, String businessUnitCode);

    /**
     * 根据客户与区域 统计费用合计
     *
     * @param dto 活动明细编码
     * @return Map<String, BigDecimal>
     */
    Map<String, BigDecimal> statisticsFeeAmountByCusOrgCodes(ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 分页获取审批通过且上账状态为未完全上账的活动细案明细
     * @param pageable
     * @return
     */
    Page<ActivityDetailPlanItemVo> findForWithholding(Pageable pageable, String operationType, ActivityDetailPlanItemDto dto);

    /**
     * 根据活动细案编码查询产品分摊
     * @param activityDetailCodeSet
     * @return
     */
    List<ActivityDetailPlanProductVo> findApportionProductByActivityDetailCodes(Set<String> activityDetailCodeSet);

    /**
     * 分页获取审批通过且上账状态为未完全上账的分子公司的活动细案明细
     * @param pageable
     * @return
     */
    Page<ActivityDetailPlanItemVo> findUpwardDetailForWithholding(Pageable pageable, ActivityDetailPlanItemDto upwardDto);

    List<ActivityDetailPlanItemVo> findSubComActivityDetailByYearMonth(String yearMonth, List<String> subComCustomerErpCodeList);

    /**
     * 根据品牌，零售商，区域统计细案明细的费用合计 key=零售商-区域-品牌，value=金额 （下月事中费用）
     *
     * @param dto 请求dto
     * @return Map<String, BigDecimal>
     */
    Map<String, BigDecimal> statisticsDetailPlanItemTotalFee(ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 根据品牌，零售商，区域统计细案明细数据 key=零售商-区域-品牌，value=金额 （下月预计上账费用）
     *
     * @param dto 请求dto
     * @return Map<String, BigDecimal>
     */
    Map<String, BigDecimal> statisNextMonthPredictAccountFee(ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 根据品牌，零售商，区域统计细案明细数据 key=零售商-区域-品牌，value=金额 （折扣上账金额）
     *
     * @param dto 请求dto
     * @return Map<String, BigDecimal>
     */
    Map<String, BigDecimal> statisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 查询所有推送sap且在活动执行中的明细编码及其销售组织编码.
     *      参数'planCode'为空则查所有。
     * @param planCode 细案编码
     * @return Map<String,String> key:明细编码，value：销售组织编码
     */
    Map<String,String> findItemCodesByDetailPlanCodes(String planCode);

    /**
     * 查询细案对应的预算
     * @param detailPlanItemCodes
     * @return
     */
    List<ActivityDetailPlanBudgetVo> findBudgetByCodes(List<String> detailPlanItemCodes);
    /**
     * 根据活动细案明细编码获取可推送的明细集合
     * @param itemCodes 明细编码集合
     * @return 明细集合
     */
    List<ActivityDetailPlanItemVo> findByItemCodes(List<String> itemCodes);

    /**
     * 根据活动细案明细编码获取明细集合
     * @param itemCodes 明细编码集合
     * @return 明细集合
     */
    List<ActivityDetailPlanItemVo> findDetailAndExtendByItemCodes(List<String> itemCodes);

    /**
     * 查询总条数
     * @param activityDetailPlanItemDto
     * @return
     */
    int findTotalForAudit(ActivityDetailPlanItemDto activityDetailPlanItemDto);

    /**
     * 查询可核销数据
     * @param autoAuditParams 查询参数
     * @return List
     */
    Page<ActivityDetailPlanItemVo> findCanAutoAuditItemPage(Pageable pageable, AutoAuditParamsDto autoAuditParams);
    /**
     * 获取分子向上关联细案明细总条数
     * @param planItemDto
     * @return
     */
    Integer getSubRelatedItemTotal(ActivityDetailPlanItemDto planItemDto);

    List<ActivityDetailPlanItemVo> findSubRelatedCachePageList(Integer num,Integer size, ActivityDetailPlanItemDto dto);

    BigDecimal findByCode(String detailPlanItemCode);

    /**
     * 查询活动明细
     * @param itemCode
     * @return
     */
    ActivityDetailPlanItemVo getActivityDetailPlanItemByCode(String itemCode);

    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细总条数
     *
     * @param selectDto
     * @return
     */
    Integer getExtractAuditDetailPlanCheckDataTotal(ActivityDetailPlanItemDto selectDto);

    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细详情
     *
     * @param selectDto
     * @param pageNumber
     * @param pageSize
     * @return
     */
    List<ActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(ActivityDetailPlanItemDto selectDto, int pageNumber, int pageSize);
    /**
     * 方案自动生成的细案，根据方案编码查询
     * @param planCode
     * @return
     */
    List<ActivityDetailPlanItemVo> findByPlanItemCode(String planCode);

    /**
     * 根据
     * @param planItemCodes
     * @return
     */
    List<ActivityDetailPlanItemVo> findByRegionPlanItemCodes(List<String> planItemCodes);

    /**
     * 根据方案明细编码或方案编码查关联细案明细数量
     *
     * @param detailPlanItemCodes
     * @param planCodes
     * @return
     */
    Integer findByItemCodesOrPlanCods(Set<String> detailPlanItemCodes, Set<String> planCodes);

    /**
     * 根据总部方案编码查关联方案的细案明细
     * @param cods
     * @return
     */
    List<ActivityDetailPlanItemVo> findByPlanCodes(Set<String> cods);

    List<ActivityDetailPlanItemVo> listForVariable(ActivityDetailPlanItemDto dto);

    List<ActivityDetailPlanItemVo> findListByPlanItemCode(String planItemCode);

    /**
     * 根据活动方案编码查 细案明细
     *
     * @param set
     * @return
     */
    List<ActivityDetailPlanItemVo> findByPlanItemCodes(Set<String> set);

    List<String> findDetailItemCodesByPlanItemCodes(List<String> planItemCodes);

    List<SalesApprovalVo> findPsmList(SalesApprovalDto salesApprovalDto);

    /**
     * 根据上级方案明细编码查 细案明细
     *
     * @param set
     * @return
     */
    List<ActivityDetailPlanItemVo> findByRelatePlanItemCodes(Set<String> set);

    void updateAuditStatusByActivityDetailCodes(List<String> newActivityDetailCodes, List<String> delActivityDetailCodes, ProcessStatusEnum prepare);

    List<ActivityDetailPlanItemDto> findListByDetailCodesForRedPayLedger(List<String> businessNoList);

    /**
     * 细案明细找到方案明细
     * @param activityDetailCodes
     * @return
     */
    List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> activityDetailCodes);

    /**
     * 查询对应的分组数据，ect系统用
     * @param dto
     * @param pageable
     * @return
     */
    Page<DiscountAccountFeeGroupVo> findPageStatisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto, Pageable pageable);


    /**
     * 更据活动细案编码分页查询活动细案明细
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(Pageable pageable, ActivityDetailPlanItemDto dto);

    List<ActivityDetailPlanBudgetVo> findRegionIsRelateHead(List<String> planCodes);

    /**
     * 查询细案调整明细
     * @param modifyBusinessCodes
     * @return
     */
    List<ActivityDetailPlanItemModifyDto> findModifyItemByModifyBusinessCodes(List<String> modifyBusinessCodes);

    List<ActivityDetailPlanItemVo> findListByDetailPlanCode(String detailPlanCode);

    List<ActivityDetailPlanItemModifyDto> findDtoListByModifyCode(String modifyBusinessCode);

    /**
     * 更新商超自动自动匹配使用费用
     * @param item
     */
    void useProductNumber(ActivityDetailPlanItemVo item);

    /**
     * 更新活动细案明明细上的采购单号
     * @param code
     * @param thisNewActivityDetailCodes
     * @param thisDelActivityDetailCodes
     */
    void updateActivityDetailPurchasingOrder(String code, List<String> thisNewActivityDetailCodes, List<String> thisDelActivityDetailCodes);

    /**
     * 修改活动细案明细上的采购单审批状态
     * @param activityDetailItemCodes
     * @param processStatus
     */
    void updateActivityDetailPurchasingOrderProcessStatus(List<String> activityDetailItemCodes, String processStatus);
}

