package com.biz.crm.tpm.business.activity.detail.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanOutDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 活动细案(ActivityDetailPlan)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
public interface ActivityDetailPlanSdkService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanVo> findByConditions(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto);

    Page<ActivityDetailPlanItemVo> queryActivityDetailPlan(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);


    /**
     * 通过细案编码查询细案
     * @param detailPlanCodes 细案编码集合
     * @return
     */
    List<ActivityDetailPlanVo> findByCodes(Collection<String> detailPlanCodes);

    /**
     * 根据编码查询活动细案
     * @param codes 编码
     * @return List
     */
    List<ActivityDetailPlanVo> findActivityDetailPlanByCodes(List<String> codes);
    /**
     * 通过细案名称模糊查细案编码
     * @param planName 细案名称
     * @return 细案编码
     */
    String findPlanCodeByPlanName(String planName);

    /**
     * 流程审批通过构建数据
     * @param detailPlanCodeList 活动细案编码集合
     * @return 细案数据集合
     */
    List<ActivityDetailPlanDto> buildActivityDetailPlanParams(List<String> detailPlanCodeList);

    /**
     * 红包查询活动细案
     * @param dto2
     * @return
     */
    List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2);


    /**
     * 根据方案编码查询
     *
     * @param codeSet
     * @return
     */
    List<ActivityDetailPlanVo> findByPlanCodes(Set<String> codeSet);
    List<ActivityDetailPlanVo> getCanAutoAuditDto(Page<ActivityDetailPlanVo> page, String autoDate);

    /**
     * 查询可核销数据
     * @param page 分页
     * @param autoAuditParams 查询参数
     * @return List
     */
    List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, AutoAuditParamsDto autoAuditParams);

    /**
     * 查询可核销数据
     * @param autoAuditParams
     * @return
     */
    List<ActivityDetailPlanItemVo> findCanAutoAuditItem(AutoAuditParamsDto autoAuditParams);

    int getActivityDetailNum(String autoDate, String businessUnitCode);

    /**
     * 查询主体数量
     * @param autoAuditParams 查询参数
     * @return int
     */
    int getActivityTotalNumber(AutoAuditParamsDto autoAuditParams);

    /**
     * 修改auto_audit
     * @param detailPlanCode
     */
    void updateAutoAudit(String detailPlanCode);

    /**
     * 修改
     * @param codes
     */
    void updateAutoAuditFlag(List<String> codes, String autoAudit);

    /**
     * 根据方案明细编码查明细预算
     * @param itemCodeSet
     * @return
     */
    List<ActivityDetailPlanBudgetVo> findByPlanItemCode(Set<String> itemCodeSet);

    ActivityDetailPlanVo findByPlanCode(String planCode);

    ActivityDetailPlanVo findById(String id);

    ActivityDetailPlanOutDto createOrUpdateForOut(ActivityDetailPlanOutDto dto);

    void delete(List<String> ids);

    ActivityDetailPlanOutDto atomicCreateForOut(ActivityDetailPlanOutDto dto);

    Page<ActivityDetailPlanVo> findPageForOut(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto);

    /**
     * 根据低头查询
     * @param detailPlanDto
     * @return
     */
    Page<String> findByDtoForPrediction(Pageable pageable, ActivityDetailPlanDto detailPlanDto);

    /**
     * 分页查询所有数据
     *
     * @param pageable                  分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanItemVo> findPlanItemByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto);

}

