package com.biz.crm.tpm.business.activity.detail.plan.sdk.service;

import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerExecutionDto;

import java.util.List;

/**
 * @Description: 活动细案—促销活动 推送 第三方服务
 * @Author qiancheng
 * @Date 2023/1/16
 */
public interface PushActivityToThirdSystemService {

    /**
     * ======================== 牛人管家 ======================================
     */

    /**
     * 促销活动创建、变更 ——牛人管家
     * @param planCodes 活动细案编码集合
     */
    void activityCreateOrUpdatePushCowManager(List<String> planCodes);

    /**
     * 促销活动关闭 ——牛人管家
     * @param itemCodes 明细编码集合
     */
    void activityClosePushCowManager(List<String> itemCodes);

    /**
     * 活动执行查询——牛人管家
     */
    List<CowManagerExecutionDto> queryActivityExecution(String type ,String activeNumber);

    /**
     * ========================== SAP ========================================
     */

    /**
     * SAP-分公司—促销活动创建-按细案编码
     *
     * @param planCodes 分子公司活动细案编码集合
     * @return
     */
    void createActivityPushSapByPlanCodes(List<String> planCodes);

    /**
     * SAP-分公司—促销活动创建-按明细编码
     *
     * @param itemCodes 分子公司活动细案编码集合
     * @return
     */
    void createActivityPushSapByItemCodes(List<String> itemCodes);


    /**
     * 促销活动变更——SAP——分公司 -按细案编码
     *
     * @param planCodes 明细编码集合
     * @param isClose 活动是否关闭 true：关闭
     * @return
     */
    void updateActivityPushSapByPlanCodes(List<String> planCodes, boolean isClose);


    /**
     * 促销活动变更——SAP——分公司 -按明细编码
     *
     * @param itemCodes 明细编码集合
     * @param isClose 活动是否关闭 true：关闭
     * @return
     */
    void updateActivityPushSapByItemCodes(List<String> itemCodes, boolean isClose);

}
