package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 11:25
 * @description：活动细案明细
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityDetailPlanItemVo", description = "活动细案明细")
public class ActivityDetailPlanItemVo extends ActivityDetailPlanItemBase {

    /**
     * 活动便签号
     */
    @ApiModelProperty("活动便签号")
    private String activityNumber;

    /**
     * 方案对应明细
     */
    @ApiModelProperty("方案对应明细")
    private List<ActivityDetailPlanBudgetVo> budgetShares;

    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    private BigDecimal downAmount;
    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    private String isAllDown;
    /**
     * 是否完全结案
     */
    @ApiModelProperty("是否完全结案")
    private String wholeAudit;

    @ApiModelProperty("完全结案日期")
    private String wholeAuditDate;
    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;
    /**
     * 是否完全上账
     */
    @ApiModelProperty("是否完全上账")
    private String wholeUpAccount;
    /**
     * 已上账金额
     */
    @ApiModelProperty("已上账金额")
    private BigDecimal alreadyUpAccountAmount;
    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    private BigDecimal intraCompanyAmount;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    private String intraCompanyAmountStr;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    private BigDecimal offPointAmount;

    @ApiModelProperty("分子公司点外金额")
    private String offPointAmountStr;;
    /**
     * 业态编码
     */
    @ApiModelProperty("业态编码")
    private String businessFormatCode;
    /**
     * 业务单元编码
     */
    @ApiModelProperty("业务单元编码")
    private String businessUnitCode;

    @ApiModelProperty("推送牛人管家标记")
    private String cowManagerState;

    @ApiModelProperty("推送Sap状态标记")
    private String sapInterfaceState;


    /**
     * 结案周期
     */
    @ApiModelProperty("结案周期")
    private String auditCycle;
    /**
     * 月销售任务
     */
    @ApiModelProperty("月销售任务")
    private BigDecimal monthSalesTarget;
    /**
     * 目前铺市率
     */
    @ApiModelProperty("目前铺市率")
    private BigDecimal currentMarketRate;
    /**
     * 月目标铺市率
     */
    @ApiModelProperty("月目标铺市率")
    private BigDecimal monthTargetMarketRate;
    /**
     * 月销售任务-字符串，前端用
     */
    @ApiModelProperty("月销售任务-字符串，前端用")
    private String monthSalesTargetStr;
    /**
     * 目前铺市率-字符串，前端用
     */
    @ApiModelProperty("目前铺市率-字符串，前端用")
    private String currentMarketRateStr;
    /**
     * 月目标铺市率-字符串，前端用
     */
    @ApiModelProperty("月目标铺市率-字符串，前端用")
    private String monthTargetMarketRateStr;
    /**
     * 是否发起巡查需求
     */
    @ApiModelProperty("是否发起巡查需求")
    private String isStartPatrol;
    /**
     * 期间促销量（件）
     */
    @ApiModelProperty("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;
    /**
     * 期间促销额（元）
     */
    @ApiModelProperty("期间促销额（元）")
    private BigDecimal periodPromoteAmount;
    /**
     * 期间渠道促销量（件）
     */
    @ApiModelProperty("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;
    /**
     * 期间渠道促销额（元）
     */
    @ApiModelProperty("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;
    /**
     * 全月回复量（件）
     */
    @ApiModelProperty("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    /**
     * 全月回复额（元）
     */
    @ApiModelProperty("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    /**
     * 本月投入产出比
     */
    @ApiModelProperty("本月投入产出比")
    private BigDecimal monthPutOutputRatio;
    /**
     * 期间促销量（件）-字符串，前端用
     */
    @ApiModelProperty("期间促销量（件）-字符串，前端用")
    private String periodPromoteQuantityStr;
    /**
     * 期间促销额（元）-字符串，前端用
     */
    @ApiModelProperty("期间促销额（元）-字符串，前端用")
    private String periodPromoteAmountStr;
    /**
     * 期间渠道促销量（件）-字符串，前端用
     */
    @ApiModelProperty("期间渠道促销量（件）-字符串，前端用")
    private String periodChPromoteQuantityStr;
    /**
     * 期间渠道促销额（元）-字符串，前端用
     */
    @ApiModelProperty("期间渠道促销额（元）-字符串，前端用")
    private String periodChPromoteAmountStr;
    /**
     * 全月回复量（件）-字符串，前端用
     */
    @ApiModelProperty("全月回复量（件）-字符串，前端用")
    private String monthReturnQuantityStr;
    /**
     * 全月回复额（元）-字符串，前端用
     */
    @ApiModelProperty("全月回复额（元）-字符串，前端用")
    private String monthReturnAmountStr;
    /**
     * 本月投入产出比）-字符串，前端用
     */
    @ApiModelProperty("本月投入产出比）-字符串，前端用")
    private String monthPutOutputRatioStr;
    /**
     * 活动细案审批状态
     */
    @ApiModelProperty("活动细案审批状态")
    private String processStatus;

    @ApiModelProperty("系统承担比例")
    private BigDecimal systemAssumeRatio;
    private String systemAssumeRatioStr;

    @ApiModelProperty("我方承担比例")
    private BigDecimal ourAssumeRatio;
    private String ourAssumeRatioStr;

    @ApiModelProperty("门店月计划量")
    private BigDecimal terminalMonthPlanQuantity;
    private String terminalMonthPlanQuantityStr;

    @ApiModelProperty("门店共用量")
    private BigDecimal terminalTotalQuantity;
    private String terminalTotalQuantityStr;

    @ApiModelProperty("门店共用金额")
    private BigDecimal terminalTotalAmount;
    private String terminalTotalAmountStr;

    @ApiModelProperty("陈列数量")
    private BigDecimal displayQuantity;
    private String displayQuantityStr;

    @ApiModelProperty("陈列单价")
    private BigDecimal displayPrice;
    private String displayPriceStr;
    /**
     * 身份证号码
     */
    @ApiModelProperty("身份证号码")
    private String personIdCard;
    /**
     * 人员类型
     */
    @ApiModelProperty("人员类型")
    private String personType;
    /**
     * 人员名称
     */
    @ApiModelProperty("人员名称")
    private String personName;
    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    private String personCode;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    private String promotionType;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;
    @ApiModelProperty("分销渠道名称")
    private String distributionChannelName;


    /** 预估销售额 */
    @ApiModelProperty(name = "salesAmount",notes = "预估销售额", value= "预估销售额")
    private BigDecimal salesAmount;
    private String salesAmountStr;

    /**
     * 形式说明
     */
    @ApiModelProperty("形式说明")
    private String formDescription;

    /**
     * 是否涨价政策
     */
    @ApiModelProperty("是否涨价政策")
    private String increasePricePromotion;

    /**
     * 是否责任利润调整
     */
    @ApiModelProperty("是否责任利润调整")
    private String dutyProfitAdjust;

    /**
     * 新品归类
     */
    @ApiModelProperty("新品归类")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @ApiModelProperty("是否占用划拨预算")
    private String occupyTransferBudget;

    @ApiModelProperty("是否扣减费用池")
    private String isDeductionFeePool;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    private String auditType;



    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty("采购类型")
    private String isTypeOfPurchaseNo;

    @ApiModelProperty("投产比")
    private String productionRatioStr;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private String applyAmountStr;
    private BigDecimal applyAmount;
    /**
     * 手续费点数
     */
    @ApiModelProperty("手续费点数")
    private String commissionPointStr;
    private BigDecimal commissionPoint;
    /**
     * 手续费金额
     */
    @ApiModelProperty("手续费金额")
    private String commissionAmountStr;
    private BigDecimal commissionAmount;

    /**
     * 档期开始日期（字符）
     */
    @ApiModelProperty("档期开始日期（字符）")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String scheduleBeginDateStr;
    /**
     * 档期开始日期
     */
    @ApiModelProperty("档期开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleBeginDate;
    /**
     * 档期结束日期（字符）
     */
    @ApiModelProperty("档期结束日期（字符）")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String scheduleEndDateStr;
    /**
     * 档期结束日期
     */
    @ApiModelProperty("档期结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleEndDate;

    @ApiModelProperty("员工姓名(人员方案模板用)")
    private String employeeName;

    @ApiModelProperty("全品活动期间销售目标（元）")
    private BigDecimal activitySaleTargetAmount;
    private String activitySaleTargetAmountStr;

    @ApiModelProperty("活动场次")
    private String activityEventCode;

    @ApiModelProperty("场次名称")
    private String activityEventName;

    @ApiModelProperty("合同未税金额")
    private BigDecimal contractExcludingTax;
    private String contractExcludingTaxStr;

    @ApiModelProperty("合同含税金额")
    private BigDecimal contractIncludingTax;
    private String contractIncludingTaxStr;

    @ApiModelProperty(value = "* 随车搭赠组合")
    private String carGiftGroup;

    @ApiModelProperty(value = "面值")
    private BigDecimal faceValue;
    private String faceValueStr;

    @ApiModelProperty(value = "个税金额")
    private BigDecimal personalIncomeTax;
    private String personalIncomeTaxStr;
    /**
     * 预估费率
     */
    @ApiModelProperty("预估费率")
    private BigDecimal feeRate;

    /**
     * 预估核销金额(核销用)
     */
    @ApiModelProperty("预估核销金额")
    private BigDecimal estimatedWriteOffAmount;

    /**
     * 已结案总部承担金额
     */
    @ApiModelProperty("已结案总部承担金额")
    private BigDecimal amountBorneByHeadquarters;
    /**
     * 已结案大区承担金额
     */
    @ApiModelProperty("已结案大区承担金额")
    private BigDecimal amountToBeBorneByTheRegion;
    /**
     * 已结案分子公司点内金额
     */
    @ApiModelProperty("已结案分子公司点内金额")
    private BigDecimal amountOfTheClosedCompany;
    /**
     * 已结案分子公司点外金额
     */
    @ApiModelProperty("已结案分子公司点外金额")
    private BigDecimal amountOutsideThePointClosingParty;

    @ApiModelProperty("是否推送sap（是否上帐）")
    private String isPushSap;

    @ApiModelProperty(name = "本次结案金额", notes = "本次结案金额")
    private BigDecimal thisAuditAmount;

    @ApiModelProperty("结案分子公司点内金额")
    private BigDecimal endCaseIntraCompanyAmount;

    @ApiModelProperty("结案总部承担金额")
    private BigDecimal endCaseHeadFeeAmount;

    @ApiModelProperty("结案大区承担金额")
    private BigDecimal endCaseDepartmentFeeAmount;

    @ApiModelProperty("结案客户承担金额")
    private BigDecimal endCaseCustomerFeeAmount;

    @ApiModelProperty("已结案总部承担金额")
    private BigDecimal alreadyEndCaseHeadFeeAmount;

    @ApiModelProperty("已结案大区承担金额")
    private BigDecimal alreadyEndCaseDepartmentFeeAmount;

    @ApiModelProperty("已结案分子公司点内金额")
    private BigDecimal alreadyEndCaseIntraCompanyAmount;

    @ApiModelProperty("已结案分子公司点外金额")
    private BigDecimal alreadyEndCaseOffPointAmount;

    /*************************核销冗余****************************/
    @ApiModelProperty("活动承接形式")
    private String undertakingMode;


    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    private String departmentCode;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门名称")
    private String departmentName;


    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 总部预算
     */
    private List<ActivityDetailPlanBudgetVo> headFeeBudgetItems;
    /**
     * 大区
     */
    private List<ActivityDetailPlanBudgetVo> departmentFeeBudgetItems;
    /**
     * 分子公司点内
     */
    private List<ActivityDetailPlanBudgetVo> intraCompanyBudgetItems;

    /**
     * 垂直预算
     */
    private List<ActivityDetailPlanBudgetVo> budgetItems;

    private boolean RTMisPartCompany;

    /**
     * 关闭时间（预算回退定时任务执行时使用）
     */
    @ApiModelProperty("关闭时间（预算回退定时任务执行时使用）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date closeDate;
    /**
     * 回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算
     */
    @ApiModelProperty(name = "rollbackBudgetTag", notes = "是否已回退预算", value = "回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算")
    private String rollbackBudgetTag;

    @ApiModelProperty("预算回退金额")
    private BigDecimal rollbackAmount;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty("预提金额")
    private BigDecimal withholdingAmount;

    /**

    /**
     * 预核销金额
     */
    private BigDecimal auditAmount;

    @ApiModelProperty("终端集合")
    List<ActivityDetailPlanItemTerminalVo> terminalList;

    /**
     * pdf 序号
     */
    @ApiModelProperty("序号")
    private String number;

    @ApiModelProperty("采购类型")
    private String procurementType;

    @ApiModelProperty("区域（垂直专用）")
    private String region;


    @ApiModelProperty(name = "费用中心", notes = "费用中心")
    private String expenseCenter;
    @ApiModelProperty("零售商编码")
    private String systemCode;

    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;

    @ApiModelProperty("冗余-扣费匹配单号")
    private String matchCode;
    @ApiModelProperty("冗余-pos销售数据id")
    private String posId;
    
    @ApiModelProperty("结案核销冗余-是否关联方案")
    private boolean relevancePlan;

    @ApiModelProperty("活动状态")
    private String planStatus;


    @ApiModelProperty("核销审批状态")
    private String auditProcessStatus;

    @ApiModelProperty("结案核销冗余-折扣调整关联方案已经退预算")
    private boolean relevancePlanReturnBudget = false;

    @ApiModelProperty("结案核销冗余-折扣调整选择的大区预算编码")
    private String regionMonthBudgetCode;

    /**
     * 区域细分编码
     */
    @ApiModelProperty("区域细分编码")
    private String activityOrgSubdivisionCode;

    private String planCode;
    private String planName;

    @ApiModelProperty("冗余 预算详情表 关联方案编码")
    private String budgetRelatePlanCode;

    @ApiModelProperty("冗余 预算详情表 关联方案明细编码")
    private String budgetRelatePlanItemCode;

    @ApiModelProperty("冗余 方案状态")
    private String schemeStatus;
    @ApiModelProperty("冗余 区域状态")
    private String strategyOrgCode;
    @ApiModelProperty("冗余 细案调整状态")
    private String activityDetailChangeStatus;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("采购单审批状态")
    private String purchaseOrderProcessStatus;

    @ApiModelProperty("关联采购单")
    private String relatePurchaseOrder;

    @ApiModelProperty("费用合计")
    private BigDecimal totalFee;

    @ApiModelProperty("费用申请")
    private BigDecimal applyFee;


    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @ApiModelProperty(name = "收货联系人", notes = "收货联系人")
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @ApiModelProperty(name = "收货联系电话", notes = "收货联系电话")
    private String recipientPhone;
}
