package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;


import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动细案-关联活动方案表(ActivityDetailPlanPlan)
 *
 * @author wanghaojia
 * @since 2022-11-12 17:52:10
 */
@ApiModel(value = "ActivityDetailPlanPlanVo", description = "活动细案-关联活动方案表VO")
@Getter
@Setter
public class ActivityDetailPlanPlanVo extends TenantFlagOpVo {

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案名称")
    private String planName;
    /**
     * 方案类型
     */
    @ApiModelProperty("方案类型")
    private String planType;

    /**
     * 方案开始时间
     */
    @ApiModelProperty("方案开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String beginDateStr;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("方案结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDateStr;
    /**
     * 方案范围编码
     */
    @ApiModelProperty("方案范围编码")
    private String planOrgCode;
    /**
     * 方案范围名称
     */
    @ApiModelProperty("方案范围名称")
    private String planOrgName;

    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;

    /**
     * 已申请金额
     */
    @ApiModelProperty("已申请金额")
    private BigDecimal usedAmount;
    /**
     * 本次使用方案金额
     */
    @ApiModelProperty("本次使用方案金额")
    private BigDecimal usePlanAmount;

    /**
     * 剩余可用金额（元）
     */
    @ApiModelProperty("剩余可用金额（元）")
    private BigDecimal usableAmount;

    /**
     * 关联方案编码
     */
    @ApiModelProperty("关联方案编码")
    private String relatePlanCode;
    /**
     * 关联方案名称
     */
    @ApiModelProperty("关联方案名称")
    private String relatePlanName;


}

