package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;


import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动细案(ActivityDetailPlan)
 *
 * @author wanghaojia
 * @since 2022-11-05 10:22:21
 */
@Data
@CrmExcelExport
public class ActivityDetailPlanReportExportsVo extends CrmExcelVo {

    //细案主表
    /**
     * 业态
     */
    @CrmExcelColumn("业态")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    /**
     * 活动细案编码
     */
    @CrmExcelColumn("细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @CrmExcelColumn("细案名称")
    private String detailPlanName;

    @CrmExcelColumn("审批状态")
    private String processStatus;

    /**
     * 部门编码
     */
    @CrmExcelColumn("部门编码")
    private String departmentCode;
    /**
     * 部门名称
     */
    @CrmExcelColumn("部门名称")
    private String departmentName;

    @CrmExcelColumn("是否临时方案")
    private String isTemporary;

    @CrmExcelColumn("是否汇总")
    private String isGather;

    @CrmExcelColumn("细案说明")
    private String detailPlanExplain;

    @CrmExcelColumn(" 关联方案编码")
    private String relatePlanCode;

    @CrmExcelColumn("关联方案名称")
    private String relatePlanName;

    @CrmExcelColumn("关联方案类型")
    private String planClassify;

    @CrmExcelColumn("关联方案明细编码")
    private String relatePlanItemCode;

    /**
     * 活动类型编码
     */
//    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @CrmExcelColumn("活动分类")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
//    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @CrmExcelColumn("活动形式")
    private String activityFormName;
    /**
     * 活动开始时间
     */
    @CrmExcelColumn("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;

    /**
     * 活动结束时间
     */
    @CrmExcelColumn("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 总部统筹预算编码
     */
    @CrmExcelColumn("总部统筹预算编码")
    private String headMonthBudgetCode;

    /**
     * 总部预算项目编码
     */
//    @CrmExcelColumn("总部预算项目编码")
    private String headBudgetItemCode;

    /**
     * 总部预算项目名称
     */
    @CrmExcelColumn("总部预算项目名称")
    private String headBudgetItemName;

    /**
     * 大区自控预算编码
     */
    @CrmExcelColumn("大区自控预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目编码
     */
//    @CrmExcelColumn("大区预算项目编码")
    private String budgetItemCode;

    /**
     * 大区预算项目名称
     */
    @CrmExcelColumn("大区预算项目名称")
    private String budgetItemName;

    @CrmExcelColumn("大区编码")
    private String salesRegionCode;

    @CrmExcelColumn("大区名称")
    private String salesRegionName;

//    @CrmExcelColumn("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @CrmExcelColumn("省区编码")
    private String salesOrgCode;

    @CrmExcelColumn("省区名称")
    private String salesOrgName;

    /**
     * 一级管理渠道
     */
    @CrmExcelColumn("一级管理渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @CrmExcelColumn("一级管理渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @CrmExcelColumn("二级管理渠道")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @CrmExcelColumn("二级管理渠道名称")
    private String secondChannelName;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 促销对象
     */
    @CrmExcelColumn("促销对象")
    private String promotionObject;

    /**
     * 供应商编码
     */
    @CrmExcelColumn("供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @CrmExcelColumn("供应商名称")
    private String supplierName;

    @CrmExcelColumn(value = "面值")
    private BigDecimal faceValue;

    @CrmExcelColumn(value = "个税金额(元）")
    private BigDecimal personalIncomeTax;

    /**
     * 总部承担金额
     */
    @CrmExcelColumn("总部承担金额（元）")
    private BigDecimal headFeeAmount;

    /**
     * 大区承担金额
     */
    @CrmExcelColumn("大区承担金额（元）")
    private BigDecimal departmentFeeAmount;

    /**
     * 分子公司点内预算金额（元）
     */
//    @CrmExcelColumn("分子公司点内预算金额（元）")
    private BigDecimal intraCompanyAmount;

    /**
     * 分子公司点内预算金额（元）
     */
    @CrmExcelColumn("分子公司点内预算金额（元）")
    private String intraCompanyAmountStr;

    /**
     * 分子公司点外预算金额（元）
     */
//    @CrmExcelColumn("分子公司点外预算金额（元）")
    private BigDecimal offPointAmount;

    @CrmExcelColumn("分子公司点外预算金额（元）")
    private String offPointAmountStr;

    @CrmExcelColumn("是否扣减费用池")
    private String isDeductionFeePool;

    /**
     * 订单开始时间
     */
    @CrmExcelColumn("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @CrmExcelColumn("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderEndDate;

    @CrmExcelColumn(value = "随车搭赠组合")
    private String carGiftGroup;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
//    @CrmExcelColumn("所属销售机构编码")
    private String salesInstitutionErpCode;

    @CrmExcelColumn("分销渠道编码")
    private String distributionChannelCode;
//    @CrmExcelColumn("分销渠道名称")
    private String distributionChannelName;

    @CrmExcelColumn(value = "客户组编码")
    private String customerGroupCode;

    @CrmExcelColumn(value = "客户组名称")
    private String customerGroupName;

    /**
     * 促销类型
     */
    @CrmExcelColumn("促销类型")
    private String promotionType;

    /**
     * 品牌编码
     */
//    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;
    /**
     * 品类编码
     */
//    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类")
    private String productCategoryName;
    /**
     * 品项编码
     */
//    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项")
    private String productItemName;

    /**
     * 单位编码
     */
    @CrmExcelColumn("单位")
    private String productUnit;

    /**
     * 产品价格
     */
    @CrmExcelColumn("产品价格")
    private BigDecimal productPrice;
    /**
     * 原品价格-字符串，前端用
     */
//    @CrmExcelColumn("原品价格-字符串，前端用")
    private String productPriceStr;

    /**
     * 赠品单位
     */
    @CrmExcelColumn("赠品单位")
    private String giftUnit;

    /**
     * 本品数量
     */
    @CrmExcelColumn("本品数量")
    private Integer productQuantity;

    /**
     * 本品数量
     */
//    @CrmExcelColumn("本品数量")
    private String productQuantityStr;

    /**
     * 赠品数量
     */
    @CrmExcelColumn("赠品数量")
    private Integer giftQuantity;
    /**
     * 赠品数量
     */
//    @CrmExcelColumn("赠品数量")
    private String giftQuantityStr;

    /**
     * 费用合计
     */
//    @CrmExcelColumn("费用合计（元）")
    private BigDecimal totalFeeAmount;
    @CrmExcelColumn("费用合计（元）")
    private String totalFeeAmountStr;

    /**
     * 客户承担金额
     */
//    @CrmExcelColumn("客户承担金额")
    private BigDecimal customerFeeAmount;

    /**
     * 客户承担金额（元）
     */
    @CrmExcelColumn("客户承担金额（元）")
    private String customerFeeAmountStr;

    /** 预估销售额 */
//    @CrmExcelColumn("预估销售额")
    private BigDecimal salesAmount;

    @CrmExcelColumn("预估销售额")
    private String salesAmountStr;

    /**
     * 系统
     */
//    @CrmExcelColumn("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @CrmExcelColumn("零售商名称")
    private String systemName;

    /**
     * 月销售任务
     */
//    @CrmExcelColumn("月销售任务")
    private BigDecimal monthSalesTarget;
    @CrmExcelColumn("月销售任务")
    private String monthSalesTargetStr;

    /**
     * 目前铺市率
     */
    @CrmExcelColumn("目前铺市率")
    private BigDecimal currentMarketRate;
    /**
     * 目前铺市率-字符串，前端用
     */
//    @CrmExcelColumn("目前铺市率")
    private String currentMarketRateStr;

    /**
     * 月目标铺市率
     */
    @CrmExcelColumn("月目标铺市率")
    private BigDecimal monthTargetMarketRate;
//    @CrmExcelColumn("月目标铺市率")
    private String monthTargetMarketRateStr;

    /**
     * 是否发起巡查需求
     */
    @CrmExcelColumn("是否发起巡查需求")
    private String isStartPatrol;

    /**
     * 期间促销量（件）
     */
    @CrmExcelColumn("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;
//    @CrmExcelColumn("期间促销量（件）")
    private String periodPromoteQuantityStr;

    /**
     * 期间促销额（元）
     */
    @CrmExcelColumn("期间促销额（元）")
    private BigDecimal periodPromoteAmount;
//    @CrmExcelColumn("期间促销额（元）")
    private String periodPromoteAmountStr;

    /**
     * 期间渠道促销量（件）
     */
    @CrmExcelColumn("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;
//    @CrmExcelColumn("期间渠道促销量（件）")
    private String periodChPromoteQuantityStr;

    /**
     * 期间渠道促销额（元）
     */
    @CrmExcelColumn("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;
//    @CrmExcelColumn("期间渠道促销额（元）")
    private String periodChPromoteAmountStr;

    /**
     * 全月回复量（件）
     */
//    @CrmExcelColumn("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    @CrmExcelColumn("全月回复量（件）")
    private String monthReturnQuantityStr;

    /**
     * 全月回复额（元）
     */
//    @CrmExcelColumn("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    @CrmExcelColumn("全月回复额（元）")
    private String monthReturnAmountStr;

    /**
     * 本月投入产出比
     */
//    @CrmExcelColumn("本月投入产出比")
    private BigDecimal monthPutOutputRatio;
    @CrmExcelColumn("本月投入产出比")
    private String monthPutOutputRatioStr;

    /**
     * 物料数量
     */
//    @CrmExcelColumn("物料数量")
    private BigDecimal materialQuantity;
    @CrmExcelColumn("物料数量")
    private String materialQuantityStr;

    /**
     * 物料单价
     */
//    @CrmExcelColumn("物料单价")
    private BigDecimal materialPrice;
    @CrmExcelColumn("物料单价")
    private String materialPriceStr;


    /**
     * 采购类型
     */
    @CrmExcelColumn("采购类型")
    private String procurementType;

    /**
     * 付款方式
     */
    @CrmExcelColumn("付款方式")
    private String paymentMethod;

    /**
     * 是否和价格有关
     */
    @CrmExcelColumn("是否和价格有关")
    private String relateToPrice;

    /**
     * 形式说明
     */
    @CrmExcelColumn("形式说明")
    private String formDescription;

    /**
     * 是否涨价政策
     */
    @CrmExcelColumn("是否涨价政策")
    private String increasePricePromotion;

    /**
     * 是否考核扣款
     */
    @CrmExcelColumn("是否考核扣款")
    private String deductType;

    /**
     * 是否责任利润调整
     */
    @CrmExcelColumn("是否责任利润调整")
    private String dutyProfitAdjust;

    /**
     * 新品归类
     */
    @CrmExcelColumn("新品归类")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @CrmExcelColumn("是否占用划拨预算")
    private String occupyTransferBudget;

    @CrmExcelColumn("活动承接形式")
    private String undertakingMode;

    /**
     * 活动力度
     */
    @CrmExcelColumn("活动力度")
    private String activityIntensity;

    /**
     * 门店类型
     */
    @CrmExcelColumn("门店类型")
    private String terminalType;

    /**
     * 数量
     */
    @CrmExcelColumn("堆头陈列数量（个/月）")
    private Integer quantity;
    /**
     * 堆头陈列数量（个/月）
     */
//    @CrmExcelColumn("堆头陈列数量（个/月）")
    private String quantityStr;

    /**
     * 堆头陈列单价（元）
     */
    @CrmExcelColumn("堆头陈列单价（元）")
    private BigDecimal price;
//    @CrmExcelColumn("堆头陈列单价（元）")
    private String priceStr;

    /**
     * 门店预计月销售额
     */
//    @CrmExcelColumn("门店预计月销售额")
    private BigDecimal terminalMonthSalesAmount;
    @CrmExcelColumn("门店预计月销售额")
    private String terminalMonthSalesAmountStr;

    /**
     * 人员编码
     */
    @CrmExcelColumn("人员编码")
    private String personCode;

    /**
     * 人员名称
     */
    @CrmExcelColumn("人员名称")
    private String personName;

    /**
     * 人员类型
     */
    @CrmExcelColumn("人员类型")
    private String personType;

    @CrmExcelColumn("创建人")
    private String createName;
    @CrmExcelColumn("创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @CrmExcelColumn("更新人")
    private String modifyName;
    @CrmExcelColumn("更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;




//
//
//    @CrmExcelColumn("创建人账号")
//    private String createAccount;
//    @CrmExcelColumn(value = "更新人账号")
//    private String modifyAccount;
//
//    @CrmExcelColumn("备注")
//    private String remark;
//
//    /**
//     * 活动细案审批状态
//     */
//    @CrmExcelColumn("活动细案审批状态")
//    private String processStatus;
//
//    @CrmExcelColumn("活动号")
//    private String  activityNumber;
//    /**
//     * 本品生产日期
//     */
//    @CrmExcelColumn("本品生产日期")
//    @JSONField(format = "yyyy-MM-dd")
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private Date thisProductProductionDate;
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private String thisProductProductionDateStr;
//    /**
//     * 赠品生产日期
//     */
//    @CrmExcelColumn("赠品生产日期")
//    @JSONField(format = "yyyy-MM-dd")
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private Date giftProductionDate;
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private String giftProductionDateStr;
//    /**
//     * 电话
//     */
//    @CrmExcelColumn("电话")
//    private String telephone;
//
//    @CrmExcelColumn("身份证号")
//    private String identityCard;
//    /**
//     * 员工ID
//     */
//    @CrmExcelColumn("员工ID")
//    private String employeeId;
//    /**
//     * 导购员姓名
//     */
//    @CrmExcelColumn("导购员姓名")
//    private String nameOfShoppingGuide;
//    /**
//     * 责任督导
//     */
//    @CrmExcelColumn("责任督导")
//    private String responsibleSupervision;
//    /**
//     * 责任业务
//     */
//    @CrmExcelColumn("责任业务")
//    private String responsibleBusiness;
//    /**
//     * 城市级别
//     */
//    @CrmExcelColumn("城市级别")
//    private String cityLevel;
//    /**
//     * 城市名称
//     */
//    @CrmExcelColumn("城市名称")
//    private String cityName;
//
//    /**
//     * 档期时间
//     */
//    @CrmExcelColumn("档期时间")
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH::mm:ss")
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH::mm:ss")
//    private Date scheduleTime;
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH::mm:ss")
//    private String scheduleTimeStr;
//    /**
//     * 是否档期
//     */
//    @CrmExcelColumn("是否档期")
//    private String onScheduleOrNot;
//    /**
//     * 投产比
//     */
//    @CrmExcelColumn("投产比")
//    private BigDecimal productionRatio;
//    /**
//     * 月度计划量
//     */
//    @CrmExcelColumn("月度计划量")
//    private BigDecimal monthlyPlannedQuantity;
//    private String monthlyPlannedQuantityStr;
//    /**
//     * AC门店类型
//     */
//    @CrmExcelColumn("AC门店类型")
//    private String acStoreType;
//    /**
//     * AC分仓
//     */
//    @CrmExcelColumn("AC分仓")
//    private String acWarehouse;
//    /**
//     * AC分仓编码
//     */
//    @CrmExcelColumn("AC分仓编码")
//    private String acWarehouseCode;
//    /**
//     * 核销方式
//     */
//    @CrmExcelColumn("核销方式")
//    private String writeOffMethod;
//    /**
//     * 原供价（本品）
//     */
//    @CrmExcelColumn("原供价（本品）")
//    private BigDecimal originalSupplyPrice;
//    private String originalSupplyPriceStr;
//    /**
//     * 税率
//     */
//    @CrmExcelColumn("税率")
//    private BigDecimal taxRate;
//    private String taxRateStr;
//    /**
//     * 原未税价格（本品）
//     */
//    @CrmExcelColumn("原未税价格（本品）")
//    private BigDecimal originalPriceProduct;
//    private String originalPriceProductStr;
//    /**
//     * 原供价（赠品）
//     */
//    @CrmExcelColumn( "原供价（赠品）")
//    private BigDecimal originalPriceGift;
//    private String originalPriceGiftStr;
//    /**
//     * 原未税价格（赠品）
//     */
//    @CrmExcelColumn("原未税价格（赠品）")
//    private BigDecimal originalTaxPriceGift;
//    private String originalTaxPriceGiftStr;
//    /**
//     * 促销含税供价
//     */
//    @CrmExcelColumn("促销含税供价")
//    private BigDecimal promotionPriceTax;
//    private String promotionPriceTaxStr;
//    /**
//     * 促销未税供价
//     */
//    @CrmExcelColumn("促销未税供价")
//    private BigDecimal promotionNonTaxPrice;
//    private String promotionNonTaxPriceStr;
//    /**
//     * 零售价
//     */
//    @CrmExcelColumn("零售价")
//    private BigDecimal retailPrice;
//    private String retailPriceStr;
//    /**
//     * 促销售价
//     */
//    @CrmExcelColumn("促销售价")
//    private BigDecimal promotionalPrice;
//    private String promotionalPriceStr;
//    /**
//     * 原毛利率
//     */
//    @CrmExcelColumn("原毛利率")
//    private BigDecimal originalGrossRate;
//    private String originalGrossRateStr;
//    /**
//     * 促销毛利率
//     */
//    @CrmExcelColumn("促销毛利率")
//    private BigDecimal promotionalGrossRate;
//    private String promotionalGrossRateStr;
//    /**
//     * 单件申请费用
//     */
//    @CrmExcelColumn("单件申请费用")
//    private BigDecimal singleApplicationFee;
//    private String singleApplicationFeeStr;
//    /**
//     * 期间促销件数
//     */
//    @CrmExcelColumn("期间促销件数")
//    private Integer periodPromotionalNumber;
//    private String periodPromotionalNumberStr;
//    /**
//     * 期间促销金额
//     */
//    @CrmExcelColumn("期间促销金额")
//    private BigDecimal periodPromotionalAmount;
//    private String periodPromotionalAmountStr;
//    /**
//     * 系统承担金额
//     */
//    @CrmExcelColumn("系统承担金额")
//    private BigDecimal systemBorneAmount;
//    private String systemBorneAmountStr;
//    /**
//     * 我方承担金额
//     */
//    @CrmExcelColumn("我方承担金额")
//    private BigDecimal ourCommitmentAmount;
//    private String ourCommitmentAmountStr;
//    /**
//     * 单品计划量
//     */
//    @CrmExcelColumn("单品计划量")
//    private Integer plannedQuantitySingle;
//    private String plannedQuantitySingleStr;
//    /**
//     * 单品投产比
//     */
//    @CrmExcelColumn("单品投产比")
//    private BigDecimal singleProductionRatio;
//    private String singleProductionRatioStr;
//    /**
//     * 系统门店计划量
//     */
//    @CrmExcelColumn("系统门店计划量")
//    private Integer systemStoresQuantity;
//    private String systemStoresQuantityStr;
//    /**
//     * 单店投产比
//     */
//    @CrmExcelColumn("单店投产比")
//    private BigDecimal storesProductionRatio;
//    private String storesProductionRatioStr;
//    /**
//     * 系统月计划量
//     */
//    @CrmExcelColumn("系统月计划量")
//    private Integer systemMonthlyQuantity;
//    private String systemMonthlyQuantityStr;
//    /**
//     * 是否公用
//     */
//    @CrmExcelColumn("是否公用")
//    private String publicOrNot;
//    /**
//     * 门店公用量
//     */
//    @CrmExcelColumn("门店公用量")
//    private Integer storeUtility;
//    private String storeUtilityStr;
//    /**
//     * 门店公用金额
//     */
//    @CrmExcelColumn("门店公用金额")
//    private BigDecimal storePublicAmount;
//    private String storePublicAmountStr;
//    /**
//     * 浮动率
//     */
//    @CrmExcelColumn("浮动率")
//    private BigDecimal floatingRate;
//    private String floatingRateStr;
//    /**
//     * 浮动量
//     */
//    @CrmExcelColumn("浮动量")
//    private BigDecimal floatingNumber;
//    private String floatingNumberStr;
//    /**
//     * 浮动金额
//     */
//    @CrmExcelColumn("浮动金额")
//    private BigDecimal floatingAmount;
//    private String floatingAmountStr;
//    /**
//     * 区域
//     */
//    @CrmExcelColumn("区域")
//    private String region;
//    private String regionName;
//    /**
//     * 城市经理
//     */
//    @CrmExcelColumn("城市经理")
//    private String cityManager;
//    /**
//     * 未含税单价
//     */
//    @CrmExcelColumn("未含税单价")
//    private BigDecimal priceExcludingTax;
//    private String priceExcludingTaxStr;
//    /**
//     * 含税单价
//     */
//    @CrmExcelColumn("含税单价")
//    private BigDecimal priceIncludingTax;
//    private String priceIncludingTaxStr;
//    /**
//     * 未含税金额
//     */
//    @CrmExcelColumn("未含税金额")
//    private BigDecimal amountExcludingTax;
//    private String amountExcludingTaxStr;
//    /**
//     * 含税金额
//     */
//    @CrmExcelColumn("含税金额")
//    private BigDecimal amountIncludingTax;
//    private String amountIncludingTaxStr;
//    /**
//     * 扣费细项
//     */
//    @CrmExcelColumn("扣费细项")
//    private String deductionDetails;
//    /**
//     * 扣费类型
//     */
//    @CrmExcelColumn("扣费类型")
//    private String deductionType;
//    /**
//     * 扣费标准
//     */
//    @CrmExcelColumn("扣费标准")
//    private String deductionStandard;
//    /**
//     * GMV
//     */
//    @CrmExcelColumn("GMV")
//    private String gmv;
//    /**
//     * 费率
//     */
//    @CrmExcelColumn("费率")
//    private BigDecimal rate;
//    /**
//     * 平台
//     */
//    @CrmExcelColumn("平台")
//    private String platform;
//
//    /**
//     * 活动细案明细编码
//     */
//    @CrmExcelColumn("活动细案明细编码")
//    private String detailPlanItemCode;
//    /**
//     * 方案模板编码
//     */
//    @CrmExcelColumn("方案模板编码")
//    private String templateConfigCode;
//
//    @CrmExcelColumn("费用所属年月")
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
//    @DateTimeFormat(pattern = "yyyy-MM")
//    private Date feeYearMonth;
//
//    /**
//     * 区域编码
//     */
//    @CrmExcelColumn("区域编码")
//    private String activityOrgCode;
//    /**
//     * 区域名称
//     */
//    @CrmExcelColumn("区域名称")
//    private String activityOrgName;
//
//    /**
//     * 大区公投预算编码
//     */
//    @CrmExcelColumn("大区公投预算编码")
//    private String regionReferendumMonthBudgetCode;
//
//    /**
//     * 大区公投项目编码
//     */
//    @CrmExcelColumn("大区公投预算项目编码")
//    private String regionReferendumBudgetItemCode;
//
//    /**
//     * 大区公投预算项目名称
//     */
//    @CrmExcelColumn("大区公投预算项目名称")
//    private String regionReferendumBudgetItemName;
//
//    /**
//     * 大区公投预算编码
//     */
//    @CrmExcelColumn("大区自投预算编码")
//    private String regionAutomaticMonthBudgetCode;
//
//    /**
//     * 大区公投项目编码
//     */
//    @CrmExcelColumn("大区自投预算项目编码")
//    private String regionAutomaticBudgetItemCode;
//
//    /**
//     * 大区公投预算项目名称
//     */
//    @CrmExcelColumn("大区自投预算项目名称")
//    private String regionAutomaticBudgetItemName;

    /**
     * 门店编码
     */
    @CrmExcelColumn("门店编码")
    private String terminalCode;
    /**
     * 门店名称
     */
    @CrmExcelColumn("门店名称")
    private String terminalName;
//
//    /**
//     * 门店数量
//     */
//    @CrmExcelColumn("门店数量")
//    private Integer terminalQuantity;
//    /**
//     * 门店数量-字符串，前端用
//     */
//    @CrmExcelColumn("门店数量-字符串，前端用")
//    private String terminalQuantityStr;
//
//
//    /**
//     * 产品编码
//     */
//    @CrmExcelColumn("产品编码")
//    private String productCode;
//    /**
//     * 产品名称
//     */
//    @CrmExcelColumn("产品名称")
//    private String productName;
//
//
//    /**
//     * 赠品编码
//     */
//    @CrmExcelColumn("赠品编码")
//    private String giftCode;
//    /**
//     * 赠品名称
//     */
//    @CrmExcelColumn("赠品名称")
//    private String giftName;
//    /**
//     * 赠品价格
//     */
//    @CrmExcelColumn("赠品价格")
//    private BigDecimal giftPrice;
//
//    /**
//     * 促销政策编码
//     */
//    @CrmExcelColumn("促销政策编码")
//    private String promotionCode;
//    /**
//     * 促销政策名称
//     */
//    @CrmExcelColumn("促销政策名称")
//    private String promotionName;
//
//    /**
//     * 陈列类型
//     */
//    @CrmExcelColumn("陈列类型")
//    private String displayType;
//
//    @CrmExcelColumn("陈列批次")
//    private String displayLot;
//
//    @CrmExcelColumn("是否客户上账")
//    private String isCustomerAccount;
//    /**
//     * 费用金额
//     */
//    @CrmExcelColumn("费用金额")
//    private BigDecimal feeAmount;
//    /**
//     * 费用金额-字符串，前端用
//     */
//    @CrmExcelColumn("费用金额-字符串，前端用")
//    private String feeAmountStr;
//
//    /**
//     * 已发生总部费用
//     */
//    @CrmExcelColumn("已发生总部费用")
//    private BigDecimal usedHeadFeeAmount;
//
//    /**
//     * 已发生大区费用
//     */
//    @CrmExcelColumn("已发生大区费用")
//    private BigDecimal usedDepartmentFeeAmount;
//
//    /**
//     * 已发生客户费用
//     */
//    @CrmExcelColumn("已发生客户费用")
//    private BigDecimal usedCustomerFeeAmount;
//
//
//    /**
//     * 大区公投预算金额
//     */
//    @CrmExcelColumn("大区公投预算金额（元）")
//    private BigDecimal regionReferendumFeeAmount;
//    /**
//     *大区公投预算金额（元）-字符串，前端用
//     */
//    @CrmExcelColumn("大区公投预算金额（元）-字符串，前端用")
//    private String regionReferendumFeeAmountStr;
//
//    /**
//     * 大区自投预算金额
//     */
//    @CrmExcelColumn("大区自投预算金额（元）")
//    private BigDecimal regionAutomaticFeeAmount;
//    /**
//     *大区自投预算金额（元）-字符串，前端用
//     */
//    @CrmExcelColumn("大区自投预算金额（元）-字符串，前端用")
//    private String regionAutomaticFeeAmountStr;
//
//    /**
//     * 门店预计月销售额
//     */
//    @CrmExcelColumn("门店预计月销售额")
//    private BigDecimal terminalLastMonthSalesAmount;
//    /**
//     * 上月门店实际月销售额-字符串，前端用
//     */
//    @CrmExcelColumn("上月门店实际月销售额-字符串，前端用")
//    private String terminalLastMonthSalesAmountStr;
//
//    /**
//     * 结案形式
//     */
//    @CrmExcelColumn("结案形式")
//    private String auditForm;
//
//    /**
//     * 竞品情况
//     */
//    @CrmExcelColumn("竞品情况")
//    private String compatibleProductSituation;
//
//    /**
//     * 核销条件编码
//     */
//    @CrmExcelColumn("核销条件编码")
//    private String auditConditionCode;
//    /**
//     * 核销条件名称
//     */
//    @CrmExcelColumn("核销条件名称")
//    private String auditConditionName;
//    /**
//     * 活动描述
//     */
//    @CrmExcelColumn("活动描述")
//    private String activityDesc;
//    /**
//     * 共用组
//     */
//    @CrmExcelColumn("共用组")
//    private String commonGroup;
//    /**
//     * 物料编码
//     */
//    @CrmExcelColumn("物料编码")
//    private String materialCode;
//    /**
//     * 物料名称
//     */
//    @CrmExcelColumn("物料名称")
//    private String materialName;
//    /**
//     * 物料单位
//     */
//    @CrmExcelColumn("物料单位")
//    private String materialUnit;
//
//    /**
//     * 合同编码
//     */
//    @CrmExcelColumn("合同编码")
//    private String contractCode;
//    /**
//     * 账期
//     */
//    @CrmExcelColumn("账期")
//    private String paymentDays;
//    /**
//     * 推广场次
//     */
//    @CrmExcelColumn("推广场次")
//    private Integer promoteNumber;
//    /**
//     * 推广场次-字符串，前端用
//     */
//    @CrmExcelColumn("推广场次-字符串，前端用")
//    private String promoteNumberStr;
//    /**
//     * 单场费用
//     */
//    @CrmExcelColumn("单场费用")
//    private BigDecimal singleFeeAmount;
//    /**
//     * 单场费用-字符串，前端用
//     */
//    @CrmExcelColumn("单场费用-字符串，前端用")
//    private String singleFeeAmountStr;
//    /**
//     * 考核产品编码
//     */
//    @CrmExcelColumn("考核产品编码")
//    private String assessProductCode;
//    /**
//     * 考核产品名称
//     */
//    @CrmExcelColumn("考核产品名称")
//    private String assessProductName;
//    /**
//     * 购买方式
//     */
//    @CrmExcelColumn("购买方式")
//    private String buyWay;
//
//    /**
//     * 是否关闭，   Y是N否
//     */
//    @CrmExcelColumn("是否关闭")
//    private String isClose;
//
//    /**
//     * 已向下规划金额（分子公司活动规划用）
//     */
//    @CrmExcelColumn("已向下规划金额（分子公司活动规划用）")
//    private BigDecimal downAmount;
//    /**
//     * 是否完全向下规划（分子公司活动规划用）
//     */
//    @CrmExcelColumn("是否完全向下规划（分子公司活动规划用）")
//    private String isAllDown;
//    /**
//     * 是否完全结案
//     */
//    @CrmExcelColumn("是否完全结案")
//    private String wholeAudit;
//    /**
//     * 已结案金额
//     */
//    @CrmExcelColumn("已结案金额")
//    private BigDecimal alreadyAuditAmount;
//
//    /**
//     * 是否选中，0否1是
//     */
//    @CrmExcelColumn("是否选中，0否1是")
//    private String checked;
//
//    /**
//     * 是否完全上账
//     */
//    @CrmExcelColumn("是否完全上账")
//    private String wholeUpAccount;
//
//    /**
//     * 已上账金额
//     */
//    @CrmExcelColumn("已上账金额")
//    private BigDecimal alreadyUpAccountAmount;
//
//    @CrmExcelColumn("推送牛人管家标记")
//    private String cowManagerState;
//
//    @CrmExcelColumn("推送Sap状态标记")
//    private String sapInterfaceState;
//
//    /**
//     * 结案周期
//     */
//    @CrmExcelColumn("结案周期")
//    private String auditCycle;
//
//    @CrmExcelColumn("系统承担比例")
//    private BigDecimal systemAssumeRatio;
//    private String systemAssumeRatioStr;
//
//    @CrmExcelColumn("我方承担比例")
//    private BigDecimal ourAssumeRatio;
//    private String ourAssumeRatioStr;
//
//    @CrmExcelColumn("门店月计划量")
//    private BigDecimal terminalMonthPlanQuantity;
//    private String terminalMonthPlanQuantityStr;
//
//    @CrmExcelColumn("门店共用量")
//    private BigDecimal terminalTotalQuantity;
//    private String terminalTotalQuantityStr;
//
//    @CrmExcelColumn("门店共用金额")
//    private BigDecimal terminalTotalAmount;
//    private String terminalTotalAmountStr;
//
//    @CrmExcelColumn("陈列数量")
//    private BigDecimal displayQuantity;
//    private String displayQuantityStr;
//    /**
//     * 身份证号码
//     */
//    @CrmExcelColumn("身份证号码")
//    private String personIdCard;
//
//    @CrmExcelColumn("采购类型")
//    private String isTypeOfPurchaseNo;
//
//    @CrmExcelColumn("投产比")
//    private String productionRatioStr;
//    /**
//     * 申请金额
//     */
//    @CrmExcelColumn("申请金额")
//    private String applyAmountStr;
//    private BigDecimal applyAmount;
//    /**
//     * 核销条件编码
//     */
//    @CrmExcelColumn("手续费点数")
//    private String commissionPointStr;
//    private BigDecimal commissionPoint;
//    /**
//     * 核销条件编码
//     */
//    @CrmExcelColumn("手续费金额")
//    private String commissionAmountStr;
//    private BigDecimal commissionAmount;
//
//    /**
//     * 档期开始日期（字符）
//     */
//    @CrmExcelColumn("档期开始日期（字符）")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private String scheduleBeginDateStr;
//    /**
//     * 档期开始日期
//     */
//    @CrmExcelColumn("档期开始日期")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private Date scheduleBeginDate;
//    /**
//     * 档期结束日期（字符）
//     */
//    @CrmExcelColumn("档期结束日期（字符）")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private String scheduleEndDateStr;
//    /**
//     * 档期结束日期
//     */
//    @CrmExcelColumn("档期结束日期")
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    private Date scheduleEndDate;
//
//    /**
//     * 核销类型
//     */
//    @CrmExcelColumn("核销类型")
//    private String auditType;
//
//    /**
//     * 所属销售机构
//     */
//    @CrmExcelColumn("所属销售机构")
//    private String salesInstitutionName;
//
//    @CrmExcelColumn("所属销售大区编码")
//    private String salesRegionErpCode;
//
//
//
//    @CrmExcelColumn("全品活动期间销售目标（元）")
//    private BigDecimal activitySaleTargetAmount;
//    private String activitySaleTargetAmountStr;
//
//    @CrmExcelColumn("活动场次")
//    private String activityEventCode;
//
//    @CrmExcelColumn("场次名称")
//    private String activityEventName;
//
//    @CrmExcelColumn("合同未税金额")
//    private BigDecimal contractExcludingTax;
//    private String contractExcludingTaxStr;
//
//    @CrmExcelColumn("合同含税金额")
//    private BigDecimal contractIncludingTax;
//    private String contractIncludingTaxStr;
//
//    /**
//     * 预估费率
//     */
//    @CrmExcelColumn("预估费率")
//    private BigDecimal feeRate;
//
//    /**
//     * 预付类型
//     */
//    @CrmExcelColumn("预付类型")
//    private String prepaymentType;
//
//    @CrmExcelColumn("已结案总部承担金额")
//    private BigDecimal alreadyEndCaseHeadFeeAmount;
//
//    @CrmExcelColumn("已结案大区承担金额")
//    private BigDecimal alreadyEndCaseDepartmentFeeAmount;
//
//    @CrmExcelColumn("已结案分子公司点内金额")
//    private BigDecimal alreadyEndCaseIntraCompanyAmount;
//
//    @CrmExcelColumn("已结案分子公司点外金额")
//    private BigDecimal alreadyEndCaseOffPointAmount;
//
//    /**
//     * 关闭时间（预算回退定时任务执行时使用）
//     */
//    @CrmExcelColumn("关闭时间（预算回退定时任务执行时使用）")
//    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    private Date closeDate;
//    /**
//     * 回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算
//     */
//    @CrmExcelColumn("是否已回退预算")
//    private String rollbackBudgetTag;
//
//    @CrmExcelColumn("预算回退金额")
//    private BigDecimal rollbackAmount;

}

