package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;


import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

/**
 * 活动细案(ActivityDetailPlan)
 *
 * @author wanghaojia
 * @since 2022-11-05 10:22:21
 */
@ApiModel(value = "ActivityDetailPlanDto", description = "活动细案Dto")
@Getter
@Setter
public class ActivityDetailPlanReportVo extends ActivityDetailPlanItemBase {

    //基础

    /**
     * 租户编号
     */
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;

    /**
     * 创建人账号
     */
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 创建人名称
     */
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;

    /**
     * 更新人账号
     */
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;

    /**
     * 最后更新时间
     */
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;

    /**
     * 修改人名称
     */
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;

    //细案主表
    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    private String processStatus;
    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案名称")
    private String detailPlanName;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    private String departmentCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String departmentName;

    @ApiModelProperty("是否临时活动")
    private String isTemporary;

    @ApiModelProperty("是否汇总")
    private String isGather;

    @ApiModelProperty("是否汇总")
    private String detailPlanExplain;

    @ApiModelProperty(" 关联方案编码")
    private String relatePlanCode;

    @ApiModelProperty("关联方案名称")
    private String relatePlanName;

    @ApiModelProperty("关联方案类型")
    private String planClassify;

    @ApiModelProperty("关联方案明细编码")
    private String relatePlanItemCode;

}

