package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;


import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 活动细案(ActivityDetailPlan)
 *
 * @author wanghaojia
 * @since 2022-11-05 10:22:21
 */
@ApiModel(value = "ActivityDetailPlanVo", description = "活动细案VO")
@Getter
@Setter
public class ActivityDetailPlanVo extends ActivityDetailPlanBase {

    /**
     * 关联活动方案
     */
    @ApiModelProperty("关联活动方案")
    private List<ActivityDetailPlanPlanVo> relatePlanList;

    private List<ActivityDetailPlanItemVo> activityDetailPlanItemList;

    @ApiModelProperty("来源")
    private String whereFrom;

    @ApiModelProperty("自动核销")
    private String autoAudit;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal feeAmount;

    @ApiModelProperty("是否汇总")
    private String isGather;

    @ApiModelProperty("汇总维度")
    private String summaryDimension;

    /**
     * 是否已校验
     */
    @ApiModelProperty(name = "是否已校验", notes = "")
    private String isValidate;
    /**
     * 方案明细编码
     */
    @ApiModelProperty(name = "方案明细编码")
    private String relatePlanItemCode;

    @ApiModelProperty(name = "区域编码(字典MDM_CUSTOMIZE_ORG)", notes = "")
    private String regionCode;

    @ApiModelProperty(name = "是否生成分子预算", notes = "")
    private String isBudgetForecast;
}

