package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 17:49
 * @description：核销数据
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInfoDto", description = "核销数据")
public class AuditInfoDto extends TenantFlagOpVo {
    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    private String activityDetailItemCode;

    @ApiModelProperty(name = "本次结案金额", notes = "本次结案金额")
    private BigDecimal thisAuditAmount;
}
