package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2023/2/21 14:42
 * @description: 折扣上账金额Vo
 */
@Data
@ApiModel(value = "DiscountAccountFeeVo", description = "折扣上账金额Vo")
public class DiscountAccountFeeVo {

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 系统
     */
    @ApiModelProperty("系统")
    private String systemCode;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 折扣上账金额
     */
    @ApiModelProperty("折扣上账金额")
    private BigDecimal discountUpAccount;
}
