package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: yaoyongming
 * @date: 2023/8/21 16:03
 */
@Data
public class LargeDateCallbackVo extends TenantFlagOpVo {

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("所属销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("大区编码")
    private String salesRegionCode;

    @ApiModelProperty("大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("大区名称")
    private String salesRegionName;

    @ApiModelProperty("省区编码")
    private String salesOrgCode;

    @ApiModelProperty("省区编码")
    private String salesOrgErpCode;

    @ApiModelProperty("省区名称")
    private String salesOrgName;

    @ApiModelProperty("渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("渠道名称")
    private String distributionChannelName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("活动年月")
    private String yearMonthLy;

    /**
     * 本品生产日期
     */
    @ApiModelProperty("本品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date thisProductProductionDate;

    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    private String isBigDate;

    /**
     * 期间销售量
     */
    @ApiModelProperty("期间销售量")
    private BigDecimal periodSale;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    private BigDecimal bigDateQty;

    /**
     * 回调率
     */
    @ApiModelProperty("回调率")
    private String callbackRate;
}
