package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 行销费用批复表导出vo
 *
 * @author yaoyongming
 * @since
 */
@ApiModel(value = "MarketingApprovalExportVo", description = "行销费用批复表导出vo")
@Getter
@Setter
@CrmExcelExport
public class MarketingApprovalExportVo extends CrmExcelVo {

    @ApiModelProperty("业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @CrmExcelColumn("大区批复文件编码")
    private String regionalFileCode;
    @CrmExcelColumn("总部批复文件编码")
    private String headquartersFileCode;
    @CrmExcelColumn("活动细案名称")
    private String detailPlanName;
    @CrmExcelColumn("总部预算编码")
    private String headMonthBudgetCode;
    @CrmExcelColumn("大区预算编码")
    private String monthBudgetCode;
    @CrmExcelColumn("门店编码")
    private String terminalCode;
    @CrmExcelColumn("大区数据类型")
    private String regionDataTypeCode;
    @CrmExcelColumn("大区中心")
    private String regionDepartmentBelongCode;
    @CrmExcelColumn("总部数据类型")
    private String headquartersDataTypeCode;
    @CrmExcelColumn("总部中心")
    private String headquartersDepartmentBelongCode;
    @CrmExcelColumn("客户类型")
    private String customerTypeName;
    @CrmExcelColumn("目前铺市率")
    private BigDecimal currentMarketRate;
    @CrmExcelColumn("月目标铺市率")
    private BigDecimal monthTargetMarketRate;
    @CrmExcelColumn("预算归属业态")
    private String businessCode;
    @CrmExcelColumn("RTM模式")
    private String rtmModelCode;
    @CrmExcelColumn("方案编码")
    private String planCode;
    @CrmExcelColumn("方案名称")
    private String planName;
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;
    @CrmExcelColumn("客户编码")
    private String customerCode;
    @CrmExcelColumn("客户名称")
    private String customerName;
    @CrmExcelColumn("大区")
    private String region;
    @CrmExcelColumn("区域编码")
    private String activityOrgCode;
    @CrmExcelColumn("区域名称")
    private String activityOrgName;
    @ApiModelProperty("所属销售大区编码")
    @CrmExcelColumn("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区名称")
    @CrmExcelColumn("所属销售大区名称")
    private String salesRegionName;
    @CrmExcelColumn("省区编码")
    private String salesOrgCode;
    @CrmExcelColumn("省区名称")
    private String salesOrgName;
    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    @CrmExcelColumn("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    @CrmExcelColumn("零售商名称")
    private String systemName;
    @CrmExcelColumn("总部统筹预算编码")
    private String headBudgetItemCode;
    @CrmExcelColumn("总部统筹预算名称")
    private String headBudgetItemName;
    @CrmExcelColumn("大区自控预算编码")
    private String budgetItemCode;
    @CrmExcelColumn("大区自控预算名称")
    private String budgetItemName;
    @CrmExcelColumn("业态编码")
    private String businessFormatCode;
    @CrmExcelColumn("业态名称")
    private String businessFormatName;
    @CrmExcelColumn("活动开始日期")
    private Date activityBeginDate;
    @CrmExcelColumn("活动结束日期")
    private Date activityEndDate;
    @CrmExcelColumn("是否发起巡查需求")
    private String isStartPatrol;
    @CrmExcelColumn("月销售任务（元）")
    private BigDecimal monthSalesTarget;
    @CrmExcelColumn("核销原则编码")
    private String auditConditionCode;
    @CrmExcelColumn("核销原则")
    private String auditConditionName;
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    @CrmExcelColumn("品牌名称")
    private String productBrandName;
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    @CrmExcelColumn("品类名称")
    private String productCategoryName;
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    @CrmExcelColumn("品项名称")
    private String productItemName;
    @CrmExcelColumn("产品编码")
    private String productCode;
    @CrmExcelColumn("产品名称")
    private String productName;
    @CrmExcelColumn("原品数量")
    private Integer productQuantity;
    @CrmExcelColumn("赠品数量")
    private Integer giftQuantity;
    @CrmExcelColumn("赠品编码")
    private String giftCode;
    @CrmExcelColumn("赠品名称")
    private String giftName;
    @CrmExcelColumn("形式说明")
    private String formDescription;
    @CrmExcelColumn("一级管理渠道编码")
    private String firstChannelCode;
    @CrmExcelColumn("一级管理渠道名称")
    private String firstChannelName;
    @CrmExcelColumn("二级管理渠道")
    private String secondChannelCode;
    @CrmExcelColumn("二级管理渠道名称")
    private String secondChannelName;
    @CrmExcelColumn("订单开始日期")
    private Date orderBeginDate;
    @CrmExcelColumn("订单结束日期")
    private Date orderEndDate;
    @CrmExcelColumn("费用合计")
    private BigDecimal totalFeeAmount;
    @CrmExcelColumn("单价")
    private BigDecimal price;
    @CrmExcelColumn("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;
    @CrmExcelColumn("期间促销额（元）")
    private BigDecimal periodPromoteAmount;
    @CrmExcelColumn("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;
    @CrmExcelColumn("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;
    @CrmExcelColumn("是否20门店")
    private String whetherTwentyTerminal;
    @CrmExcelColumn("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    @CrmExcelColumn("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    @CrmExcelColumn("本月投入产出比")
    private BigDecimal monthPutOutputRatio;
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;
    @CrmExcelColumn("赠品单价")
    private BigDecimal giftPrice;
    @CrmExcelColumn("是否临时活动")
    private String isTemporary;
    @CrmExcelColumn("大区批复文件名称")
    private String regionalFileName;
    @CrmExcelColumn("总部批复文件名称")
    private String headquartersFileName;
    @CrmExcelColumn("是否涨价政策")
    private String increasePricePromotion;
    @CrmExcelColumn("是否责任利润调整")
    private String dutyProfitAdjust;
    @CrmExcelColumn("促销对象")
    private String promotionObject;
    @CrmExcelColumn("新品归类")
    private String newProductType;
    @CrmExcelColumn("是否占用划拨预算")
    private String occupyTransferBudget;
    @CrmExcelColumn("总部承担金额")
    private BigDecimal headFeeAmount;
    @CrmExcelColumn("大区承担金额")
    private BigDecimal departmentFeeAmount;
    @CrmExcelColumn("客户承担金额")
    private BigDecimal customerFeeAmount;
    @CrmExcelColumn("是否考核扣款")
    private String isDeductionFeePool;
    @CrmExcelColumn("活动细案编码")
    private String detailPlanCode;
    @CrmExcelColumn("活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 部门编码
     */
    @CrmExcelColumn("部门编码")
    private String departmentCode;

    /**
     * 部门编码
     */
    @CrmExcelColumn("部门名称")
    private String departmentName;

    /**
     * 分子公司点内金额
     */
    @CrmExcelColumn("分子公司点内金额")
    private BigDecimal intraCompanyAmount;
    /**
     * 分子公司点外金额
     */
    @CrmExcelColumn("分子公司点外金额")
    private BigDecimal offPointAmount;

    @CrmExcelColumn("是否关闭")
    private String isClose;

    @CrmExcelColumn("结案年月")
    private String auditYearMonth;
    @CrmExcelColumn("预核销金额")
    private BigDecimal auditAmount;
    @CrmExcelColumn("已结案金额")
    private BigDecimal thisAuditAmount;
    @CrmExcelColumn("是否完全结案")
    private String wholeAudit;
    @CrmExcelColumn("折扣税率")
    private String discountTaxRate;
    @CrmExcelColumn("折扣应处理金额")
    private BigDecimal discountTaxAmount;
    @CrmExcelColumn("入费用池金额")
    private BigDecimal discountAmount;
    @CrmExcelColumn("报销税率")
    private String reimburseTaxRate;
    @CrmExcelColumn("报销金额(含税)")
    private BigDecimal reimburseTaxAmount;
    @CrmExcelColumn("报销金额(未税)")
    private BigDecimal reimburseAmount;
    @CrmExcelColumn("税额")
    private BigDecimal taxQuota;
    @CrmExcelColumn("报销项目编码")
    private String reimburseItem;
    @CrmExcelColumn("报销项目名称")
    private String reimburseItemName;
    @CrmExcelColumn("个人所得税金额")
    private BigDecimal individualIncomeTax;
    @CrmExcelColumn("是否专票")
    private String isSpecialTicket;
    @CrmExcelColumn("成本中心编码")
    private String costCenter;
    @CrmExcelColumn("成本中心名称")
    private String costCenterName;
    @CrmExcelColumn("利润中心编码")
    private String profitCenter;
    @CrmExcelColumn("利润中心名称")
    private String profitCenterName;
    @CrmExcelColumn("是否上帐")
    private String isPushSap;
    @CrmExcelColumn("结案总部承担金额")
    private BigDecimal endCaseHeadFeeAmount;
    @CrmExcelColumn("结案大区承担金额")
    private BigDecimal endCaseDepartmentFeeAmount;
    @CrmExcelColumn("结案客户承担金额")
    private BigDecimal endCaseCustomerFeeAmount;
    @CrmExcelColumn("结案分子公司点内金额")
    private BigDecimal endCaseIntraCompanyAmount;
    @CrmExcelColumn("结案分子公司点外金额")
    private BigDecimal endCaseOffPointAmount;
    @CrmExcelColumn("发票代码")
    private String invoiceCode;
    @CrmExcelColumn("发票号码")
    private String invoiceNumber;
    @CrmExcelColumn("核销编码")
    private String auditCode;
    @CrmExcelColumn("核销明细编码")
    private String auditDetailCode;
    @CrmExcelColumn("折扣上帐状态")
    private String upAccountStatus;
    @CrmExcelColumn("报销上账状态")
    private String reimburseUpAccountStatus;
    @CrmExcelColumn("报销上账会计凭证号")
    private String belnr;
    @CrmExcelColumn("冲销会计凭证号")
    private String belnr2;

    /**
     * 租户编号
     */
    @ApiModelProperty("租户编号")
    @CrmExcelColumn("租户编号")
    private String tenantCode;
    /**
     * 数据状态（删除状态）
     */
    @ApiModelProperty("删除状态")
    @CrmExcelColumn("删除状态")
    private String delFlag;

    /**
     * 数据业务状态（启用状态）
     */
    @ApiModelProperty("启用状态")
    @CrmExcelColumn("启用状态")
    private String enableStatus;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    @CrmExcelColumn("备注")
    private String remark;

    /**
     * 创建人账号
     */
    @ApiModelProperty("创建人账号")
    @CrmExcelColumn("创建人账号")
    private String createAccount;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    @CrmExcelColumn("创建时间")
    private Date createTime;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    @CrmExcelColumn("创建人名称")
    private String createName;

    /**
     * 更新人账号
     */
    @ApiModelProperty("更新人账号")
    @CrmExcelColumn("更新人账号")
    private String modifyAccount;

    /**
     * 最后更新时间
     */
    @ApiModelProperty("最后更新时间")
    @CrmExcelColumn("最后更新时间")
    private Date modifyTime;

    /**
     * 修改人名称
     */
    @ApiModelProperty("修改人名称")
    @CrmExcelColumn("修改人名称")
    private String modifyName;

    @ApiModelProperty("ID")
    @CrmExcelColumn("ID")
    private String id;

    @ApiModelProperty("承接方式")
    @CrmExcelColumn("承接方式")
    private String undertakingMode;

}
