package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 行销费用批复表vo
 *
 * @author xiaoyoujun
 * @since
 */
@ApiModel(value = "MarketingApprovalVo", description = "行销费用批复表vo")
@Getter
@Setter
public class MarketingApprovalVo extends TenantFlagOpVo {

    @ApiModelProperty("大区方案编码")
    private String regionalFileCode;
    @ApiModelProperty("总部方案编码")
    private String headquartersFileCode;
    @ApiModelProperty("活动细案名称")
    private String detailPlanName;
    @ApiModelProperty("总部预算编码")
    private String headMonthBudgetCode;
    @ApiModelProperty("大区预算编码")
    private String monthBudgetCode;
    @ApiModelProperty("门店编码")
    private String terminalCode;
    @ApiModelProperty("大区数据类型")
    private String regionDataTypeCode;
    @ApiModelProperty("大区中心")
    private String regionDepartmentBelongCode;
    @ApiModelProperty("总部数据类型")
    private String headquartersDataTypeCode;
    @ApiModelProperty("总部中心")
    private String headquartersDepartmentBelongCode;
    @ApiModelProperty("客户类型")
    private String customerTypeName;
    @ApiModelProperty("目前铺市率")
    private BigDecimal currentMarketRate;
    @ApiModelProperty("月目标铺市率")
    private BigDecimal monthTargetMarketRate;
    @ApiModelProperty("预算归属业态")
    private String businessCode;
    @ApiModelProperty("RTM模式")
    private String rtmModelCode;
    @ApiModelProperty("方案编码")
    private String planCode;
    @ApiModelProperty("方案名称")
    private String planName;
    @ApiModelProperty("大区")
    private String region;
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    @ApiModelProperty("活动形式名称")
    private String activityFormName;
    @ApiModelProperty("客户编码")
    private String customerCode;
    @ApiModelProperty("客户名称")
    private String customerName;
    @ApiModelProperty("区域编码")
    private String activityOrgCode;
    @ApiModelProperty("区域名称")
    private String activityOrgName;
    @ApiModelProperty("省区编码")
    private String salesOrgCode;
    @ApiModelProperty("省区名称")
    private String salesOrgName;
    @ApiModelProperty("预算项目编码")
    private String budgetCode;
    @ApiModelProperty("预算名称")
    private String budgetName;
    @ApiModelProperty("业态编码")
    private String businessFormatCode;
    @ApiModelProperty("业态名称")
    private String businessFormatName;
    @ApiModelProperty("活动开始日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    @ApiModelProperty("活动结束日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;
    @ApiModelProperty("核销类型")
    private String auditType;
    @ApiModelProperty("核销原则编码")
    private String auditConditionCode;
    @ApiModelProperty("核销原则")
    private String auditConditionName;
    @ApiModelProperty("是否发起巡查需求")
    private String isStartPatrol;
    @ApiModelProperty("月销售任务（元）")
    private BigDecimal monthSalesTarget;
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    @ApiModelProperty("品项编码")
    private String productItemCode;
    @ApiModelProperty("品项名称")
    private String productItemName;
    @ApiModelProperty("产品编码")
    private String productCode;
    @ApiModelProperty("产品名称")
    private String productName;
    @ApiModelProperty("原品数量")
    private Integer productQuantity;
    @ApiModelProperty("赠品数量")
    private Integer giftQuantity;
    @ApiModelProperty("赠品编码")
    private String giftCode;
    @ApiModelProperty("赠品名称")
    private String giftName;
    @ApiModelProperty("形式说明")
    private String formDescription;
    @ApiModelProperty("核销方式")
    private String writeOffMethod;
    @ApiModelProperty("核销公式")
    private String auditFormulaName;
    @ApiModelProperty("一级管理渠道编码")
    private String firstChannelCode;
    @ApiModelProperty("一级管理渠道名称")
    private String firstChannelName;
    @ApiModelProperty("二级管理渠道")
    private String secondChannelCode;
    @ApiModelProperty("二级管理渠道名称")
    private String secondChannelName;
    @ApiModelProperty("是否20门店")
    private String whetherTwentyTerminal;
    @ApiModelProperty("订单开始日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderBeginDate;
    @ApiModelProperty("订单结束日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderEndDate;
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;
    @ApiModelProperty("申请金额")
    private BigDecimal applicationAmount;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;
    @ApiModelProperty("期间促销额（元）")
    private BigDecimal periodPromoteAmount;
    @ApiModelProperty("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;
    @ApiModelProperty("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;
    @ApiModelProperty("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    @ApiModelProperty("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    @ApiModelProperty("本月投入产出比")
    private BigDecimal monthPutOutputRatio;
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;
    @ApiModelProperty("赠品单价")
    private BigDecimal giftPrice;
    @ApiModelProperty("是否临时活动")
    private String isTemporary;
    @ApiModelProperty("大区方案名称")
    private String regionalFileName;
    @ApiModelProperty("总部方案名称")
    private String headquartersFileName;
    @ApiModelProperty("促销对象")
    private String promotionObject;
    @ApiModelProperty("总部统筹预算编码")
    private String headBudgetItemCode;
    @ApiModelProperty("总部统筹预算名称")
    private String headBudgetItemName;
    @ApiModelProperty("大区自控预算编码")
    private String budgetItemCode;
    @ApiModelProperty("大区自控预算名称")
    private String budgetItemName;
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;
    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;


    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    private String systemName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    private String departmentCode;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门名称")
    private String departmentName;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    private BigDecimal intraCompanyAmount;
    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    private BigDecimal offPointAmount;

    @ApiModelProperty("是否关闭")
    private String isClose;

    @ApiModelProperty("承接方式")
    private String undertakingMode;

    /**
     * 本品生产日期
     */
    @ApiModelProperty("本品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date thisProductProductionDate;

    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    private String isBigDate;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    private BigDecimal bigDateQty;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    private String templateConfigCode;
    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    private String distributionChannelName;


    private String auditYearMonth;
    private BigDecimal auditAmount;
    private BigDecimal thisAuditAmount;
    private String wholeAudit;
    private String discountTaxRate;
    private BigDecimal discountTaxAmount;
    private BigDecimal discountAmount;
    private String reimburseTaxRate;
    private BigDecimal reimburseTaxAmount;
    private BigDecimal reimburseAmount;
    private BigDecimal taxQuota;
    private String reimburseItem;
    private String reimburseItemName;
    private BigDecimal individualIncomeTax;
    private String isSpecialTicket;
    private String costCenter;
    private String costCenterName;
    private String profitCenter;
    private String profitCenterName;
    private String isPushSap;
    private BigDecimal endCaseHeadFeeAmount;
    private BigDecimal endCaseDepartmentFeeAmount;
    private BigDecimal endCaseCustomerFeeAmount;
    private BigDecimal endCaseIntraCompanyAmount;
    private BigDecimal endCaseOffPointAmount;
    private String invoiceCode;
    private String invoiceNumber;
    private String auditCode;
    private String auditDetailCode;
    private String upAccountStatus;
    private String reimburseUpAccountStatus;
    private String belnr;
    private String belnr2;
    private String orgCode;

}
