package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2023/2/21 14:42
 * @description: 下月预计上账费用Vo
 */
@Data
@ApiModel(value = "NextMonthPredictAccountFeeVo", description = "下月预计上账费用Vo")
public class NextMonthPredictAccountFeeVo {

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 系统
     */
    @ApiModelProperty("系统")
    private String systemCode;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 预估核销金额
     */
    @ApiModelProperty(name = "estimatedWriteOffAmount", notes = "预估核销金额")
    private BigDecimal estimatedWriteOffAmount;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty(name = "是否完全结案", notes = "是否完全结案")
    private String wholeAudit;

    @ApiModelProperty(name = "上账状态", notes = "上账状态")
    private String upAccountStatus;

    @ApiModelProperty("报销上账金额")
    private BigDecimal reimburseUpAccount;

    @ApiModelProperty("结案形式")
    private String endCaseForm;

    @ApiModelProperty("未上账金额")
    private BigDecimal unaccountedAmount;
}
