package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 活动细案对账单据(ActivityDetailPlan)
 *
 * @author xiaoyoujun
 * @since 2022-11-22 18:22:21
 */
@ApiModel(value = "ReconciliationActivityVo", description = "活动对账单据VO")
@Getter
@Setter
public class ReconciliationActivityVo extends TenantFlagOpVo {

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;
    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    private String activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    private String activityEndDate;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;
    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String terminalName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    private String auditForm;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal feeAmount;
    /**
     * 系统
     */
    @ApiModelProperty(name = "systemName",value = "系统",notes = "系统")
    private String systemName;
    /**
     * 系统编码
     */
    @ApiModelProperty(name = "systemCode",value = "系统编码",notes = "系统编码")
    private String systemCode;
}
