package com.biz.crm.tpm.business.activity.detail.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 销售费用批复表vo
 *
 * @author xiaoyoujun
 * @since
 */
@ApiModel(value = "SalesApprovalExportVo", description = "销售费用批复表导出vo")
@Getter
@Setter
@CrmExcelExport
public class SalesApprovalExportVo extends CrmExcelVo {

    @ApiModelProperty("业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("大区批复文件编码")
    @CrmExcelColumn("大区批复文件编码")
    private String regionalFileCode;
    @ApiModelProperty("总部批复文件编码")
    @CrmExcelColumn("总部批复文件编码")
    private String headquartersFileCode;
    @ApiModelProperty("活动细案名称")
    @CrmExcelColumn("活动细案名称")
    private String detailPlanName;
    @ApiModelProperty("总部预算编码")
    @CrmExcelColumn("总部预算编码")
    private String headMonthBudgetCode;
    @ApiModelProperty("大区预算编码")
    @CrmExcelColumn("大区预算编码")
    private String monthBudgetCode;
    @ApiModelProperty("门店编码")
    @CrmExcelColumn("门店编码")
    private String terminalCode;
    @ApiModelProperty("大区数据类型")
    @CrmExcelColumn("大区数据类型")
    private String regionDataTypeCode;
    @ApiModelProperty("大区中心")
    @CrmExcelColumn("大区中心")
    private String regionDepartmentBelongCode;
    @ApiModelProperty("总部数据类型")
    @CrmExcelColumn("总部数据类型")
    private String headquartersDataTypeCode;
    @ApiModelProperty("总部中心")
    @CrmExcelColumn("总部中心")
    private String headquartersDepartmentBelongCode;
    @ApiModelProperty("客户类型")
    @CrmExcelColumn("客户类型")
    private String customerTypeName;
    @ApiModelProperty("目前铺市率")
    @CrmExcelColumn("目前铺市率")
    private BigDecimal currentMarketRate;
    @ApiModelProperty("月目标铺市率")
    @CrmExcelColumn("月目标铺市率")
    private BigDecimal monthTargetMarketRate;
    @ApiModelProperty("预算归属业态")
    @CrmExcelColumn("预算归属业态")
    private String businessCode;
    @ApiModelProperty("RTM模式")
    @CrmExcelColumn("RTM模式")
    private String rtmModelCode;
    @ApiModelProperty("方案编码")
    @CrmExcelColumn("方案编码")
    private String planCode;
    @ApiModelProperty("方案名称")
    @CrmExcelColumn("方案名称")
    private String planName;
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;
    @ApiModelProperty("客户编码")
    @CrmExcelColumn("客户编码")
    private String customerCode;
    @ApiModelProperty("客户名称")
    @CrmExcelColumn("客户名称")
    private String customerName;
    @ApiModelProperty("大区")
    @CrmExcelColumn("大区")
    private String region;
    @ApiModelProperty("区域编码")
    @CrmExcelColumn("区域编码")
    private String activityOrgCode;
    @ApiModelProperty("区域名称")
    @CrmExcelColumn("区域名称")
    private String activityOrgName;
    @ApiModelProperty("所属销售大区编码")
    @CrmExcelColumn("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区名称")
    @CrmExcelColumn("所属销售大区名称")
    private String salesRegionName;
    @ApiModelProperty("省区编码")
    @CrmExcelColumn("省区编码")
    private String salesOrgCode;
    @ApiModelProperty("省区名称")
    @CrmExcelColumn("省区名称")
    private String salesOrgName;


    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    @CrmExcelColumn("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    @CrmExcelColumn("零售商名称")
    private String systemName;
    @ApiModelProperty("总部统筹预算编码")
    @CrmExcelColumn("总部统筹预算编码")
    private String headBudgetItemCode;
    @ApiModelProperty("总部统筹预算名称")
    @CrmExcelColumn("总部统筹预算名称")
    private String headBudgetItemName;
    @ApiModelProperty("大区自控预算编码")
    @CrmExcelColumn("大区自控预算编码")
    private String budgetItemCode;
    @ApiModelProperty("大区自控预算名称")
    @CrmExcelColumn("大区自控预算名称")
    private String budgetItemName;
    @ApiModelProperty("业态编码")
    @CrmExcelColumn("业态编码")
    private String businessFormatCode;
    @ApiModelProperty("业态名称")
    @CrmExcelColumn("业态名称")
    private String businessFormatName;
    @ApiModelProperty("活动开始日期")
    @CrmExcelColumn("活动开始日期")
    private Date activityBeginDate;
    @ApiModelProperty("活动结束日期")
    @CrmExcelColumn("活动结束日期")
    private Date activityEndDate;
    @ApiModelProperty("是否发起巡查需求")
    @CrmExcelColumn("是否发起巡查需求")
    private String isStartPatrol;
    @ApiModelProperty("月销售任务（元）")
    @CrmExcelColumn("月销售任务（元）")
    private BigDecimal monthSalesTarget;
    @ApiModelProperty("核销原则编码")
    @CrmExcelColumn("核销原则编码")
    private String auditConditionCode;
    @ApiModelProperty("核销原则")
    @CrmExcelColumn("核销原则")
    private String auditConditionName;
    @ApiModelProperty("品牌编码")
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    @ApiModelProperty("品牌名称")
    @CrmExcelColumn("品牌名称")
    private String productBrandName;
    @ApiModelProperty("品类编码")
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    @ApiModelProperty("品类名称")
    @CrmExcelColumn("品类名称")
    private String productCategoryName;
    @ApiModelProperty("品项编码")
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    @ApiModelProperty("品项名称")
    @CrmExcelColumn("品项名称")
    private String productItemName;
    @ApiModelProperty("产品编码")
    @CrmExcelColumn("产品编码")
    private String productCode;
    @ApiModelProperty("产品名称")
    @CrmExcelColumn("产品名称")
    private String productName;
    @ApiModelProperty("原品数量")
    @CrmExcelColumn("原品数量")
    private Integer productQuantity;
    @ApiModelProperty("赠品数量")
    @CrmExcelColumn("赠品数量")
    private Integer giftQuantity;
    @ApiModelProperty("赠品编码")
    @CrmExcelColumn("赠品编码")
    private String giftCode;
    @ApiModelProperty("赠品名称")
    @CrmExcelColumn("赠品名称")
    private String giftName;
    @ApiModelProperty("形式说明")
    @CrmExcelColumn("形式说明")
    private String formDescription;
    @ApiModelProperty("一级管理渠道编码")
    @CrmExcelColumn("一级管理渠道编码")
    private String firstChannelCode;
    @ApiModelProperty("一级管理渠道名称")
    @CrmExcelColumn("一级管理渠道名称")
    private String firstChannelName;
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn("二级管理渠道")
    private String secondChannelCode;
    @ApiModelProperty("二级管理渠道名称")
    @CrmExcelColumn("二级管理渠道名称")
    private String secondChannelName;
    @ApiModelProperty("订单开始日期")
    @CrmExcelColumn("订单开始日期")
    private Date orderBeginDate;
    @ApiModelProperty("订单结束日期")
    @CrmExcelColumn("订单结束日期")
    private Date orderEndDate;
    @ApiModelProperty("费用合计")
    @CrmExcelColumn("费用合计")
    private BigDecimal totalFeeAmount;
    @ApiModelProperty("单价")
    @CrmExcelColumn("单价")
    private BigDecimal price;
    @ApiModelProperty("期间促销量（件）")
    @CrmExcelColumn("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;
    @ApiModelProperty("期间促销额（元）")
    @CrmExcelColumn("期间促销额（元）")
    private BigDecimal periodPromoteAmount;
    @ApiModelProperty("期间渠道促销量（件）")
    @CrmExcelColumn("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;
    @ApiModelProperty("期间渠道促销额（元）")
    @CrmExcelColumn("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;
    @ApiModelProperty("是否20门店")
    @CrmExcelColumn("是否20门店")
    private String whetherTwentyTerminal;
    @ApiModelProperty("全月回复量（件）")
    @CrmExcelColumn("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    @ApiModelProperty("全月回复额（元）")
    @CrmExcelColumn("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    @ApiModelProperty("本月投入产出比")
    @CrmExcelColumn("本月投入产出比")
    private BigDecimal monthPutOutputRatio;
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;
    @ApiModelProperty("赠品单价")
    @CrmExcelColumn("赠品单价")
    private BigDecimal giftPrice;
    @ApiModelProperty("是否临时活动")
    @CrmExcelColumn("是否临时活动")
    private String isTemporary;
    @ApiModelProperty("大区批复文件名称")
    @CrmExcelColumn("大区批复文件名称")
    private String regionalFileName;
    @ApiModelProperty("总部批复文件名称")
    @CrmExcelColumn("总部批复文件名称")
    private String headquartersFileName;
    @ApiModelProperty("是否涨价政策")
    @CrmExcelColumn("是否涨价政策")
    private String increasePricePromotion;
    @ApiModelProperty("是否责任利润调整")
    @CrmExcelColumn("是否责任利润调整")
    private String dutyProfitAdjust;
    @ApiModelProperty("促销对象")
    @CrmExcelColumn("促销对象")
    private String promotionObject;
    @ApiModelProperty("新品归类")
    @CrmExcelColumn("新品归类")
    private String newProductType;
    @ApiModelProperty("是否占用划拨预算")
    @CrmExcelColumn("是否占用划拨预算")
    private String occupyTransferBudget;
    @ApiModelProperty("总部承担金额")
    @CrmExcelColumn("总部承担金额")
    private BigDecimal headFeeAmount;
    @ApiModelProperty("大区承担金额")
    @CrmExcelColumn("大区承担金额")
    private BigDecimal departmentFeeAmount;
    @ApiModelProperty("客户承担金额")
    @CrmExcelColumn("客户承担金额")
    private BigDecimal customerFeeAmount;
    @ApiModelProperty("是否考核扣款")
    @CrmExcelColumn("是否考核扣款")
    private String isDeductionFeePool;
    @ApiModelProperty("活动细案编码")
    @CrmExcelColumn("活动细案编码")
    private String detailPlanCode;
    @ApiModelProperty("活动细案明细编码")
    @CrmExcelColumn("活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    @CrmExcelColumn("部门编码")
    private String departmentCode;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门名称")
    @CrmExcelColumn("部门名称")
    private String departmentName;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    @CrmExcelColumn("分子公司点内金额")
    private BigDecimal intraCompanyAmount;
    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    @CrmExcelColumn("分子公司点外金额")
    private BigDecimal offPointAmount;
    /**
     * 租户编号
     */
    @ApiModelProperty("租户编号")
    @CrmExcelColumn("租户编号")
    private String tenantCode;
    /**
     * 数据状态（删除状态）
     */
    @ApiModelProperty("删除状态")
    @CrmExcelColumn("删除状态")
    private String delFlag;

    /**
     * 数据业务状态（启用状态）
     */
    @ApiModelProperty("启用状态")
    @CrmExcelColumn("启用状态")
    private String enableStatus;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    @CrmExcelColumn("备注")
    private String remark;

    @CrmExcelColumn("是否关闭")
    private String isClose;

    @CrmExcelColumn("结案年月")
    private String auditYearMonth;
    @CrmExcelColumn("预核销金额")
    private BigDecimal auditAmount;
    @CrmExcelColumn("已结案金额")
    private BigDecimal thisAuditAmount;
    @CrmExcelColumn("是否完全结案")
    private String wholeAudit;
    @CrmExcelColumn("折扣税率")
    private String discountTaxRate;
    @CrmExcelColumn("折扣应处理金额")
    private BigDecimal discountTaxAmount;
    @CrmExcelColumn("入费用池金额")
    private BigDecimal discountAmount;
    @CrmExcelColumn("报销税率")
    private String reimburseTaxRate;
    @CrmExcelColumn("报销金额(含税)")
    private BigDecimal reimburseTaxAmount;
    @CrmExcelColumn("报销金额(未税)")
    private BigDecimal reimburseAmount;
    @CrmExcelColumn("税额")
    private BigDecimal taxQuota;
    @CrmExcelColumn("报销项目编码")
    private String reimburseItem;
    @CrmExcelColumn("报销项目名称")
    private String reimburseItemName;
    @CrmExcelColumn("个人所得税金额")
    private BigDecimal individualIncomeTax;
    @CrmExcelColumn("是否专票")
    private String isSpecialTicket;
    @CrmExcelColumn("成本中心编码")
    private String costCenter;
    @CrmExcelColumn("成本中心名称")
    private String costCenterName;
    @CrmExcelColumn("利润中心编码")
    private String profitCenter;
    @CrmExcelColumn("利润中心名称")
    private String profitCenterName;
    @CrmExcelColumn("是否上帐")
    private String isPushSap;
    @CrmExcelColumn("结案总部承担金额")
    private BigDecimal endCaseHeadFeeAmount;
    @CrmExcelColumn("结案大区承担金额")
    private BigDecimal endCaseDepartmentFeeAmount;
    @CrmExcelColumn("结案客户承担金额")
    private BigDecimal endCaseCustomerFeeAmount;
    @CrmExcelColumn("结案分子公司点内金额")
    private BigDecimal endCaseIntraCompanyAmount;
    @CrmExcelColumn("结案分子公司点外金额")
    private BigDecimal endCaseOffPointAmount;
    @CrmExcelColumn("发票代码")
    private String invoiceCode;
    @CrmExcelColumn("发票号码")
    private String invoiceNumber;
    @CrmExcelColumn("核销编码")
    private String auditCode;
    @CrmExcelColumn("核销明细编码")
    private String auditDetailCode;
    @CrmExcelColumn("折扣上帐状态")
    private String upAccountStatus;
    @CrmExcelColumn("报销上账状态")
    private String reimburseUpAccountStatus;
    @CrmExcelColumn("报销上账会计凭证号")
    private String belnr;
    @CrmExcelColumn("冲销会计凭证号")
    private String belnr2;



    /**
     * 创建人账号
     */
    @ApiModelProperty("创建人账号")
    @CrmExcelColumn("创建人账号")
    private String createAccount;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    @CrmExcelColumn("创建时间")
    private Date createTime;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    @CrmExcelColumn("创建人名称")
    private String createName;

    /**
     * 更新人账号
     */
    @ApiModelProperty("更新人账号")
    @CrmExcelColumn("更新人账号")
    private String modifyAccount;

    /**
     * 最后更新时间
     */
    @ApiModelProperty("最后更新时间")
    @CrmExcelColumn("最后更新时间")
    private Date modifyTime;

    /**
     * 修改人名称
     */
    @ApiModelProperty("修改人名称")
    @CrmExcelColumn("修改人名称")
    private String modifyName;

    @ApiModelProperty("ID")
    @CrmExcelColumn("ID")
    private String id;

    @ApiModelProperty("承接方式")
    @CrmExcelColumn("承接方式")
    private String undertakingMode;

}
