package com.biz.crm.tpm.business.activity.form.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.form.feign.feign.impl.ActivityFormFeignImpl;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 20:51
 * @description：活动形式
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ActivityFormFeignImpl.class)
public interface ActivityFormFeign {

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/v1/activityForm/findByConditions")
    Result<Page<ActivityFormVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "activityForm", value = "活动形式") @SpringQueryMap ActivityFormDto activityForm);

    @PostMapping("/v1/activityForm/findActivityFormByCode")
    Result<List<ActivityFormVo>> findActivityFormByCode(@RequestBody Set<String> activityFormCodes);

    @ApiOperation(value = "根据活动形式编码获取有效的活动形式信息")
    @PostMapping("/v1/activityForm/findFormByCodes")
    Result<Map<String, String>> findFormByCodes(List<List<String>> formCodes);

    @ApiOperation("通过code查询活动形式")
    @GetMapping("findOneByCode")
    Result<ActivityFormVo> findOneByCode(@RequestParam("code") String code);

    @ApiOperation(value = "查询所有需推送SAP的活动形式编码")
    @PostMapping("/v1/activityForm/findSapCodeByCodes")
    @Deprecated
    Result<Map<String, String>> findSapCodeByCodes(List<String> codes);

    @GetMapping("/v1/activityForm/{id}")
    Result<ActivityFormVo> findById(@PathVariable String id);

    @PostMapping("/v1/activityForm")
    Result<ActivityFormVo> create(@RequestBody ActivityFormDto activityForm);

    @PostMapping(value = "/v1/activityForm/disablePos")
    Result<?> disable(@RequestBody List<String> ids);
}
