package com.biz.crm.tpm.business.activity.form.feign.feign.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.form.feign.feign.ActivityFormFeign;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 20:52
 * @description：活动形式
 */
@Component
public class ActivityFormFeignImpl implements FallbackFactory<ActivityFormFeign> {

    @Override
    public ActivityFormFeign create(Throwable cause) {
        return new ActivityFormFeign() {
            @Override
            public Result<Page<ActivityFormVo>> findByConditions(Pageable pageable, ActivityFormDto activityForm) {
                throw new UnsupportedOperationException("条件查询熔断");
            }

            @Override
            public Result<List<ActivityFormVo>> findActivityFormByCode(Set<String> activityFormCodes) {
                throw new UnsupportedOperationException("查询熔断");
            }

            @Override
            public Result<Map<String, String>> findFormByCodes(List<List<String>> formCodes) {
                throw new UnsupportedOperationException("查询熔断");
            }

            @Override
            public Result<ActivityFormVo> findOneByCode(String code) {
                throw new UnsupportedOperationException("查询熔断");
            }

            @Override
            public Result<Map<String, String>> findSapCodeByCodes(List<String> codes) {
                throw new UnsupportedOperationException("查询熔断");
            }

            @Override
            public Result<ActivityFormVo> findById(String id) {
                throw new UnsupportedOperationException("查询活动模板配置详情熔断");
            }

            @Override
            public Result<ActivityFormVo> create(ActivityFormDto activityForm) {
                throw new UnsupportedOperationException("创建活动模板配置熔断");
            }

            @Override
            public Result<?> disable(List<String> ids) {
                throw new UnsupportedOperationException("禁用活动模板配置熔断");
            }
        };
    }
}
