package com.biz.crm.tpm.business.activity.form.feign.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.feign.feign.ActivityFormFeign;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormPopEctDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormPopEctVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 20:54
 * @description：活动形式
 */
@Service
public class ActivityFormImpl implements ActivityFormService {

    @Autowired(required = false)
    private ActivityFormFeign activityFormFeign;

    @Override
    public Page<ActivityFormVo> findByConditions(Pageable pageable, ActivityFormDto activityForm) {
        Result<Page<ActivityFormVo>> activityFormPage = activityFormFeign.findByConditions(pageable, activityForm);
        if(activityFormPage.isSuccess()){
            return activityFormPage.getResult();
        }else {
            return new Page<>();
        }
    }

    @Override
    public List<ActivityFormVo> findListByConditions(ActivityFormDto activityForm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActivityFormVo findById(String id) {
        return activityFormFeign.findById(id).getResult();
    }

    @Override
    public ActivityFormVo create(ActivityFormDto activityForm) {
        Result<ActivityFormVo> result = activityFormFeign.create(activityForm);
        if(!result.isSuccess()){
            throw new UnsupportedOperationException("活动形式创建失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public void update(ActivityFormDto activityForm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAuditCondition(ActivityFormDto activityForm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(List<String> idList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableBatch(List<String> ids) {
        Result<?> result = activityFormFeign.disable(ids);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("活动形式警用失败：" + result.getMessage());
        }
    }

    @Override
    public List<ActivityFormVo> getList(ActivityFormDto activityForm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ActivityFormVo> findSelectList(ActivityFormSelectDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ActivityFormVo> findActivityFormByCode(Set<String> activityFormCodes) {

        Result<List<ActivityFormVo>> activityFormVoResult = activityFormFeign.findActivityFormByCode(activityFormCodes);
        if(activityFormVoResult.isSuccess()){
            return activityFormVoResult.getResult();
        }else {
            return new ArrayList<>();
        }
    }

    @Override
    public ActivityFormVo findOneByCode(String code) {
        Result<ActivityFormVo> activityFormVoResult = activityFormFeign.findOneByCode(code);
        if(activityFormVoResult.isSuccess()){
            return activityFormVoResult.getResult();
        }
        return null;
    }

    @Override
    public List<ActivityFormVo> findByCodes(List<String> codes) {
        return null;
    }

    @Override
    public Map<String, List<ActivityFormExeDetailVo>> findPushOrderSharePlatform(List<String> formCodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<ActivityFormExeDetailVo>> findPushSap(List<String> formCodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> findSapCode(List<String> formCodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String,String> findPushCowManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> findFormByCodes(List<List<String>> formCodes) {
        Result<Map<String, String>> activityFormVoResult = activityFormFeign.findFormByCodes(formCodes);
        if(activityFormVoResult.isSuccess()){
            return activityFormVoResult.getResult();
        }else {
            return new HashMap<>();
        }
    }

    /**
     * 通过code查询活动形式
     * @param names
     * @return
     */
    @Override
    public List<ActivityFormVo> findByNames(List<String> names) {
        throw new UnsupportedOperationException();
    }

    /**
     * 活动形式SAP编码为ZS03
     *
     * @param formCodes
     * @return
     */
    @Override
    public List<String> findFormByCodesZs03(List<List<String>> formCodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> findFormByCodesZs42(List<List<String>> formCodes) {throw new UnsupportedOperationException();}

    @Override
    public List<SubRelatedMainActivityFormVo> findSubRelatedMainByCodes(List<String> mainFormCodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActivityFormVo findFormAndRelatedTypeCode(String activityFormCode, String tenantCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ActivityFormVo> findFormAndRelatedTypeCodes(List<String> activityFormCodes, String tenantCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<ActivityFormPopEctVo> findActivityFormPopEct(Pageable pageable, ActivityFormPopEctDto activityFormPopEctDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> findActivityFormCodeFromPromotionsType(String businessUnitCode, String verticalActivityType, String pushExeSystemCode) {
        throw new UnsupportedOperationException();
    }
}
