package com.biz.crm.tpm.business.activity.form.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormAudit;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormAuditService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动形式的核销资料(ActivityFormAudit)表相关的http接口
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
@RestController
@RequestMapping("/v1/activityFormAudit")
@Slf4j
@Api(tags = "活动形式的核销资料")
public class ActivityFormAuditController {
  /**
  * 服务对象
  */
  @Autowired
  private ActivityFormAuditService activityFormAuditService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param activityFormAudit 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<ActivityFormAudit>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "activityFormAudit", value = "活动形式的核销资料") ActivityFormAudit activityFormAudit) {
    try {
      Page<ActivityFormAudit> page =  this.activityFormAuditService.findByConditions(pageable,activityFormAudit);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<ActivityFormAudit> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      ActivityFormAudit activityFormAudit = this.activityFormAuditService.findById(id);
      return Result.ok(activityFormAudit);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param activityFormAudit 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<ActivityFormAudit> create(@ApiParam(name = "activityFormAudit", value = "活动形式的核销资料") @RequestBody ActivityFormAudit activityFormAudit) {
    try {
      ActivityFormAudit result = this.activityFormAuditService.create(activityFormAudit);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param activityFormAudit 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<ActivityFormAudit> update(@ApiParam(name = "activityFormAudit", value = "活动形式的核销资料") @RequestBody ActivityFormAudit activityFormAudit) {
    try {
      ActivityFormAudit result = this.activityFormAuditService.update(activityFormAudit);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.activityFormAuditService.delete(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
