package com.biz.crm.tpm.business.activity.form.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormCollectField;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormCollectFieldService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动采集字段(ActivityFormCollectField)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-07 13:50:33
 */
@RestController
@RequestMapping("/v1/activityFormCollectField")
@Slf4j
@Api(tags = "活动采集字段")
public class ActivityFormCollectFieldController {
  /**
  * 服务对象
  */
  @Autowired
  private ActivityFormCollectFieldService activityFormCollectFieldService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param activityFormCollectField 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<ActivityFormCollectField>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
												   @ApiParam(name = "activityFormCollectField", value = "活动采集字段") ActivityFormCollectField activityFormCollectField) {
    try {
      Page<ActivityFormCollectField> page =  this.activityFormCollectFieldService.findByConditions(pageable,activityFormCollectField);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<ActivityFormCollectField> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      ActivityFormCollectField activityFormCollectField = this.activityFormCollectFieldService.findById(id);
      return Result.ok(activityFormCollectField);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param activityFormCollectField 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<ActivityFormCollectField> create(@ApiParam(name = "activityFormCollectField", value = "活动采集字段") @RequestBody ActivityFormCollectField activityFormCollectField) {
    try {
      ActivityFormCollectField result = this.activityFormCollectFieldService.create(activityFormCollectField);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param activityFormCollectField 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<ActivityFormCollectField> update(@ApiParam(name = "activityFormCollectField", value = "活动采集字段") @RequestBody ActivityFormCollectField activityFormCollectField) {
    try {
      ActivityFormCollectField result = this.activityFormCollectFieldService.update(activityFormCollectField);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.activityFormCollectFieldService.delete(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
