package com.biz.crm.tpm.business.activity.form.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityForm;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormPopEctDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormPopEctVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 活动形式(ActivityForm)表相关的http接口
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
@RestController
@RequestMapping("/v1/activityForm")
@Slf4j
@Api(tags = "活动形式")
public class ActivityFormController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActivityFormService activityFormService;

    /**
     * 分页查询所有数据
     *
     * @param pageable     分页对象
     * @param activityForm 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ActivityFormVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "activityForm", value = "活动形式") ActivityFormDto activityForm) {
        try {
            Page<ActivityFormVo> page = this.activityFormService.findByConditions(pageable, activityForm);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<ActivityFormVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            ActivityFormVo activityForm = this.activityFormService.findById(id);
            return Result.ok(activityForm);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("/findByCode")
    public Result<ActivityFormVo> findByCode(@RequestParam(value = "code") @ApiParam(name = "code", value = "主键id") String code) {
        try {
            ActivityFormVo activityForm = this.activityFormService.findOneByCode(code);
            return Result.ok(activityForm);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param activityForm 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<ActivityFormVo> create(@ApiParam(name = "activityForm", value = "活动形式") @RequestBody ActivityFormDto activityForm) {
        try {
            ActivityFormVo result = this.activityFormService.create(activityForm);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, ActivityForm.class));
        }
    }

    /**
     * 修改数据
     *
     * @param activityForm 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "activityForm", value = "活动形式") @RequestBody ActivityFormDto activityForm) {
        try {
            this.activityFormService.update(activityForm);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @PostMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.activityFormService.delete(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.activityFormService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.activityFormService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PostMapping("/disablePos")
    public Result<?> disablePos(@RequestBody List<String> ids) {
        try {
            this.activityFormService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("下拉列表")
    @PostMapping("getList")
    public Result<List<ActivityFormVo>> getList(@RequestBody ActivityFormDto activityForm) {
        try {
            return Result.ok(this.activityFormService.getList(activityForm));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     */
    @ApiOperation(value = "活动形式下拉")
    @PostMapping("findActivityFormSelectList")
    public Result<List<CommonSelectVo>> findActivityFormSelectList(@ApiParam(name = "CommonSelectDto", value = "查询参数") @RequestBody ActivityFormSelectDto dto) {
        try {
            List<CommonSelectVo> list = activityFormService.findActivityFormSelectList(dto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动形式下拉（分子公司规划、细案用）
     *
     * @param dto 活动形式查询参数
     */
    @ApiOperation(value = "活动形式下拉（分子公司规划、细案用）")
    @PostMapping("findSelectList")
    public Result<List<ActivityFormVo>> findSelectList(@ApiParam(name = "CommonSelectDto", value = "查询参数") @RequestBody ActivityFormSelectDto dto) {
        try {
            List<ActivityFormVo> list = activityFormService.findSelectList(dto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过活动形式code查询活动形式
     *
     * @param activityFormCodes 活动形式codes
     * @return
     */
    @ApiOperation(value = "通过活动形式code查询活动形式")
    @PostMapping("findActivityFormByCode")
    public Result<List<ActivityFormVo>> findActivityFormByCode(@RequestBody Set<String> activityFormCodes) {
        try {
            return Result.ok(activityFormService.findActivityFormByCode(activityFormCodes));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("通过code查询活动形式")
    @GetMapping("findOneByCode")
    public Result<ActivityFormVo> findOneByCode(@RequestParam("code") String code){
        try {
            return Result.ok(activityFormService.findOneByCode(code));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据活动形式编码获取有效的活动形式信息
     *
     * @param formCodes 活动形式编码集合
     * @return Result<Map < String, String>>
     */
    @ApiOperation(value = "根据活动形式编码获取有效的活动形式信息")
    @PostMapping("findFormByCodes")
    public Result<Map<String, String>> findFormByCodes(@RequestBody List<List<String>> formCodes) {
        try {
            Map<String, String> map = this.activityFormService.findFormByCodes(formCodes);
            return Result.ok(map);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "testtest")
    @PostMapping("testtset")
    public Result<List<SubRelatedMainActivityFormVo>> test(@RequestBody List<String> formCodes) {
        try {
            List<SubRelatedMainActivityFormVo> subRelatedMainByCodes = this.activityFormService.findSubRelatedMainByCodes(formCodes);
            return Result.ok(subRelatedMainByCodes);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "分页查询重客垂直的活动形式，ect系统用")
    @GetMapping("findActivityFormPopEct")
    public Result<Page<ActivityFormPopEctVo>> findActivityFormPopEct(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                     @ApiParam(name = "activityFormPopEctDto", value = "活动形式") ActivityFormPopEctDto activityFormPopEctDto) {
        try {
            Page<ActivityFormPopEctVo> page = this.activityFormService.findActivityFormPopEct(pageable, activityFormPopEctDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
